/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 商城订单详细Entity
 * @author lyy
 * @version 2016-08-23
 */
public class ShopOrderDetail extends DataEntity<ShopOrderDetail> {
	
	private static final long serialVersionUID = 1L;
	private String goodsId;		// 商品主键
	private String goodsName;		// 商品名称
	private String goodsPrice;	//商品单价
	private String goodsNum;		// 商品数量
	private String shopOrderCode;		// shop_order_code
	private String memberCode;		// 会员号
	private String memberName;		// 会员名称
	private Date addDate;		// 添加时间
	private String totalPrice;		// 总价
	private String postPrice;		//邮费
	private String isBuyGifts;	//是否是赠品
	private String returnNum;	 	//退回数量
	private String returnRemarks;	//退回原因

	
	public ShopOrderDetail() {
		super();
	}

	public ShopOrderDetail(String id){
		super(id);
	}

	@Length(min=1, max=64, message="商品主键长度必须介于 1 和 64 之间")
	public String getGoodsId() {
		return goodsId;
	}

	public void setGoodsId(String goodsId) {
		this.goodsId = goodsId;
	}
	
	@Length(min=0, max=100, message="商品名称长度必须介于 0 和 100 之间")
	public String getGoodsName() {
		return goodsName;
	}

	public void setGoodsName(String goodsName) {
		this.goodsName = goodsName;
	}
	
	@Length(min=0, max=11, message="商品数量长度必须介于 0 和 11 之间")
	public String getGoodsNum() {
		return goodsNum;
	}

	public void setGoodsNum(String goodsNum) {
		this.goodsNum = goodsNum;
	}
	
	@Length(min=0, max=100, message="shop_order_code长度必须介于 0 和 100 之间")
	public String getShopOrderCode() {
		return shopOrderCode;
	}

	public void setShopOrderCode(String shopOrderCode) {
		this.shopOrderCode = shopOrderCode;
	}
	
	@Length(min=0, max=64, message="会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=50, message="会员名称长度必须介于 0 和 50 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddDate() {
		return addDate;
	}

	public void setAddDate(Date addDate) {
		this.addDate = addDate;
	}
	
	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	public String getGoodsPrice() {
		return goodsPrice;
	}

	public void setGoodsPrice(String goodsPrice) {
		this.goodsPrice = goodsPrice;
	}

	public String getPostPrice() {
		return postPrice;
	}

	public void setPostPrice(String postPrice) {
		this.postPrice = postPrice;
	}

	public String getIsBuyGifts() {
		return isBuyGifts;
	}

	public void setIsBuyGifts(String isBuyGifts) {
		this.isBuyGifts = isBuyGifts;
	}
	@Length(min=0, max=11, message="退货数量长度必须介于 0 和 11 之间")
	public String getReturnNum() {
		return returnNum;
	}

	public void setReturnNum(String returnNum) {
		this.returnNum = returnNum;
	}
	@Length(min=0, max=255, message="退货原因长度必须介于 0 和 255 之间")
	public String getReturnRemarks() {
		return returnRemarks;
	}

	public void setReturnRemarks(String returnRemarks) {
		this.returnRemarks = returnRemarks;
	}
}