package com.cku.oa.sfexpress.service;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONObject;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sfexpress.dao.SfExpressStateDao;
import com.cku.oa.sfexpress.entity.ExpressPushEntity;
import com.cku.oa.sfexpress.entity.RoutePushRequest;
import com.cku.oa.sfexpress.entity.RouteResponse;
import com.cku.oa.sfexpress.entity.Routes;
import com.cku.oa.sfexpress.entity.SfExpressState;
import com.cku.oa.sfexpress.entity.SfExpressStateVo;
import com.cku.oa.sys.dao.ExpressQueueDao;
import com.cku.oa.sys.dao.ExpressSendDao;
import com.cku.oa.sys.entity.ExpressQueue;
import com.cku.oa.sys.entity.ExpressSend;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 顺丰Service
 * 
 * @author zhaoxy
 * @version 2019-08-30
 */
@Service
@Transactional(readOnly = true)
public class SfExpressStateService extends CrudService<SfExpressStateDao, SfExpressState> {

	@Autowired
	private SfExpressStateDao sfExpressStateDao;

	@Autowired
	private ExpressSendDao expressSendDao;

	@Autowired
	private ExpressQueueDao expressQueueDao;

	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;

	// 揽收记录
	@Transactional(readOnly = false)
	public void pushOrderState(ExpressPushEntity entity) {
		// bean 转换
		SfExpressState sfExpressState = new SfExpressState();
		sfExpressState.setBooktime(entity.getBookTime());
		sfExpressState.setCarriercode(entity.getCarrierCode());
		sfExpressState.setEmpcode(entity.getEmpCode());
		sfExpressState.setEmpphone(entity.getEmpPhone());
		sfExpressState.setLasttime(entity.getLastTime());
		sfExpressState.setOrderNo(entity.getOrderNo());
		sfExpressState.setOrderStateCode(entity.getOrderStateCode());
		sfExpressState.setOrderStateDesc(entity.getOrderStateDesc());
		sfExpressState.setWaybillNo(entity.getWaybillNo());
		sfExpressState.setCreateTime(new Date());

		this.save(sfExpressState);
	}

	@Transactional(readOnly = false)
	public void newPushRoute(JSONObject jsonObj) {
		SfExpressState sfExpressState = new SfExpressState();
		sfExpressState.setOrderNo(jsonObj.getString("orderid"));
		sfExpressState.setWaybillNo(jsonObj.getString("mailno"));
		sfExpressState.setOrderStateCode(jsonObj.getString("opCode"));
		sfExpressState.setOrderStateDesc(jsonObj.getString("remark"));
		sfExpressState.setCreateTime(DateUtils.parseDate(jsonObj.getString("acceptTime")));
		sfExpressState.setNetcode(jsonObj.getString("acceptAddress"));
		this.save(sfExpressState);
	}

	// 路由记录
	@Transactional(readOnly = false)
	public void pushRoute(RoutePushRequest routePushEntity, RouteResponse routeResponse) {
		// 增量添加路由信息
		if (routeResponse != null) {
			SfExpressState sfExpressState = new SfExpressState();
			sfExpressState.setOrderNo(routeResponse.getBody().getRoutesResponse().getOrderid());
			sfExpressState.setWaybillNo(routeResponse.getBody().getRoutesResponse().getMailno());
			sfExpressState.setOrderStateCode(routePushEntity.getBody().getWaybillRoute().getOpCode());
			// 只保存当前状态的路由（路由查询会查询出路由时间轴：路由推送只推送当前状态）
			for (Routes routes : routeResponse.getBody().getRoutesResponse().getRoutes()) {
				if (routes.getOpcode().equals(sfExpressState.getOrderStateCode())) {
					sfExpressState.setOrderStateDesc(routes.getRemark());
					sfExpressState.setCreateTime(routes.getAccept_time());
					sfExpressState.setNetcode(routes.getAccept_address());
				}
			}

			this.save(sfExpressState);
			// 签收后处理
			if ("80".equals(sfExpressState.getOrderStateCode())) {
				ExpressSend result = expressSendDao.selectByOrderNo(sfExpressState.getOrderNo());
				if (result.getReceiveDate() == null) {
					logger.info("===== 运单号:{} 已签收", sfExpressState.getOrderNo());
					// 财务收入确认时点
					updateSaPayment(sfExpressState.getOrderNo(), sfExpressState);
				}
			}
		}
	}

	// 财务收入确认时点
	@Transactional(readOnly = false)
	public void updateSaPayment(String expressNo, SfExpressState sfExpressState) {
		// 查询运单
		ExpressSend expressSend = expressSendDao.selectByOrderNo(expressNo);
		if (expressSend != null) {
			ExpressQueue entity = new ExpressQueue();
			entity.setExpressSendId(expressSend.getId());
			// 查询运单邮寄的物品
			List<ExpressQueue> queues = expressQueueDao.findList(entity);
			for (ExpressQueue queue : queues) {
				if (StringUtils.isNotEmpty(queue.getBusinessTable()) && StringUtils.isNotEmpty(queue.getBusinessId())) {
					// TODO 财务收入确认时点
					saPaymentDetailTotalService.financeConfirmTime(queue.getBusinessId(), queue.getBusinessTable());
					// 修改邮寄表签收时间
					this.updateReceiveDate(sfExpressState);
				} else {
					if (StringUtils.isNotEmpty(queue.getRunningNumber())) {
						// 犬只鉴定证书对应五个收费项且没存businessId和businessTable
						saPaymentDetailTotalService.financeConfirmTime(queue.getRunningNumber());
						// 修改邮寄表签收时间
						this.updateReceiveDate(sfExpressState);
					}
				}
			}
		}
	}

	// 邮寄表修改签收时间
	@Transactional(readOnly = false)
	public void updateReceiveDate(SfExpressState sfExpressState) {
		ExpressSend expressSend = new ExpressSend();
		expressSend.setExpressNo(sfExpressState.getOrderNo());
		expressSend.setReceiveDate(sfExpressState.getCreateTime());
		expressSendDao.updateReceiveDate(expressSend);
	}

	/**
	 * 五日未签收处理
	 */
	@Transactional(readOnly = false)
	public int overtimeReceive() {
		// 查询五日内未签收的数据
		List<ExpressSend> datas = expressSendDao.selectOvertimeData();
		int count = 0;
		for (ExpressSend send : datas) {
			SfExpressState sfExpressState = new SfExpressState();
			sfExpressState.setOrderNo(send.getExpressNo());
			sfExpressState.setCreateTime(new Date());
			// 财务收入确认时点
			this.updateSaPayment(send.getExpressNo(), sfExpressState);
			count++;
		}
		return count;
	}
	// 财务收入确认时点
//	@Transactional(readOnly = false)
//	public void updateSaPayment(SfExpressState sfExpressState) {
//		// 根据运单号查询邮寄记录
//		ExpressSend expressSend = expressSendDao.selectByOrderNo(sfExpressState.getOrderNo());
//		if (expressSend != null) {
//			ExpressQueue entity = new ExpressQueue();
//			entity.setExpressSendId(expressSend.getId());
//			// 查询运单邮寄的物品
//			List<ExpressQueue> queues = expressQueueDao.findList(entity);
//
//			Set<String> set = new HashSet<>();
//			for (ExpressQueue queue : queues) {
//				set.add(queue.getRunningNumber());
//				SaPaymentDetailTotal saPaymentDetailTotal = new SaPaymentDetailTotal();
//				saPaymentDetailTotal.setRunningNumber(queue.getRunningNumber());
//				if (StringUtils.isEmpty(queue.getChargeItemId())) { // 如果chargeItemId为空则根据runningNumber更新
//					saPaymentDetailTotal.setBusinessStates("1");
//					saPaymentDetailTotal.setFinishTime(new Date());
//					saPaymentDetailTotalDao.updatePayment(saPaymentDetailTotal);
//				} else {
//					saPaymentDetailTotal.setChargeItemId(queue.getChargeItemId());
//					saPaymentDetailTotalDao.updateReceive(saPaymentDetailTotal);
//				}
//			}
//
//			for (String runningNum : set) {
//				List<SaPaymentDetailTotal> result = saPaymentDetailTotalDao.getResult(runningNum);
//				for (SaPaymentDetailTotal sa : result) {
//					if (sa.getPaymentNum().equals(sa.getReceiveNum())) {
//						SaPaymentDetailTotal total = new SaPaymentDetailTotal();
//						total.setRunningNumber(runningNum);
//						total.setBusinessStates("1");
//						total.setFinishTime(new Date());
//						saPaymentDetailTotalService.save(total);
//					}
//				}
//			}
//
////			Map<String, Map<String, List<ExpressQueue>>> groupMap = queues.stream().collect(Collectors
////					.groupingBy(ExpressQueue::getRunningNumber, Collectors.groupingBy(ExpressQueue::getChargeItemId)));
//
////			groupMap.forEach((key, value) -> {
////				value.forEach((key2, value2) -> {
////					String runningNumber = key; // 流水号
////					String chargeItemId = key2; // 收费项号
////					SaPaymentDetailTotal saPaymentDetailTotal = new SaPaymentDetailTotal();
////					saPaymentDetailTotal.setRunningNumber(runningNumber);
////					saPaymentDetailTotal.setChargeItemId(chargeItemId);
////				});
////			});
//
//		}
//
//	}

	public SfExpressState get(String id) {
		return super.get(id);
	}

	public List<SfExpressState> findList(SfExpressState sfExpressState) {
		return super.findList(sfExpressState);
	}

	public List<SfExpressStateVo> findStateList(SfExpressState sfExpressState) {
		return sfExpressStateDao.findStateList(sfExpressState);
	}

	public Page<SfExpressState> findPage(Page<SfExpressState> page, SfExpressState sfExpressState) {
		return super.findPage(page, sfExpressState);
	}

	@Transactional(readOnly = false)
	public void save(SfExpressState sfExpressState) {
		super.save(sfExpressState);
	}

	@Transactional(readOnly = false)
	public void delete(SfExpressState sfExpressState) {
		super.delete(sfExpressState);
	}

}