package com.cku.oa.report.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.report.dao.ReportMemberAreaDao;
import com.cku.oa.report.entity.ReportMemberArea;
import com.cku.oa.report.entity.ReportRule;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 会员统计报表Service
 * 
 * @author Sunny
 * @version 2022-04-15
 */
@Service
@Transactional(readOnly = true)
public class ReportMemberAreaService extends CrudService<ReportMemberAreaDao, ReportMemberArea> {

	public ReportMemberArea get(String id) {
		return super.get(id);
	}

	public List<ReportMemberArea> findList(ReportMemberArea reportMemberArea) {
		return super.findList(reportMemberArea);
	}

	public Page<ReportMemberArea> findPage(Page<ReportMemberArea> page, ReportMemberArea reportMemberArea) {
		return super.findPage(page, reportMemberArea);
	}

	public List<ReportMemberArea> findTotal(String officeName, String periodYear, String periodType, String periodNo) {
		return dao.findTotal(officeName, periodYear, periodType, periodNo);
	}

	@Transactional(readOnly = false)
	public void save(ReportMemberArea reportMemberArea) {
		super.save(reportMemberArea);
	}

	@Transactional(readOnly = false)
	public void delete(ReportMemberArea reportMemberArea) {
		super.delete(reportMemberArea);
	}
	
	public ReportRule findReportRule(String officeName, String periodYear, String periodType, String periodNo) {
		return dao.findReportRule(officeName, periodYear, periodType, periodNo);
	}
	
}