package com.cku.oa.order.service.impl;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.common.SKUIDConstants;
import com.cku.oa.groomer.entity.FciGroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerQualificationCertificateChange;
import com.cku.oa.groomer.enums.FciGroomerQCSourceTypeEnum;
import com.cku.oa.groomer.enums.FciQualificationCertificateLevelEnum;
import com.cku.oa.groomer.enums.QualificationCertificateLevelEnum;
import com.cku.oa.groomer.enums.QualificationCertificateSourceEnum;
import com.cku.oa.groomer.service.FciGroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerQualificationCertificateChangeService;
import com.cku.oa.order.service.BaseSkuBusinessService;
import com.cku.oa.order.service.IOrderBusinessService;
import com.cku.oa.order.vo.ChargingItemVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.oa.order.vo.SingleIdOrderBusinessVo;
import com.cku.oa.order.vo.request.SingleIdRequest;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Fci处理类美容资格证书处理类
 * @author hjx
 * @date 2024年12月6日
 */
@Service
public class FciGroomerQCCOrderServiceImpl extends BaseSkuBusinessService<SingleIdOrderBusinessVo> implements IOrderBusinessService<SingleIdRequest> {

	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	@Override
	public void businessValidate(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
		if (StringUtils.isBlank(businessRequest.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.get(businessRequest.getId());
		if (Objects.isNull(fciGroomerQualificationCertificate)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到Fci证书信息");
		}
		if (!"1".equals(fciGroomerQualificationCertificate.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该Fci证书信息已经缴费");
		}
	}

	@Override
	public List<OrderSkuVo> preOrder(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.get(businessRequest.getId());
		String skuId;

		if (String.valueOf(FciGroomerQCSourceTypeEnum.FCI_SHOW.code()).equals(fciGroomerQualificationCertificate.getSourceType())) {
			if (FciQualificationCertificateLevelEnum.C.code().equals(fciGroomerQualificationCertificate.getLevelEn())) {
				skuId = SKUIDConstants.FCI_GROOMER_QUALIFICATION_CERTIFICATE_C_LEVEL;
			} else if (QualificationCertificateLevelEnum.B.code().equals(fciGroomerQualificationCertificate.getLevelEn())) {
				skuId = SKUIDConstants.FCI_GROOMER_QUALIFICATION_CERTIFICATE_B_LEVEL;
			} else if (QualificationCertificateLevelEnum.A.code().equals(fciGroomerQualificationCertificate.getLevelEn())) {
				skuId = SKUIDConstants.FCI_GROOMER_QUALIFICATION_CERTIFICATE_A_LEVEL;
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "级别有误，请联系工作人员");
			}
		} else if (String.valueOf(FciGroomerQCSourceTypeEnum.CKU_ADDITIONAL_ISSUANCE.code()).equals(fciGroomerQualificationCertificate.getSourceType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "增发的FCI证书不走FCI活动大赛缴费入口");
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "系统错误，请联系工作人员！");
		}
		//sku列表
		List<OrderSkuVo> skuVoList = Lists.newArrayList();
		//添加证书费SKU
		skuVoList.add(OrderSkuVo.builder()
				.skuId(skuId)
				.num(1)
				.businessList(Stream.of(SingleIdOrderBusinessVo.builder()
								.id(businessRequest.getId())
								.build())
						.collect(Collectors.toList()))
				.build());
		return skuVoList;
	}

	@Override
	public void processBusinessPrePay(OrderApplyRequest orderRequest, SingleIdOrderBusinessVo businessData, OrderSkuVo skuVo) {
		//无需处理
	}

	@Override
	@Transactional(readOnly = false)
	public void findChargingItemBusinessTableId(OrderApplyRequest orderRequest, OrderSkuVo skuVo, List<ChargingItemVo> itemList) {
		//获取业务信息
		SingleIdOrderBusinessVo businessData = (SingleIdOrderBusinessVo) skuVo.getBusinessList().get(0);
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.get(businessData.getId());
		itemList.forEach(item -> item.setBusinessIds(fciGroomerQualificationCertificate.getId()));
	}
}
