package com.cku.oa.ipaddress.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.ipaddress.entity.IpBlackList;
import com.cku.oa.ipaddress.service.IpBlackListService;

/**
 * ip_black_list映射表Controller
 * @author ip_black_list映射表
 * @version 2019-10-18
 */
@Controller
@RequestMapping(value = "${adminPath}/ipaddress/ipBlackList")
public class IpBlackListController extends BaseController {

	@Autowired
	private IpBlackListService ipBlackListService;
	
	@ModelAttribute
	public IpBlackList get(@RequestParam(required=false) String id) {
		IpBlackList entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = ipBlackListService.get(id);
		}
		if (entity == null){
			entity = new IpBlackList();
		}
		return entity;
	}
	
	@RequiresPermissions("ipaddress:ipBlackList:view")
	@RequestMapping(value = {"list", ""})
	public String list(IpBlackList ipBlackList, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<IpBlackList> page = ipBlackListService.findPage(new Page<IpBlackList>(request, response), ipBlackList); 
		model.addAttribute("page", page);
		return "oa/ipaddress/ipBlackListList";
	}

	@RequiresPermissions("ipaddress:ipBlackList:view")
	@RequestMapping(value = "form")
	public String form(IpBlackList ipBlackList, Model model) {
		model.addAttribute("ipBlackList", ipBlackList);
		return "oa/ipaddress/ipBlackListForm";
	}

	
	@RequiresPermissions("ipaddress:ipBlackList:edit")
	@RequestMapping(value = "edit")
	public String edit(IpBlackList ipBlackList, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, ipBlackList)){
			return form(ipBlackList, model);
		}
		ipBlackListService.updateIpStatus(ipBlackList);
		addMessage(redirectAttributes, "修改成功");
		return "redirect:"+Global.getAdminPath()+"/ipaddress/ipBlackList/?repage";
	}
	
	@RequiresPermissions("ipaddress:ipBlackList:edit")
	@RequestMapping(value = "save")
	public String save(IpBlackList ipBlackList, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, ipBlackList)){
			return form(ipBlackList, model);
		}
		ipBlackListService.save(ipBlackList);
		addMessage(redirectAttributes, "保存ip_black_list映射表成功");
		return "redirect:"+Global.getAdminPath()+"/ipaddress/ipBlackList/?repage";
	}
	
	@RequiresPermissions("ipaddress:ipBlackList:edit")
	@RequestMapping(value = "delete")
	public String delete(IpBlackList ipBlackList, RedirectAttributes redirectAttributes) {
		ipBlackListService.delete(ipBlackList);
		addMessage(redirectAttributes, "删除ip_black_list映射表成功");
		return "redirect:"+Global.getAdminPath()+"/ipaddress/ipBlackList/?repage";
	}

}