/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容考试题选项表Entity
 * @author hjx
 * @version 2023-11-23
 */
public class GroomerExamQuestionsOptions extends DataEntity<GroomerExamQuestionsOptions> {
	
	private static final long serialVersionUID = 1L;
	/**
	 * 考题id
	 */
	private String questionId;

	/**
	 * 是否正确
	 */
	private String isRight;

	/**
	 * 选项id
	 */
	private String optionId;

	/**
	 * 选项内容
	 */
	private String optionContent;
	
	public GroomerExamQuestionsOptions() {
		super();
	}

	public GroomerExamQuestionsOptions(String id){
		super(id);
	}

	@Length(min=1, max=64, message="考题id长度必须介于 1 和 64 之间")
	public String getQuestionId() {
		return questionId;
	}

	public void setQuestionId(String questionId) {
		this.questionId = questionId;
	}
	
	@Length(min=1, max=1, message="是否正确长度必须介于 1 和 1 之间")
	public String getIsRight() {
		return isRight;
	}

	public void setIsRight(String isRight) {
		this.isRight = isRight;
	}
	
	@Length(min=1, max=64, message="选项id长度必须介于 1 和 64 之间")
	public String getOptionId() {
		return optionId;
	}

	public void setOptionId(String optionId) {
		this.optionId = optionId;
	}
	
	@Length(min=1, max=255, message="选项内容长度必须介于 1 和 255 之间")
	public String getOptionContent() {
		return optionContent;
	}

	public void setOptionContent(String optionContent) {
		this.optionContent = optionContent;
	}
}