package com.cku.oa.finance.service;

import com.cku.oa.finance.dao.PaymentPayOtherDao;
import com.cku.oa.finance.entity.PaymentPayOther;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.statistics.service.SplitOrderService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 代收代入Service
 * @author lyy
 * @version 2016-08-16
 */
@Service
@Transactional(readOnly = true)
public class PaymentPayOtherService extends CrudService<PaymentPayOtherDao, PaymentPayOther> {
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentRecordService paymentRecordService;
	@Autowired
	private SplitOrderService splitOrderService;
	public PaymentPayOther get(String id) {
		return super.get(id);
	}

	public List<PaymentPayOther> findList(PaymentPayOther paymentPayOther) {
		return super.findList(paymentPayOther);
	}

	public Page<PaymentPayOther> findPage(Page<PaymentPayOther> page, PaymentPayOther paymentPayOther) {
		return super.findPage(page, paymentPayOther);
	}

	@Transactional(readOnly = false)
	public void save(PaymentPayOther paymentPayOther) {
		super.save(paymentPayOther);
	}

	/**
	 * 保存代收代入记录
	 * @param paymentPayOther
     */
	@Transactional(readOnly = false)
	public void savePayOther(PaymentPayOther paymentPayOther){
		paymentPayOther.preInsert();
		paymentPayOther.setRunningNum(System.currentTimeMillis()+"");
		dao.insert(paymentPayOther);
		//扣费
		String runningNumc = SysCodeUtil.getPayRunningNumber();
		memberService.memberCharge(paymentPayOther.getDrawee(),paymentPayOther.getPrice(),runningNumc);
		PaymentRecord chargePaymentRecord = new PaymentRecord();
		chargePaymentRecord.setChargingItemId("61");
		chargePaymentRecord.setChargingItemNum(1);
		chargePaymentRecord.setPaymentAmount(paymentPayOther.getPrice());
		chargePaymentRecord.setPrice(paymentPayOther.getPrice());
		chargePaymentRecord.setPaymentWay("cku.org");
		chargePaymentRecord.setPaymentState("2");
		chargePaymentRecord.setPaymentTime(paymentPayOther.getAddTime());
		chargePaymentRecord.setRunningNumber(runningNumc);
		chargePaymentRecord.setMemberCode(paymentPayOther.getDrawee());
		chargePaymentRecord.setPaymentRemarks("付款人会员号："+paymentPayOther.getDrawee()+"转收款人入会员号："+paymentPayOther.getPayee()+"扣款"+paymentPayOther.getPrice());
		chargePaymentRecord.setBusinessId(paymentPayOther.getId());
		paymentRecordService.save(chargePaymentRecord);
		//充值
		String runningNumrc = SysCodeUtil.getPayRunningNumber();
		memberService.memberRecharge(paymentPayOther.getPayee(),paymentPayOther.getPrice(),paymentPayOther.getAddTime(),runningNumrc);
		PaymentRecord rechargePaymentRecord = new PaymentRecord();
		rechargePaymentRecord.setChargingItemId("0");
		rechargePaymentRecord.setChargingItemNum(1);
		rechargePaymentRecord.setPaymentAmount(paymentPayOther.getPrice());
		rechargePaymentRecord.setPrice(paymentPayOther.getPrice());
		rechargePaymentRecord.setPaymentWay("10");
		rechargePaymentRecord.setPaymentState("2");
		rechargePaymentRecord.setPaymentTime(paymentPayOther.getAddTime());
		rechargePaymentRecord.setRunningNumber(runningNumrc);
		rechargePaymentRecord.setMemberCode(paymentPayOther.getPayee());
		rechargePaymentRecord.setPaymentRemarks("收款人会员号："+paymentPayOther.getPayee()+"充值"+paymentPayOther.getPrice()+"由付款人会员号："+paymentPayOther.getDrawee()+"转入");
		rechargePaymentRecord.setBusinessId(paymentPayOther.getId());
		paymentRecordService.save(rechargePaymentRecord);

//流水拆分
//		splitOrderService.initSplit(chargePaymentRecord.getRunningNumber());
	}
	@Transactional(readOnly = false)
	public void delete(PaymentPayOther paymentPayOther) {
		super.delete(paymentPayOther);
	}

}