//package com.cku.oa.components.rule.validation.dog;
//
//import com.cku.oa.components.rule.Validation;
//import com.cku.oa.dog.entity.Dog;
//import com.cku.oa.sys.entity.user.Member;
//import com.google.common.collect.Lists;
//import com.ql.util.express.DefaultContext;
//import com.ql.util.express.ExpressRunner;
//import com.ql.util.express.IExpressContext;
//import org.springframework.stereotype.Component;
//
//import java.util.List;
//@Component
//public class DogValidation extends Validation {
//    protected List<String> validate()throws Exception{
//        return null;
//    }
//    private static final String DOG_BELONG_TO_MEMBER = "犬只属于申请人";
//    private static final String IDENTIFICATIONFLAG_NOT_BLANK = "犬只芯片号不为空";
//    private static final String HAVE_DOGDNA = "有DNA存档";
//    private static final String HAVE_CHAMPIONLOGIN_CHINA = "完成普通登录";
//    private static final String CKUDOG = "是CKU注册犬";
//
//    public static ExpressRunner runner;
//
//    static {
//        runner = new ExpressRunner();
//    }
//
//    private static boolean isInitialRunner = false;
//
//    @Override
//    protected void initRunner() {
//        if (isInitialRunner == true) {
//            return;
//        }
//        synchronized (runner) {
//            if (isInitialRunner == true) {
//                return;
//            }
//            try {
//                DogCondition dogCondition = (DogCondition) applicationContext.getBean("dogCondition");
//                runner.setShortCircuit(true);
//                runner.addOperatorWithAlias("而且", "and", null);
//                runner.addFunctionOfServiceMethod("isDogBelongToMember", dogCondition, "isDogBelongToMember", new Class[]{Dog.class, Member.class}, "该犬只不属于申请人");
//                runner.addMacro(DOG_BELONG_TO_MEMBER, "isDogBelongToMember(dog,member)");
//                runner.addFunctionOfServiceMethod("isIdentificationFlagNotBlank", dogCondition, "isIdentificationFlagNotBlank", new Class[]{Dog.class}, "该犬只芯片号为空");
//                runner.addMacro(IDENTIFICATIONFLAG_NOT_BLANK, "isIdentificationFlagNotBlank(dog)");
//                runner.addMacro("犬只状态正常", "0");
//                runner.addMacro("犬只状态出口", "5");
//                runner.addOperatorWithAlias("属于", "in", "犬只状态$1不在允许的范围");
//                runner.addOperatorWithAlias("如果", "if", null);
//                runner.addOperatorWithAlias("否则", "else", null);
//                runner.addMacro("青年登录", "7");
//                runner.addOperatorWithAlias("等于", "==", "$1 == $2 不符合");
//                runner.addOperatorWithAlias("大于", ">", "$1不大于要求的$2");
//                runner.addOperatorWithAlias("小于", "<", "$1不小于要求的$2");
//                runner.addFunctionOfServiceMethod("isHaveDogDna", dogCondition, "isHaveDogDna", new Class[]{Dog.class}, "该犬只没有进行DNA存档");
//                runner.addMacro(HAVE_DOGDNA, "isHaveDogDna(dog)");
//                runner.addMacro("铜制登录", "2");
//                runner.addMacro("银制登录", "3");
//                runner.addMacro("金制登录", "4");
//                runner.addMacro("超级登录", "5");
//                runner.addMacro("世界冠军登录", "6");
//                runner.addFunctionOfServiceMethod("isHaveChampionLogin", dogCondition, "isHaveChampionLogin", new Class[]{Dog.class, Integer.class}, "该犬只没有进行中国冠军登录");
//                runner.addMacro(HAVE_CHAMPIONLOGIN_CHINA, "isHaveChampionLogin(dog,1)");
//                runner.addOperatorWithAlias("或", "or", null);
//                runner.addFunctionOfServiceMethod("isCKUDog", dogCondition, "isCKUDog", new Class[]{Dog.class}, "不是CKU注册犬");
//                runner.addMacro(CKUDOG, "isCKUDog(dog)");
//                runner.addFunctionOfServiceMethod("isDogMonthAgeGEX", dogCondition, "isDogMonthAgeGEX", new Class[]{Dog.class,Integer.class}, "");
//                runner.addOperatorWithAlias("犬只月龄大于等于","isDogMonthAgeGEX","犬只月龄不大于等于$2个月");
//                runner.addFunctionOfServiceMethod("isDogGenerationGEX", dogCondition, "isDogGenerationGEX", new Class[]{Dog.class,Integer.class}, "");
//                runner.addOperatorWithAlias("犬只代数大于等于","isDogGenerationGEX","犬只代数不大于等于$2");
//            } catch (Exception e) {
//                throw new RuntimeException("初始化失败表达式", e);
//            }
//        }
//        isInitialRunner = true;
//    }
//
//    public static void main(String args[]) throws Exception{
//        IExpressContext<String,Object> expressContext = new DefaultContext<String,Object>();
//        List<String> errorInfoList = Lists.newArrayList();
//        Dog dog = new Dog();
//        dog.setIdentificationFlag("11111");
//        expressContext.put("dog",dog);
//        runner.addFunctionOfServiceMethod("isIdentificationFlagNotBlank", new DogCondition(), "isIdentificationFlagNotBlank", new Class[]{Dog.class}, "该犬只芯片号为空");
//        runner.addMacro(IDENTIFICATIONFLAG_NOT_BLANK, "isIdentificationFlagNotBlank(dog)");
//        Boolean dogResult = (Boolean) DogValidation.runner.execute("犬只芯片号不为空", expressContext, errorInfoList, true, true);
//        System.out.println(dogResult.booleanValue());
//    }
//}