/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.buying.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.buying.entity.BuyingOrder;

/**
 * 抢购购物车DAO接口
 * @author cxt
 * @version 2017-11-22
 */
@MyBatisDao
public interface BuyingOrderDao extends CrudDao<BuyingOrder> {
	
	//除百科犬种外,其他页面广告位只允许购买一次
	int getByPageItem(@Param("userId")String userId,@Param("commodityId") String commodityId, @Param("version")String version);
	//查询产品剩余数量
	int checkCommodityCount(@Param("commodityId") String commodityId, @Param("dogType")String dogType,@Param("version")String version,@Param("paymentState")String paymentState);
	//根据订单号查询购物车记录
	List<BuyingOrder> findForRunningNumber(@Param("orderCode")String orderCode);
	//查询个人购买过某个犬种否
	int getByPageDogType(@Param("userId")String userId,@Param("commodityId") String commodityId, @Param("version")String version,@Param("dogType")String dogType );
	//查询会员是否购买过某一期产品
	int getOrderByVersion(@Param("memberCode")String memberCode,@Param("version") String version);
	
}