//业务信息核对
define(["knockout"], function(ko) {
  return function(context) {
    var me = this;
    me.carts = ko.observableArray([]);
    me.totalPrice = ko.observable(0);
    // me.totalNum = ko.observable("0");
    me.member = ko.observable({});

    //保存参数
    me.cartsId = ko.observableArray([]);
    me.receiverProvince = ko.observable("");
    me.receiverCity = ko.observable("");
    me.receiverArea = ko.observable("");
    me.receiverAddress = ko.observable("");
    me.postcode = ko.observable("");
    me.del = ko.observable("");
    me.receiver = ko.observable("");
    me.isnew = ko.observable(false);
    //省List
    me.provinceList = ko.observableArray([]);
    //市List
    me.cityList = ko.observableArray([]);
    me.provinceHtml = ko.observable("");
    me.cityHtml = ko.observable("");

    me.couponFlag = ko.observable(false);
    me.couponSelectName = ko.observable("请选择优惠券");
    me.couponSelectId = ko.observable("");
    me.couponsTabIndex = ko.observable(0);
    me.coupons = ko.observable({});
    me.couponsList = ko.observableArray([]);
    me.showProvince = function() {
      if ($("#provinceDiv").css("display") == "none") {
        $("#provinceDiv").css("display", "block");
      } else {
        $("#provinceDiv").css("display", "none");
      }
      $("#cityDiv").css("display", "none");
    };
    me.showCity = function() {
      if ($("#cityDiv").css("display") == "none") {
        $("#cityDiv").css("display", "block");
      } else {
        $("#cityDiv").css("display", "none");
      }
      $("#provinceDiv").css("display", "none");
    };
    me.changeProvince = function(data) {
      me.provinceHtml(data);
      me.receiverProvince(data);
      for (var i = 0; i < util.city.length; i++) {
        if (data == util.city[i].local) {
          me.initProCity(data, util.city[i].localcity[0]);
        }
      }
      $("#provinceDiv").css("display", "none");
    };
    me.changeCity = function(data) {
      me.receiverCity(data);
      me.cityHtml(data);
      $("#cityDiv").css("display", "none");
    };
    me.initProCity = function(province, city) {
      me.provinceList().length = 0;
      me.cityList().length = 0;
      me.provinceHtml(province);
      me.cityHtml(city);
      for (var i = 0; i < util.city.length; i++) {
        me.provinceList.push(util.city[i].local);
        if (province == util.city[i].local) {
          for (var j = 0; j < util.city[i].localcity.length; j++) {
            me.cityList.push(util.city[i].localcity[j]);
          }
        }
      }
    };
    /**
     * 全选按钮
     */
    me.selectAll = function() {
      if ($("#radioParent").hasClass("checked")) {
        $("#radioParent").attr("class", "radio");
        $("table tbody tr td a[name='radioa']").attr("class", "radio");
        me.cartsId([]);
        me.couponSelectId("");
        me.couponSelectName("请选择优惠券");
        me.couponFlag(false);
        me.calculate();
        // me.totalPrice("0");
        // me.totalNum("0");
      } else {
        $("#radioParent").attr("class", "radio checked");
        $("table tbody tr td a[name='radioa']").attr("class", "radio checked");
        var arr = [];
        $.each(me.carts(), function(index, item) {
          arr.push(item.id);
        });
        me.cartsId(arr);
        me.couponSelectId("");
        me.couponSelectName("请选择优惠券");
        me.couponFlag(false);
        me.calculate();
        // me.totalPrice(context.app.totalPrice());
        // me.totalNum(context.app.totalNum());
      }
    };
    /**
     * 单选按钮
     * @param data
     */
    me.selectOne = function(data) {
      if ($("#radio" + data.id).hasClass("checked")) {
        $("#radio" + data.id).attr("class", "radio");
        $("#radioParent").attr("class", "radio");
        me.cartsId.remove(data.id);
        me.couponSelectId("");
        me.couponSelectName("请选择优惠券");
        me.couponFlag(false);
        me.calculate();
        // me.totalPrice(
        //   (parseFloat(me.totalPrice()) - parseFloat(data.totalPrice)).toFixed(2)
        // );
        // me.totalNum(parseInt(me.totalNum()) - parseInt(data.num));
      } else {
        $("#radio" + data.id).attr("class", "radio checked");
        var allCheck = true;
        var objs = $("table tbody tr td a[name='radioa']");
        $.each(objs, function(index, item) {
          if (!$("#" + item.id).hasClass("checked")) {
            allCheck = false;
          }
        });
        me.cartsId.push(data.id);
        me.couponSelectId("");
        me.couponSelectName("请选择优惠券");
        me.couponFlag(false);
        me.calculate();
        if (allCheck) {
          $("#radioParent").attr("class", "radio checked");
        }
        // me.totalPrice(
        //   (parseFloat(me.totalPrice()) + parseFloat(data.totalPrice)).toFixed(2)
        // );
        // me.totalNum(parseInt(me.totalNum()) + parseInt(data.num));
      }
    };
    /**
     * 保存订单
     */
    me.saveOrder = function() {
      var sendData = {};
      if (me.cartsId().length == 0) {
        layer.msg("请选择业务订单！");
        return;
      }
      if (util.isVal(me.receiverCity()) == "") {
        layer.msg("收货城市不能为空！请在个人中心修改");
        return;
      }
      if (util.isVal(me.receiverProvince()) == "") {
        layer.msg("收货省份不能为空！请在个人中心保存修改");
        return;
      }
      if (util.isVal(me.receiverArea()) == "") {
        layer.msg("收货区域不能为空！请在个人中心保存修改");
        return;
      }
      if (util.isVal(me.receiverAddress()) == "") {
        layer.msg("收货地址不能为空！请在个人中心保存修改");
        return;
      }
      //if(util.isVal(me.postcode())==""){
      //    layer.msg("收货邮编不能为空！");
      //    return;
      //}
      if (!util.isMobile(me.del())) {
        var layerCon = layer.confirm(
          "联系电话不正确,是否跳转到个人中心修改个人信息？",
          {
            btn: ["确定", "关闭"] //按钮
          },
          function() {
            layer.close(layerCon);
            location.href = location.href.split("#")[0] + "#/personal/index";
          }
        );
        return;
      }
      if (util.isVal(me.receiver()) == "") {
        var layerCon = layer.confirm(
          "收件人不能为空,是否跳转到个人中心修改个人信息？",
          {
            btn: ["确定", "关闭"] //按钮
          },
          function() {
            layer.close(layerCon);
            location.href = location.href.split("#")[0] + "#/personal/index";
          }
        );
        return;
      }
      sendData["carts"] = me.cartsId();
      sendData["receiverProvince"] = me.receiverProvince();
      sendData["receiverCity"] = me.receiverCity();
      sendData["receiverArea"] = me.receiverArea();
      sendData["receiverAddress"] = me.receiverAddress();
      sendData["postcode"] = me.postcode();
      sendData["del"] = me.del();
      sendData["receiver"] = me.receiver();
      sendData["couponId"] = me.couponSelectId();
      util.sendAjax({
        url: "finance/order",
        data: JSON.stringify(sendData),
        async: true,
        loadFlag: true,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            layer.msg("添加业务订单成功！");
            context.app.changeCart();
            if (me.isnew()) {
              location.href =
                location.href.split("#")[0] +
                "#/payment/payment?id=" +
                json.data.id +
                "&type=order&isnew=true";
            } else {
              location.href =
                location.href.split("#")[0] +
                "#/payment/payment?id=" +
                json.data.id +
                "&type=order";
            }
          } else {
            layer.msg(
              "添加业务订单失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };
    /**
     * 删除购物车
     */
    me.delCart = function(data) {
      var delCartLayer = layer.confirm(
        "您确认删除此商品？",
        {
          btn: ["确定", "取消"] //按钮
        },
        function() {
          util.sendAjax({
            url: "finance/cart/" + data.id,
            data: {},
            async: true,
            loadFlag: true,
            type: "DELETE",
            cache: false,
            success: function(json) {
              if (json.rc == 0) {
                layer.msg("删除购物车商品成功！");
                layer.close(delCartLayer);
                context.app.changeCart();
                me.carts(context.app.carts());
                var arr = [];
                $.each(me.carts(), function(index, item) {
                  arr.push(item.id);
                });
                me.cartsId(arr);
                // me.totalPrice(context.app.totalPrice());
                // me.totalNum(context.app.totalNum());
                me.couponSelectId("");
                me.couponSelectName("请选择优惠券");
                me.couponFlag(false);
                me.calculate();
              } else {
                layer.msg(
                  "删除购物车商品失败,错误代码:" +
                    json.rc +
                    "错误信息:" +
                    json.msg
                );
              }
            }
          });
        },
        function() {}
      );
    };
    me.changeTab = function(index) {
      var couponsTabIndex = me.couponsTabIndex();
      if (couponsTabIndex == index) {
        return;
      }
      me.couponsTabIndex(index);
      var coupons = me.coupons();
      if (index == 0) {
        me.couponsList(coupons.availableList);
      } else {
        me.couponsList(coupons.unavailableList);
      }
    };
    me.selectCoupon = function(flag) {
      if (flag) {
        me.couponFlag(true);
      } else {
        if (me.couponSelectId() == "" || me.couponSelectId() == null) {
          me.popCoupon();
        }
        var couponFlag = me.couponFlag();
        me.couponFlag(!couponFlag);
      }
      me.calculate();
    };
    me.popCoupon = function() {
      var data = {};
      data.carts = me.cartsId();
      util.sendAjax({
        url: "finance/coupons",
        data: JSON.stringify(data),
        async: true,
        loadFlag: true,
        type: "POST",
        cache: false,
        success: function(json) {
          console.log(json, "==========================");
          if (json.rc == 0) {
            me.coupons(json.data);
            var couponsTabIndex = me.couponsTabIndex();
            if (couponsTabIndex == 0) {
              me.couponsList(json.data.availableList);
            } else {
              me.couponsList(json.data.unavailableList);
            }
            layer.open({
              type: 1,
              title: false,
              area: "800px",
              content: $("#popCoupon"),
              cancel: function(index, layero) {
                if (me.couponSelectId() == "" || me.couponSelectId() == null) {
                  me.couponFlag(false);
                }
              }
            });
          } else {
            layer.msg(
              "查询优惠券失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };
    me.useCoupon = function(data) {
      me.couponSelectName(data.couponName + data.facePrice + "元");
      me.couponSelectId(data.id);
      me.selectCoupon(true);
      layer.closeAll();
    };
    me.calculate = function() {
      var data = {};
      data.carts = me.cartsId();
      data.couponId = "";
      if (me.couponFlag()) {
        data.couponId = me.couponSelectId();
      }
      util.sendAjax({
        url: "finance/calculate",
        data: JSON.stringify(data),
        async: true,
        loadFlag: true,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            me.totalPrice(json.data);
          } else {
            layer.msg(
              "查询总价失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };
    $(function() {
      var obj = util.getQueryString();
      if (obj.isnew == "true") {
        me.isnew(true);
      }
      context.app.changeCart();
      me.carts(context.app.carts());
      var arr = [];
      $.each(me.carts(), function(index, item) {
        arr.push(item.id);
      });
      me.cartsId(arr);
      userInfo.refresh();
      me.member(userInfo.getMember());
      me.receiverProvince = ko.observable(me.member().province);
      me.receiverCity = ko.observable(me.member().city);
      me.receiverArea = ko.observable(me.member().area);
      me.receiverAddress = ko.observable(me.member().street);
      me.postcode = ko.observable(me.member().postcode);
      me.del = ko.observable(me.member().mobile);
      me.receiver = ko.observable(me.member().name);
      // me.totalPrice(context.app.totalPrice());
      // me.totalNum(context.app.totalNum());
      //me.initProCity(me.receiverProvince(),me.receiverCity());
      me.calculate();
    });
    //什么都没干，就是个演示
    context.app.loading(false);
    context.app.isShop(false);
  };
});
