//出生纸申请添加页
//获取犬信息
function getDog(id){
    util.sendAjax({
        url:'dog/dognewborn/'+id,
        data:{},
        async:true,
        loadFlag:true,
        type:'GET',
        cache:false,
        success:function(json){
            if(json.rc==0){
                if(json.data!=null){
                    $("#dogMessage").html("<span class='blockline'>配种证明编号："+json.data.breedCertifiedCode+"</span>"
                    +"<span class='blockline'>配种日期："+json.data.breedDate+"</span>"
                    +"<span class='blockline'>公犬主人："+json.data.maleDogOwner+"</span>"
                    +"<span class='blockline'>母犬主人："+json.data.femaleDogOwner+"</span>"
                    +"<span class='blockline'>公犬证书号：<a href='javascript:;'>"+json.data.malePedigreeCertified+"</a></span>"
                   +"<span class='blockline'>母犬证书号：<a href='javascript:;'>"+json.data.femalePedigreeCertified+"</a></span>");
                    $("#button").on("click",function(){
                        getDogFurColor(json.data.dogBreed);
                    })
                    $("#isUrgent input").on("click",function(){
                        lastGetPrice(json.data.breedCertifiedCode);
                    })
                    $("#shuxing").on("click",function(){
                        applayBirthcertificate(json.data.breedCertifiedCode);
                    })
                }
            }else{
                layer.open({
                    content:"获取信息失败："+json.msg,
                    skin: 'msg',
                    time: 2 //2秒后自动关闭
                });
            }
        }
    });
}
//随机犬名
function randomName(colorHtml){
    var maleNum = $("#dog_gong_num").val();
    var femaleNum = $("#dog_mu_num").val();
    if(maleNum && femaleNum){
        var sendData = {};
        sendData["femaleNum"] = maleNum;
        sendData["maleNum"] = femaleNum;
        util.sendAjax({
            url:'dog/birthcertificate/randomName',
            data:sendData,
            async:true,
            loadFlag:true,
            type:'GET',
            cache:false,
            success:function(data){
                if(data.rc==0){
                    $("#randomName").html("");
                    $.each(data.list,function(index,item){
                        var dogGender = "";
                        item.dogGender=="0"?dogGender="母":dogGender="公";
                        $("#randomName").append("<tr class='dogArray'>"
                            +"<td class='dogGenders'>"+dogGender+"</td>"
                            +"<td ><input type='text' value='"+item.dogName+"' class='dogNames' style='text-align:center;'></td>"
                            +"<td ><select class='dogFurColor'><option value=''>请选择毛色</option>"+colorHtml+"</select></td>"
                            +"</tr>")
                    });
                }else{
                    layer.open({
                        content:"随机犬名失败："+data.msg,
                        skin:"msg",
                        time:2
                    });
                    $("#randomName").html("");
                }
            }
        });
    }
}
//获取毛色
function getDogFurColor(dogBreed){
    util.sendAjax({
        url:'dog/dogcolormark/'+dogBreed,
        data:{},
        async:true,
        type:'GET',
        cache:false,
        success:function(data){
            if(data.rc==0){
                var colorHtml="";
                $.each(data.list,function(index,item){
                    colorHtml+="<option value='"+item.dogColorMarkCode+"'>"+item.dogColorMarkCn+"</option>";
                });
                randomName(colorHtml);
            }else{
                layer.open({
                    content:"获取毛色失败："+json.msg,
                    skin: 'msg',
                    time: 2 //2秒后自动关闭
                })
            }
        }
    });
}
//获取价格
function lastGetPrice(breedCertifiedCode){
    var maleNum = $("#dog_gong_num").val().trim();
    var femaleNum = $("#dog_mu_num").val().trim();
    if(maleNum && femaleNum){
        var dogNum = parseInt(maleNum) + parseInt(femaleNum);
        var sendData = {};
        sendData["fmdogBreedCertifiedCode"] = breedCertifiedCode;
        sendData["num"] = dogNum;
        sendData["urgent"] = $(":radio[name='cku_jiaji']:checked").val();
        util.sendAjax({
            url:'dog/birthcertificate/getPrice',
            data:sendData,
            async:true,
            loadFlag:true,
            type:'GET',
            cache:false,
            success:function(json){
                if(json.rc==0){
                    $("#paysum").html(json.data.price);
                }else{
                    layer.open({
                        content:"获取价格失败："+json.msg,
                        skin: 'msg',
                        time: 2 //2秒后自动关闭
                    })
                }
            }
        });
    }
}
//新生犬出生纸申请
function applayBirthcertificate(breedCertifiedCode){
    var sendData = {};
    //幼犬出生日期
    var birthDate = $("#demo").val();
    if(util.isVal(birthDate)==""){
        layer.open({
            content:"出生日期不能为空！",
            skin:"msg",
            time:2
        });
        return;
    }
    sendData["dogBirthday"] = birthDate;
    //配种证明编号
    sendData["fmdogBreedCertifiedCode"] = breedCertifiedCode;
    //是否加急
    sendData["urgent"] = $(":radio[name='cku_jiaji']:checked").val();
    //新生犬信息数组
    var dogBirthCertificate = $(".dogArray");
    var dogBirthCertificateArray = [];
    $.each(dogBirthCertificate,function(index,item){
        var perDogObj = {};
        perDogObj["dogEnName"] = $(item).find(".dogNames").val();
        perDogObj["colorFlag"] = $(item).find("select").val();
        if($(item).find(".dogGenders").text() == "母"){
            perDogObj["dogGender"] = "2";
        }else{
            perDogObj["dogGender"] = "1";
        }
        dogBirthCertificateArray.push(perDogObj);
    });
    if(util.isVal(dogBirthCertificateArray)==""){
        layer.open({
            content:"幼犬信息组不能为空！",
            skin:"msg",
            time:2
        });
        return;
    }
    sendData["dogBirthCertificateArray"] = dogBirthCertificateArray;
    util.sendAjax({
        url:'dog/birthcertificate',
        data: JSON.stringify(sendData),
        async:true,
        loadFlag:true,
        type:'POST',
        cache:false,
        success:function(json){
            if(json.rc==0){
                layer.open({
                    content: '业务添加成功，是否跳转到业务核对页面进行支付！'
                    ,btn: ['确定', '取消']
                    ,yes: function(index){
                        window.location.href="orderList.html"
                    }
                });
            }else{
                layer.open({
                    content:"提交失败："+json.msg,
                    skin: 'msg',
                    time: 2 //2秒后自动关闭
                })
            }
        }
    });
}
//初始化
$(function(){
    var obj = util.getQueryString();
    getDog(obj.ID);
    $('#demo').mobiscroll().date({
        theme: 'mobiscroll',
        lang: "zh",
        display: 'bottom',
        dateFormat: 'yy-mm-dd',
        onSelect:function(valueText,inst) {}
    });
    $('#clear').click(function () {
        $('#demo').mobiscroll('clear');
        return false;
    });
})

