//会员犬舍信息
define(["knockout"], function(ko) {
  return function(context) {
    var me = this;
    userInfo.refresh();
    //会员信息
    me.member = ko.observable(userInfo.getMember());
    //犬舍
    me.kennel = ko.observable({
      type: "year",
      name: "",
      nameEn: "",
      fciName: "",
      fciNameBackup: ""
    });
    //如果有犬舍犬舍信息
    me.kennelInfo = ko.observable({});
    //是否存在犬舍
    me.isKennel = ko.observable(false);
    //是否已读
    me.isCheck = ko.observable("0");
    //犬舍续费
    me.isLastTime = ko.observable(false);
    //犬舍Fci显示标记
    me.checkFciLiFlag = ko.observable(false);
    //犬舍升级操作按钮 显隐
    me.isUpgrade = ko.observable(false);
    //犬舍FCI修改按钮标记
    me.checkFciButtonFlag = ko.observable(false);
    //start  校验名称提示颜色标记
    me.isNameError = ko.observable(false);
    me.isNameEnError = ko.observable(false);
    me.isFciNameError = ko.observable(false);
    me.isFciNameBackError = ko.observable(false);
    me.kennelFciName = ko.observable("");
    // end 柴雪腾
    me.reviewStateStr = ko.observable("待审核");
    me.fciReviewStateStr = ko.observable("待审核");

    me.showKennelRename = ko.observable(false);

    me.kennelNameFlag = ko.observable(false);

    me.kennelFciNameFlag = ko.observable(false);

    me.kennelNameShow = ko.observable("");
    me.kennelNameEnShow = ko.observable("");
    me.kennelFciNameShow = ko.observable("");
    me.kennelFciNameBackupShow = ko.observable("");
    me.kennelNameCheckFlag = ko.observable(false);
    me.kennelNameEnCheckFlag = ko.observable(false);
    me.kennelFciNameBackupCheckFlag = ko.observable(false);
    me.kennelFciNameCheckFlag = ko.observable(false);
    me.kennelTypePermanent = ko.observable(false);
    //犬舍页安全手机绑定业务
    me.isbd = ko.observable(true); //默认不显示
    me.content = ko.observable("");
    me.yesBind = ko.observable("");
    me.noBind = ko.observable("");
    me.content(
      "尊敬的会员您好，由于CKUMC会员中心系统账户安全升级，安全监测发现您会员账户尚未进行实名认证且未绑定安全手机，将有部分业务无法正常办理。请先完成安全手机绑定。"
    );
    me.yesBind("去绑定安全手机号");
    me.noBind("暂不绑定，继续办理业务");

    //勾选按钮
    me.checkFun = function() {
      if ($("#checkFlag").hasClass("active")) {
        $("#checkFlag").removeClass("active");
        me.isCheck("0");
      } else {
        $("#checkFlag").addClass("active");
        me.isCheck("1");
      }
    };
    //展现阅读内容
    me.showFun = function() {
      if ($("#showDiv").css("display") == "none") {
        $("#showEm").addClass("show");
        $("#showDiv").css("display", "block");
      } else {
        $("#showEm").removeClass("show");
        $("#showDiv").css("display", "none");
      }
    };
    //选择犬舍类别
    me.changeType = function(type) {
      me.kennel().type = type;
      if (type == "year") {
        $("#yearRadio").addClass("active");
        $("#permanentRadio").removeClass("active");
        me.kennelTypePermanent(false);
      } else {
        me.kennelTypePermanent(true);
        $("#yearRadio").removeClass("active");
        $("#permanentRadio").addClass("active");
      }
    };
    //检验犬舍中文名称
    me.checkKennelName = function() {
      var sendData = { isCheckType: "name", name: me.kennel().name };
      util.sendAjax({
        url: "kennel/checkKennelName",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            me.kennelNameShow("犬舍中文名正确");
            me.kennelNameCheckFlag(true);
            me.isNameError(false);
          } else {
            me.kennelNameShow(json.msg);
            me.kennelNameCheckFlag(false);
            me.isNameError(true);
          }
        }
      });
    };
    //检验犬舍英文名称
    me.checkKennelNameEn = function() {
      me.kennel().fciName = me.kennel().nameEn;
      $("#kennelFciNameInp").val(me.kennel().nameEn);
      var sendData = { isCheckType: "nameEn", nameEn: me.kennel().nameEn };
      util.sendAjax({
        url: "kennel/checkKennelName",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            me.kennelNameEnShow("犬舍英文名正确");
            me.kennelNameEnCheckFlag(true);
            me.isNameEnError(false);
          } else {
            me.kennelNameEnShow(json.msg);
            me.kennelNameEnCheckFlag(false);
            me.isNameEnError(true);
          }
        }
      });
    };
    //检验犬舍FCI名称
    me.checkKennelFciName = function() {
      var sendData = { isCheckType: "fciName", fciName: me.kennel().fciName };
      console.log(sendData);
      util.sendAjax({
        url: "kennel/checkKennelName",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            me.kennelFciNameShow("犬舍FCI名称正确");
            me.kennelFciNameCheckFlag(true);
            me.isFciNameError(false);
          } else {
            me.kennelFciNameShow(json.msg);
            me.kennelFciNameCheckFlag(false);
            me.isFciNameError(true);
          }
        }
      });
    };
    //检验犬舍英文备用名称
    me.checkKennelFciNameBackup = function() {
      var sendData = {
        isCheckType: "fciNameBackup",
        fciNameBackup: me.kennel().fciNameBackup
      };
      util.sendAjax({
        url: "kennel/checkKennelName",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            me.kennelFciNameBackupShow("犬舍FCI备用名正确");
            me.kennelFciNameBackupCheckFlag(true);
            me.isFciNameBackError(false);
          } else {
            me.kennelFciNameBackupShow(json.msg);
            me.kennelFciNameBackupCheckFlag(false);
            me.isFciNameBackError(true);
          }
        }
      });
    };
    //注册犬舍
    me.saveKennel = function() {
      if (me.kennel().type == "year") {
        if (!(me.kennelNameCheckFlag() && me.kennelNameEnCheckFlag())) {
          layer.msg("犬舍名称不符合规则，请重新确认。");
          return;
        }
      } else {
        if (
          !(
            me.kennelNameCheckFlag() &&
            me.kennelNameEnCheckFlag() &&
            me.kennelFciNameCheckFlag() &&
            me.kennelFciNameBackupCheckFlag()
          )
        ) {
          layer.msg("犬舍名称不符合规则，请重新确认。");
          return;
        }
      }
      var name = util.removeg(me.kennel().name);
      var nameEn = me.kennel().nameEn;
      var fciName = me.kennel().fciName;
      var fciNameBackup = me.kennel().fciNameBackup;

      var sendData = {
        type: me.kennel().type,
        name: name,
        nameEn: nameEn,
        fciName: fciName,
        fciNameBackup: fciNameBackup
      };
      if (me.isCheck() == "0") {
        layer.msg("请阅读犬舍注册须知");
        return;
      }
      util.sendAjax({
        url: "kennel/kennel",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            layer.msg("注册犬舍成功！");
            context.app.changeCart();
            location.href = location.href.split("#")[0] + "#/order/check";
          } else {
            layer.msg(
              "注册犬舍失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };

    //犬舍升级
    me.kennelUpgrade = function() {
      if (util.isVal(me.member().safeMobile) == "") {
        me.content(
          "尊敬的会员您好，由于CKUMC会员中心系统账户安全升级，安全监测发现您会员账户尚未进行实名认证且未绑定安全手机，当前业务无法正常办理。请先完成安全手机绑定。"
        );
        me.yesBind("去绑定安全手机号");
        me.noBind("暂不绑定，继续办理其他业务");
        me.isbd(false);
      } else {
        var fciName = me.kennelInfo().fciName;
        var fciNameBackup = me.kennelInfo().fciNameBackup;
        if (fciName == "" || fciNameBackup == "") {
          layer.open({
            type: 1,
            title: "fci犬舍名称",
            shadeClose: true,
            area: ["500px", "300px"],
            content:
              '<div style="padding-left:100px;"><ul>' +
              '<li style="margin-top:30px"><span>FCI英文名：</span><input type="text" id="updatefciNameVal"  value="' +
              fciName +
              '"><span style="color: red;float:none;"  id="updateNameEnShow"></span></li>' +
              '<li style="margin-top:30px;"><span>FCI备用名：</span><input type="text" id="updateFciNameBackupVal" value="' +
              fciNameBackup +
              '"><span style="color: red;float:none;"  id="updateFciNameBackupShow"></span></li>' +
              "</ul></div>",
            btn: ["确定", "取消"],
            yes: function(index) {
              var updateFciNameVal = $("#updatefciNameVal").val();
              var updateFciNameBackupVal = $("#updateFciNameBackupVal").val();
              var sendData1 = {
                isCheckType: "fciName",
                fciName: updateFciNameVal
              };
              util.sendAjax({
                url: "kennel/checkKennelName",
                data: JSON.stringify(sendData1),
                async: false,
                type: "POST",
                cache: false,
                success: function(json) {
                  if (json.rc == 0) {
                    $("#updateNameEnShow").text("犬舍英文名正确");
                    var sendData2 = {
                      isCheckType: "fciNameBackup",
                      fciNameBackup: updateFciNameBackupVal
                    };
                    var sendData = {
                      fciName: updateFciNameVal,
                      fciNameBackup: updateFciNameBackupVal
                    };
                    util.sendAjax({
                      url: "kennel/upgrade",
                      data: JSON.stringify(sendData),
                      async: true,
                      loadFlag: true,
                      type: "POST",
                      cache: false,
                      success: function(json) {
                        if (json.rc == 0) {
                          context.app.changeCart();
                          layer.alert(
                            "业务添加成功，是否跳转到业务核对页面进行支付？",
                            {
                              time: 0, //不自动关闭
                              btn: ["跳转", "取消"],
                              yes: function(index) {
                                layer.closeAll();
                                location.href =
                                  location.href.split("#")[0] + "#/order/check";
                              }
                            }
                          );
                        } else {
                          layer.msg(
                            "犬舍升级失败,错误代码:" +
                              json.rc +
                              "错误信息:" +
                              json.msg
                          );
                        }
                      }
                    });
                  } else {
                    $("#updateNameEnShow").text(json.msg);
                  }
                }
              });
            }
          });
        } else {
          util.sendAjax({
            url: "kennel/upgrade",
            data: {},
            async: true,
            loadFlag: true,
            type: "POST",
            cache: false,
            success: function(json) {
              if (json.rc == 0) {
                context.app.changeCart();
                layer.alert("业务添加成功，是否跳转到业务核对页面进行支付？", {
                  time: 0, //不自动关闭
                  btn: ["跳转", "取消"],
                  yes: function(index) {
                    layer.closeAll();
                    location.href =
                      location.href.split("#")[0] + "#/order/check";
                  }
                });
              } else {
                layer.msg(
                  "犬舍升级失败,错误代码:" + json.rc + "错误信息:" + json.msg
                );
              }
            }
          });
        }
      }
    };
    //犬舍续费 start by 柴雪腾 20170321 续费添加fci信息提交以及添加了核算提示语
    me.kennelRenew = function() {
      if (util.isVal(me.member().safeMobile) == "") {
        me.content(
          "尊敬的会员您好，由于CKUMC会员中心系统账户安全升级，安全监测发现您会员账户尚未进行实名认证且未绑定安全手机，当前业务无法正常办理。请先完成安全手机绑定。"
        );
        me.yesBind("去绑定安全手机号");
        me.noBind("暂不绑定，继续办理其他业务");
        me.isbd(false);
      } else {
        var needFciFlag = me.kennelInfo().isNeedFciInfo;
        if ("1" == needFciFlag) {
          var fciName = me.kennelInfo().fciName;
          var fciNameBackup = me.kennelInfo().fciNameBackup;
          layer.open({
            type: 1,
            title: "fci犬舍名称",
            shadeClose: true,
            area: ["500px", "300px"],
            content:
              '<div style="padding-left:100px;"><ul>' +
              '<li style="margin-top:30px"><span>FCI英文名：</span><input type="text" id="updatefciNameVal"  value="' +
              fciName +
              '"><span style="color: red;float:none;"  id="updateNameEnShow"></span></li>' +
              '<li style="margin-top:30px;"><span>FCI备用名：</span><input type="text" id="updateFciNameBackupVal" value="' +
              fciNameBackup +
              '"><span style="color: red;float:none;"  id="updateFciNameBackupShow"></span></li>' +
              "</ul></div>",
            btn: ["确定", "取消"],
            yes: function(index) {
              var updateFciNameVal = $("#updatefciNameVal").val();
              var updateFciNameBackupVal = $("#updateFciNameBackupVal").val();
              var sendData1 = {
                isCheckType: "fciName",
                fciName: updateFciNameVal
              };
              util.sendAjax({
                url: "kennel/checkKennelName",
                data: JSON.stringify(sendData1),
                async: false,
                type: "POST",
                cache: false,
                success: function(json) {
                  if (json.rc == 0) {
                    $("#updateNameEnShow").text("犬舍英文名正确");
                    var sendData2 = {
                      isCheckType: "fciNameBackup",
                      fciNameBackup: updateFciNameBackupVal
                    };
                    var sendData = {
                      fciName: updateFciNameVal,
                      fciNameBackup: updateFciNameBackupVal
                    };
                    location.href =
                      location.href.split("#")[0] +
                      "#/order/renew?samePeriodRenewType=2";
                    layer.closeAll();
                    // util.sendAjax({
                    //   url: "kennel/renew",
                    //   data: JSON.stringify(sendData),
                    //   async: true,
                    //   loadFlag: true,
                    //   type: "POST",
                    //   cache: false,
                    //   success: function(json) {
                    //     if (json.rc == 0) {
                    //       context.app.changeCart();
                    //       layer.alert(
                    //         "业务添加成功，是否跳转到业务核对页面进行支付？",
                    //         {
                    //           time: 0, //不自动关闭
                    //           btn: ["跳转", "取消"],
                    //           yes: function(index) {
                    //             layer.closeAll();
                    //             location.href =
                    //               location.href.split("#")[0] + "#/order/check";
                    //           }
                    //         }
                    //       );
                    //     } else {
                    //       layer.msg(
                    //         "犬舍续费失败,错误代码:" +
                    //           json.rc +
                    //           "错误信息:" +
                    //           json.msg
                    //       );
                    //     }
                    //   }
                    // });
                  } else {
                    $("#updateNameEnShow").text(json.msg);
                  }
                }
              });
            }
          });
        } else {
          location.href =
            location.href.split("#")[0] + "#/order/renew?samePeriodRenewType=2";
          // util.sendAjax({
          //   url: "kennel/renew",
          //   data: {},
          //   async: false,
          //   type: "POST",
          //   cache: false,
          //   success: function(json) {
          //     if (json.rc == 0) {
          //       context.app.changeCart();
          //       layer.alert("业务添加成功，是否跳转到业务核对页面进行支付？", {
          //         time: 0, //不自动关闭
          //         btn: ["跳转", "取消"],
          //         yes: function(index) {
          //           layer.closeAll();
          //           location.href =
          //             location.href.split("#")[0] + "#/order/check";
          //         }
          //       });
          //     } else {
          //       layer.msg(
          //         "犬舍续费失败,错误代码:" + json.rc + "错误信息:" + json.msg
          //       );
          //     }
          //   }
          // });
        }
      }
    };
    //修改中文名称
    me.kennelNameUpdate = function() {
      var name = me.kennelInfo().name;
      var nameEn = me.kennelInfo().nameEn;
      var fciNameBackup = me.kennelInfo().fciNameBackup;
      layer.open({
        type: 1,
        title: "修改犬舍名称",
        shadeClose: true,
        area: ["500px", "300px"],
        content:
          '<div style="padding-left:100px;"><ul>' +
          '<li style="margin-top:30px;"><span>犬舍中文名：</span><input type="text" id="updateNameVal" value="' +
          name.substr(0, name.length - 2) +
          '">　犬舍<span style="color: red;float:none;"  id="updateNameShow"></span></li>' +
          '<li style="margin-top:30px"><span>犬舍英文名：</span><input type="text" id="updateNameEnVal"   value="' +
          nameEn +
          '"></li>' +
          "</ul></div>",
        btn: ["确定", "取消"],
        yes: function(index) {
          var updateNameVal = $("#updateNameVal").val();
          //后台校验
          var sendData = { isCheckType: "name", name: updateNameVal };
          util.sendAjax({
            url: "kennel/checkKennelName",
            data: JSON.stringify(sendData),
            async: false,
            type: "POST",
            cache: false,
            success: function(json) {
              if (json.rc == 0) {
                $("#updateNameShow").text("犬舍中文名正确");
                updateNameVal = util.removeg(updateNameVal);
                var updateNameEnVal = $("#updateNameEnVal").val();
                layer.close(index);
                me.kennelUpdateChinese(updateNameVal, updateNameEnVal);
              } else {
                $("#updateNameShow").text(json.msg);
              }
            }
          });
        }
      });
    };

    //修改FCI英文名称 20170321 by 柴雪腾 修改了文字显示
    me.kennelFciNameUpdate = function() {
      var name = me.kennelInfo().name;
      var fciName = me.kennelInfo().fciName;
      var fciNameBackup = me.kennelInfo().fciNameBackup;
      layer.open({
        type: 1,
        title: "修改FCI犬舍名称",
        shadeClose: true,
        area: ["500px", "300px"],
        content:
          '<div style="padding-left:100px;"><ul>' +
          '<li style="margin-top:30px"><span>FCI英文名：</span><input type="text" id="updatefciNameVal"  value="' +
          fciName +
          '"><span style="color: red;float:none;"  id="updateNameEnShow"></span></li>' +
          '<li style="margin-top:60px;"><span>FCI备用名：</span><input type="text" id="updateFciNameBackupVal" value="' +
          fciNameBackup +
          '"><span style="color: red;float:none;"  id="updateFciNameBackupShow"></span></li>' +
          "</ul></div>",
        btn: ["确定", "取消"],
        yes: function(index) {
          var updateFciNameVal = $("#updatefciNameVal").val();
          var updateFciNameBackupVal = $("#updateFciNameBackupVal").val();
          var sendData1 = { isCheckType: "fciName", fciName: updateFciNameVal };
          util.sendAjax({
            url: "kennel/checkKennelName",
            data: JSON.stringify(sendData1),
            async: false,
            type: "POST",
            cache: false,
            success: function(json) {
              if (json.rc == 0) {
                $("#updateNameEnShow").text("犬舍英文名正确");

                var sendData2 = {
                  isCheckType: "fciNameBackup",
                  fciNameBackup: updateFciNameBackupVal
                };
                util.sendAjax({
                  url: "kennel/checkKennelName",
                  data: JSON.stringify(sendData2),
                  async: false,
                  type: "POST",
                  cache: false,
                  success: function(json) {
                    if (json.rc == 0) {
                      $("#updateFciNameBackupShow").text("犬舍备用英文名正确");
                      layer.close(index);
                      me.kennelUpdateCommon(
                        updateFciNameVal,
                        updateFciNameBackupVal
                      );
                    } else {
                      $("#updateFciNameBackupShow").text(json.msg);
                    }
                  }
                });
              } else {
                $("#updateNameEnShow").text(json.msg);
              }
            }
          });
        }
      });
    };
    me.kennelUpdateChinese = function(name, nameEn) {
      //if(util.isVal(name)=="" || name.trim().length>4 ||util.isZhWord(name.trim())){
      //	layer.msg("犬舍中文名仅限输入汉字，长度在4个汉字以内！");
      //	return;
      //}
      var sendData = { name: name, nameEn: nameEn };
      util.sendAjax({
        url: "kennel/kennel",
        data: JSON.stringify(sendData),
        async: false,
        type: "PUT",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            layer.msg("修改犬舍名称成功！");
            userInfo.refresh();
            window.location.reload();
          } else {
            layer.msg(
              "修改犬舍名称失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };
    me.kennelUpdateCommon = function(fciName, fciNameBackup) {
      if (fciName.trim().length > 30 || !util.isEnWord(fciName.trim())) {
        layer.msg("犬舍英文名仅限输入英文字母，长度在30个字符以内！");
        return;
      }
      if (
        util.isVal(fciNameBackup) == "" ||
        fciNameBackup.trim().length > 30 ||
        !util.isEnWord(fciNameBackup.trim())
      ) {
        layer.msg("犬舍备用英文名仅限输入英文字母，长度在30个字符以内！");
        return;
      }
      var sendData = { fciName: fciName, fciNameBackup: fciNameBackup };
      util.sendAjax({
        url: "kennel/kennel",
        data: JSON.stringify(sendData),
        async: false,
        type: "PUT",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            layer.msg("修改犬舍名称成功！");
            userInfo.refresh();
            window.location.reload();
          } else {
            layer.msg(
              "修改犬舍名称失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };
    me.tokennelrenamelist = function() {
      util.sendAjax({
        url: "member/isActiveMember",
        data: {},
        async: false,
        type: "GET",
        cache: false,
        success: function(json) {
          if (json.data) {
            location.href =
              location.href.split("#")[0] + "#/member/kennelrenamelist";
          } else {
            layer.msg("该业务仅限有效专业会员及犬舍办理!");
          }
        }
      });
    };
    //点击绑定手机号/暂不绑定退出事件
    this.changeTopNav = function(type) {
      if (type == "no") {
        //退出
        me.isbd(true);
      } else if (type == "bd") {
        //绑定
        window.location.href =
          "login.html#/accountsecurity/identityverification";
      }
    };
    $(function() {
      var flagstate = false;
      var flagfcistate = false;
      if (userInfo.isKennel) {
        me.kennelInfo(userInfo.getKennel());
        me.isKennel(true);
        var flag =
          Math.floor(new Date(me.kennelInfo().endTime).getTime() / 1000) -
            Math.floor(new Date().getTime() / 1000) <
          0
            ? true
            : false;
        if (flag && me.kennelInfo().reviewState == "3") {
          me.isLastTime(false);
        } else if ("year" == me.kennelInfo().type) {
          me.isLastTime(true);
        } else {
          me.isLastTime(false);
        }

        if (me.kennelInfo().reviewState == "0") {
          me.reviewStateStr("待审核");
          me.kennelNameFlag(true);
        } else if (me.kennelInfo().reviewState == "1") {
          me.reviewStateStr("通过");
          flagstate = true;
        } else if (me.kennelInfo().reviewState == "2") {
          me.reviewStateStr("未通过");
          me.kennelNameFlag(true);
        } else {
          me.reviewStateStr("已注销");
        }
        if (me.kennelInfo().fciReviewState == "0") {
          me.fciReviewStateStr("待审核");
          if (
            Math.floor(new Date(me.kennelInfo().endTime).getTime() / 1000) -
              Math.floor(new Date().getTime() / 1000) >
            0
          ) {
            flagfcistate = true;
          }
          me.kennelFciNameFlag(true);
        } else if (me.kennelInfo().fciReviewState == "1") {
          me.fciReviewStateStr("通过");
          flagfcistate = true;
        } else if (me.kennelInfo().fciReviewState == "2") {
          me.fciReviewStateStr("未通过");
          me.kennelFciNameFlag(true);
        } else if (me.kennelInfo().fciReviewState == "4") {
          me.fciReviewStateStr("已注销");
        } else {
          me.fciReviewStateStr("审核中");
        }
        //start by 柴雪腾 犬舍必须中文通过 英文名存在才显示审核状态和修改按钮
        if (
          "" != me.kennelInfo().fciName &&
          "" != me.kennelInfo().fciNameBackup
        ) {
          me.checkFciLiFlag(true);
          if ("1" != me.kennelInfo().fciReviewState) {
            me.checkFciButtonFlag(true);
          } else {
            me.checkFciButtonFlag(false);
          }
        } else {
          me.checkFciLiFlag(false);
        }
        //end by 柴雪腾
        //start by
        if ("year" == me.kennelInfo().type) {
          if (
            me.kennelInfo().reviewState == "3" ||
            me.kennelInfo().endTime == ""
          ) {
            me.isUpgrade(false);
          } else {
            me.isUpgrade(true);
          }
        } else {
          me.isUpgrade(false);
        }

        //end by
      }
      if (flagstate && flagfcistate) {
        me.showKennelRename(true);
      }
    });
    context.app.loading(false);
    context.app.isShop(false);
  };
});
