//藏獒鉴定列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //会员信息
        var member = userInfo.getMember();
        me.member = ko.observable(member);
        //列表数据
        me.listData = ko.observableArray([]);
        //犬姓名
        me.dogName = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddogtibetanmastiffList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.finddogtibetanmastiffList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.finddogtibetanmastiffList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddogtibetanmastiffList(false);
            }
            return false;
        }
        //未通过原因的显隐
        me.showReason = function(data,event){
            if(data.reviewState=="不通过"||data.reviewState=="未通过") {
                if ($(event.target).siblings(".reason").css("display") == "none") {
                    $(event.target).siblings(".reason").css("display", "block");
                } else {
                    $(event.target).siblings(".reason").css("display", "none")
                }
            }
        }
        me.closeReason = function(data,event){
            $(event.target).parents(".reason").css("display","none")
        }
     
        /**
         * 犬只姓名列表查询方法
         */
        me.finddogtibetanmastiffList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["dogName"] = me.dogName().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/dogtibetanmastiff',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("藏獒鉴定申请列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        /**
         * 删除藏獒鉴定申请
         */
        me.deldogtibetanmastiff = function(data, event){
        	if(data.reviewState!="通过"){
	            //询问框
	            var deldeldogtibetanmastiff=layer.confirm('删除后将无法进行藏獒犬种鉴定！', {
	                btn: ['确定','关闭'] //按钮
	            }, function(){
	                var id = data.id;
	                util.sendAjax({
	                    url:'dog/dogtibetanmastiff/'+id,
	                    data:{},
	                    async:true,
	                    loadFlag:true,
	                    type:'DELETE',
	                    cache:false,
	                    success:function(data){
	                        if(data.rc==0){
	                            $(event.target).parents("tr").remove();
	                            layer.close(deldeldogtibetanmastiff);
	                            layer.msg("藏獒鉴定申请删除成功！");
	                        }else{
	                            layer.msg("藏獒鉴定申请删除失败:"+data.msg);
	                        }
	                    }
	                });
	            })
        	}else{
        		layer.msg("审核通过的不允许删除！");
        	}
        }
        me.isApply = function(){
            var  memberEndTime = new Date(new Date(util.formatDateLong(me.member().memberEndDate).replace(/-/g,"/"))).getTime()+86399000 - new Date().getTime();
            if(memberEndTime>=0 && me.member().memberType=="professional"){
                location.href = location.href.split("#")[0]+"#/dog/dogtibetanmastiffadd";
            }else{
                layer.msg("此业务仅限有效专业会员办理！");
            }
        }
        $(function(){
            me.finddogtibetanmastiffList(false);
            userInfo.refresh();
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});

