var util = {};
util.baseUrl = "http://vip.chongaibao.com/oa-web/";
util.setLSItem = function(key, value) {
  localStorage.setItem(key, value);
};
util.getLSItem = function(key) {
  return localStorage.getItem(key);
};
util.setSSItem = function(key, value) {
  sessionStorage.setItem(key, value);
};
util.getSSItem = function(key) {
  return sessionStorage.getItem(key);
};
/**
 *判断是否是空
 * @param val
 * @returns {*}
 */
util.isVal = function(val) {
  if (val == null || val == undefined || val == "" || val == NaN) {
    return "";
  } else {
    if (typeof str == "string") {
      val = val.replace(/(^\s+)|(\s+$)/g, "");
    }
    return val;
  }
};
//检查配种证明cku,ckutm开头
util.checkIsCKU = function(val) {
  var result = 0;
  val = val.toUpperCase();
  var ckuStr = val.substr(0, 3);
  var ckutmStr = val.substr(0, 5);
  if (ckuStr == "CKU") {
    result = 1;
  }
  if (ckutmStr == "CKUTM") {
    result = 1;
  }
  return result;
};
//去掉所有空格
util.removeg = function(val) {
  return val.replace(/\s/g, "");
};
util.isEmail = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    reg = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
    if (!reg.test(str)) {
      return false;
    } else {
      return true;
    }
  } else {
    return false;
  }
};
util.isMobile = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    reg = /^1[0-9][0-9]\d{4,8}$/;
    var aomenReg = /^((((0?)|((00)?))(((\s){0,2})|([-_－—\s]?)))|([+]?))(853)?([]?)([-_－—\s]?)(28[0-9]{2}|((6|8)[0-9]{3}))[-_－—\s]?[0-9]{4}$/;
    var taiwanReg = /^([-_－—\s\(]?)([\(]?)((((0?)|((00)?))(((\s){0,2})|([-_－—\s]?)))|(([\)]?)[+]?))(886)?([\)]?)([-_－—\s]?)([\(]?)[0]?[1-9]{1}([-_－—\s\)]?)[1-9]{2}[-_－—]?[0-9]{3}[-_－—]?[0-9]{3}$/;
    var xianggangReg = /^((((0?)|((00)?))(((\s){0,2})|([-_－—\s]?)))|(([(]?)[+]?))(852)?([)]?)([-_－—\s]?)((2|3|5|6|9)?([-_－—\s]?)\d{3})(([-_－—\s]?)\d{4})$/;
    if (
      reg.test(str) ||
      taiwanReg.test(str) ||
      xianggangReg.test(str) ||
      aomenReg.test(str)
    ) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
util.isCardNo = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    var reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
    var taiwanreg = /^[a-zA-Z]{1}[0-9]{9}$/;
    var xianggangreg = /^((\s?[A-Za-z])|([A-Za-z]{2}))\d{6}(([0−9aA])|([0-9aA]))$/;
    var aomenreg = /^[1|5|7][0-9]{6}\([0-9Aa]\)/;
    if (
      reg.test(str) ||
      taiwanreg.test(str) ||
      xianggangreg.test(str) ||
      aomenreg.test(str)
    ) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
util.isZhWord = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    reg = /[^\u4e00-\u9fa5]/g;
    if (!reg.test(str)) {
      return false;
    } else {
      return true;
    }
  } else {
    return false;
  }
};
util.isEnWord = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    reg = /^[A-Za-z\s]+$/;
    if (!reg.test(str)) {
      return false;
    } else {
      return true;
    }
  } else {
    return false;
  }
};
util.isEnAddress = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    reg = /^[a-zA-Z][\.a-zA-Z\s,0-9]*?[a-zA-Z]+$/;
    if (!reg.test(str)) {
      return false;
    } else {
      return true;
    }
  } else {
    return false;
  }
};
util.isEnNumAddress = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    reg = /^[A-Za-z0-9\s]+$/;
    if (!reg.test(str)) {
      return false;
    } else {
      return true;
    }
  } else {
    return false;
  }
};
/**
 * ajax 封装
 *
 */
util.sendAjax = function(obj, base) {
  var baseUrl = base ? base : "/oa-web/api/v1/";
  var url = baseUrl + obj.url;
  var data = obj.data;
  var async = obj.async;
  var loadFlag = obj.loadFlag == undefined ? false : obj.loadFlag;
  var type = obj.type;
  var cache = obj.cache;
  var successfn = obj.success;
  async =
    async == null || async === "" || typeof async == "undefined"
      ? "true"
      : async;
  cache =
    cache == null || cache === "" || typeof cache == "undefined"
      ? "false"
      : cache;
  type =
    type == null || type === "" || typeof type == "undefined"
      ? "GET"
      : type.toLocaleUpperCase();
  data =
    data == null || data === "" || typeof data == "undefined"
      ? { date: new Date().getTime() }
      : data;
  //POST,PUT 转化成json字符串
  if (type == "POST" || type == "PUT") {
  }
  $.ajax({
    type: type,
    async: async,
    data: data,
    url: url,
    cache: cache,
    contentType: "application/json;charset=UTF-8",
    dataType: "json",
    timeout: 30000,
    beforeSend: function(XMLHttpRequest) {
      if (loadFlag) {
        layer.load();
      }
    },
    success: function(json) {
      if (json != undefined && json.rc != undefined && json.rc == 2103) {
        window.location.href = "/oa-web/uc/index.html";
      } else {
        successfn(json);
      }
    },
    error: function(XMLHttpRequest, status, error) {
      if (XMLHttpRequest.status == 401) {
        window.location.href = "/oa-web/uc/login.html";
        return;
      }
      layer.msg("网络连接错误！", { icon: 5 });
    },
    complete: function(XMLHttpRequest, TS) {
      if (loadFlag) {
        layer.closeAll("loading");
      }
    }
  });
};
/**
 * 将form表单转化为json
 * @param frm
 * @returns {{}}
 */
util.getFormJson = function(frm) {
  var o = {};
  var a = $(frm).serializeArray();
  $.each(a, function() {
    if (o[this.name] !== undefined) {
      if (!o[this.name].push) {
        o[this.name] = [o[this.name]];
      }
      o[this.name].push(this.value || "");
    } else {
      o[this.name] = this.value || "";
    }
  });

  return o;
};
util.formatDateShort = function(str) {
  var now = null;
  if (typeof str == "string") {
    now = new Date(str);
    if (now == "Invalid Date") {
      now = new Date(str.replace(/-/g, "/"));
    }
  } else {
    now = str;
  }
  var year = now.getFullYear();
  var month = now.getMonth() + 1;
  var date = now.getDate();
  return (
    year + "-" + util.formatTwoLength(month) + "-" + util.formatTwoLength(date)
  );
};
util.formatDateLong = function(str) {
  var now = null;
  if (typeof str == "string") {
    now = new Date(str);
    if (now == "Invalid Date") {
      now = new Date(str.replace(/-/g, "/"));
    }
  } else {
    now = str;
  }
  var year = now.getFullYear();
  var month = now.getMonth() + 1;
  var date = now.getDate();
  var hour = now.getHours();
  var minute = now.getMinutes();
  var second = now.getSeconds();
  return (
    year +
    "-" +
    util.formatTwoLength(month) +
    "-" +
    util.formatTwoLength(date) +
    " " +
    util.formatTwoLength(hour) +
    ":" +
    util.formatTwoLength(minute) +
    ":" +
    util.formatTwoLength(second)
  );
};
util.formatTwoLength = function(str) {
  str = str + "";
  if (str.length == 1) {
    str = "0" + str;
  }
  return str;
};
util.getQueryString = function() {
  var url = location.href; //获取url中"?"符后的字串
  url = decodeURI(url);
  var theRequest = new Object();
  if (url.indexOf("?") != -1) {
    url = url.substring(url.indexOf("?") + 1);
    var str = url;
    strs = str.split("&");
    for (var i = 0; i < strs.length; i++) {
      theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
    }
  }
  return theRequest;
};

util.city = [
  {
    local: "北京市",
    localcity: [
      "丰台区",
      "昌平区",
      "西城区",
      "门头沟区",
      "怀柔区",
      "朝阳区",
      "顺义区",
      "东城区",
      "海淀区",
      "平谷区",
      "宣武区",
      "通州区",
      "延庆县",
      "石景山区",
      "大兴区",
      "崇文区",
      "房山区",
      "密云县"
    ]
  },
  {
    local: "上海市",
    localcity: [
      "普陀区",
      "浦东新区",
      "卢湾区",
      "杨浦区",
      "青浦区",
      "静安区",
      "嘉定区",
      "崇明县",
      "黄浦区",
      "虹口区",
      "松江区",
      "长宁区",
      "宝山区",
      "奉贤区",
      "闸北区",
      "金山区",
      "徐汇区",
      "闵行区",
      "南汇区"
    ]
  },
  {
    local: "天津市",
    localcity: [
      "和平区",
      "北辰区",
      "宁河县",
      "西青区",
      "红挢区",
      "蓟县",
      "南开区",
      "大港区",
      "河东区",
      "武清区",
      "宝坻区",
      "津南区",
      "汉沽区",
      "滨海新区",
      "东丽区",
      "河北区",
      "静海县",
      "河西区",
      "塘沽区"
    ]
  },
  {
    local: "重庆市",
    localcity: [
      "石柱土家族自治县",
      "万州区",
      "南川区",
      "南岸区",
      "长寿区",
      "梁平县",
      "云阳县",
      "彭水苗族土家族自治县",
      "大渡口区",
      "双挢区",
      "铜梁县",
      "垫江县",
      "巫溪县",
      "永川区",
      "九龙坡区",
      "黔江区",
      "壁山县",
      "开县",
      "酉阳土家族苗族自治县",
      "渝中区",
      "万盛区",
      "潼南县",
      "丰都县",
      "巫山县",
      "合川区",
      "沙坪坝区",
      "巴南区",
      "荣昌县",
      "忠县",
      "秀山土家族苗族自治县",
      "涪陵区",
      "北碚区",
      "綦江县",
      "城口县",
      "奉节县",
      "江津区",
      "江北区",
      "渝北区",
      "大足县",
      "武隆县"
    ]
  },
  {
    local: "河北省",
    localcity: [
      "廊坊市",
      "邢台市",
      "沧州市",
      "承德市",
      "邯郸市",
      "秦皇岛市",
      "张家口市",
      "石家庄市",
      "唐山市",
      "保定市",
      "衡水市"
    ]
  },
  {
    local: "山西省",
    localcity: [
      "阳泉市",
      "临汾市",
      "朔州市",
      "大同市",
      "晋中市",
      "晋城市",
      "太原市",
      "忻州市",
      "长治市",
      "运城市",
      "吕梁市"
    ]
  },
  {
    local: "内蒙古自治区",
    localcity: [
      "乌海市",
      "锡林郭勒盟市",
      "阿拉善盟市",
      "通辽市",
      "包头市",
      "乌兰察布盟市",
      "呼伦贝尔盟市",
      "伊克昭盟市",
      "呼和浩特市",
      "兴安盟市",
      "赤峰市",
      "巴彦淖尔盟市",
      "哲里木盟市",
      "鄂尔多斯市"
    ]
  },
  {
    local: "辽宁省",
    localcity: [
      "鞍山市",
      "辽阳市",
      "丹东市",
      "朝阳市",
      "大连市",
      "阜新市",
      "本溪市",
      "铁岭市",
      "沈阳市",
      "营口市",
      "抚顺市",
      "盘锦市",
      "锦州市",
      "葫芦岛市"
    ]
  },
  {
    local: "吉林省",
    localcity: [
      "松原市",
      "四平市",
      "白山市",
      "吉林市",
      "延边市",
      "通化市",
      "长春市",
      "白城市",
      "辽源市"
    ]
  },
  {
    local: "黑龙江省",
    localcity: [
      "大庆市",
      "七台河市",
      "哈尔滨市",
      "鸡西市",
      "佳木斯市",
      "伊春市",
      "鹤岗市",
      "牡丹江市",
      "双鸭山市",
      "绥化市",
      "大兴安岭市",
      "齐齐哈尔市",
      "黑河市"
    ]
  },
  {
    local: "江苏省",
    localcity: [
      "盐城市",
      "淮安市",
      "镇江市",
      "常州市",
      "扬州市",
      "泰州市",
      "南京市",
      "连云港市",
      "南通市",
      "宿迁市",
      "徐州市",
      "苏州市",
      "无锡市"
    ]
  },
  {
    local: "浙江省",
    localcity: [
      "嘉兴市",
      "丽水市",
      "金华市",
      "温州市",
      "台州市",
      "绍兴市",
      "宁波市",
      "舟山市",
      "湖州市",
      "杭州市",
      "衢州市"
    ]
  },
  {
    local: "安徽省",
    localcity: [
      "安庆市",
      "阜阳市",
      "蚌埠市",
      "宿州市",
      "亳州市",
      "铜陵市",
      "巢湖市",
      "芜湖市",
      "滁州市",
      "宣城市",
      "淮北市",
      "淮南市",
      "合肥市",
      "黄山市",
      "六安市",
      "马鞍山市",
      "池州市"
    ]
  },
  {
    local: "福建省",
    localcity: [
      "福州市",
      "龙岩市",
      "三明市",
      "南平市",
      "莆田市",
      "漳州市",
      "厦门市",
      "宁德市",
      "泉州市"
    ]
  },
  {
    local: "江西省",
    localcity: [
      "新余市",
      "景德镇市",
      "宜春市",
      "萍乡市",
      "南昌市",
      "吉安市",
      "鹰潭市",
      "上饶市",
      "赣州市",
      "九江市",
      "抚州市"
    ]
  },
  {
    local: "山东省",
    localcity: [
      "临沂市",
      "青岛市",
      "泰安市",
      "滨州市",
      "东营市",
      "莱芜市",
      "济南市",
      "济宁市",
      "聊城市",
      "枣庄市",
      "日照市",
      "潍坊市",
      "德州市",
      "淄博市",
      "威海市",
      "菏泽市",
      "烟台市"
    ]
  },
  {
    local: "河南省",
    localcity: [
      "洛阳市",
      "许昌市",
      "驻马店市",
      "鹤壁市",
      "南阳市",
      "开封市",
      "濮阳市",
      "周口市",
      "安阳市",
      "三门峡市",
      "郑州市",
      "焦作市",
      "信阳市",
      "平顶山市",
      "漯河市",
      "济源市",
      "新乡市",
      "商丘市"
    ]
  },
  {
    local: "湖北省",
    localcity: [
      "潜江市",
      "荆门市",
      "随州市",
      "宜昌市",
      "恩施市",
      "鄂州市",
      "黄石市",
      "仙桃市",
      "武汉市",
      "十堰市",
      "孝感市",
      "襄阳市",
      "天门市",
      "黄冈市",
      "咸宁市",
      "荆州市"
    ]
  },
  {
    local: "湖南省",
    localcity: [
      "长沙市",
      "益阳市",
      "湘潭市",
      "郴州市",
      "邵阳市",
      "张家界市",
      "株洲市",
      "怀化市",
      "岳阳市",
      "湘西市",
      "常德市",
      "娄底市",
      "衡阳市",
      "永州市"
    ]
  },
  {
    local: "广东省",
    localcity: [
      "肇庆市",
      "潮州市",
      "广州市",
      "韶关市",
      "汕尾市",
      "汕头市",
      "茂名市",
      "清远市",
      "佛山市",
      "梅州市",
      "云浮市",
      "珠海市",
      "湛江市",
      "阳江市",
      "中山市",
      "惠州市",
      "揭阳市",
      "深圳市",
      "江门市",
      "河源市",
      "东莞市"
    ]
  },
  {
    local: "广西壮族自治区",
    localcity: [
      "北海市",
      "河池市",
      "南宁市",
      "贵港市",
      "梧州市",
      "贺州市",
      "钦州市",
      "崇左市",
      "桂林市",
      "百色市",
      "防城港市",
      "来宾市",
      "柳州市",
      "玉林市"
    ]
  },
  { local: "海南省", localcity: ["海口市", "三沙市", "三亚市"] },
  {
    local: "四川省",
    localcity: [
      "绵阳市",
      "眉山市",
      "甘孜藏族自治州",
      "自贡市",
      "内江市",
      "雅安市",
      "德阳市",
      "宜宾市",
      "阿坝藏族羌族自治州",
      "成都市",
      "遂宁市",
      "达州市",
      "泸州市",
      "南充市",
      "资阳市",
      "广元市",
      "广安市",
      "凉山彝族自治州",
      "攀枝花市",
      "乐山市",
      "巴中市"
    ]
  },
  {
    local: "贵州省",
    localcity: [
      "黔西南布依族苗族州",
      "六盘水市",
      "黔南布依族苗族州",
      "铜仁市",
      "贵阳市",
      "黔东南苗族侗族州",
      "安顺市",
      "毕节市",
      "遵义市"
    ]
  },
  {
    local: "云南省",
    localcity: [
      "楚雄彝族自治州",
      "迪庆藏族自治州",
      "保山市",
      "昭通市",
      "文山壮族苗族自治州",
      "临沧市",
      "怒江傈僳族自治州",
      "玉溪市",
      "红河哈尼族彝族自治州",
      "普洱市",
      "德宏傣族景颇族自治州",
      "曲靖市",
      "大理白族自治州",
      "丽江市",
      "西双版纳傣族自治州",
      "昆明市"
    ]
  },
  {
    local: "西藏自治区",
    localcity: [
      "那曲地区",
      "山南地区",
      "阿里地区",
      "日喀则地区",
      "昌都地区",
      "拉萨市",
      "林芝地区"
    ]
  },
  {
    local: "陕西省",
    localcity: [
      "铜川市",
      "榆林市",
      "咸阳市",
      "商洛市",
      "延安市",
      "宝鸡市",
      "安康市",
      "渭南市",
      "西安市",
      "汉中市"
    ]
  },
  {
    local: "甘肃省",
    localcity: [
      "兰州市",
      "武威市",
      "白银市",
      "平凉市",
      "张掖市",
      "甘南自治州",
      "金昌市",
      "陇南市",
      "酒泉市",
      "临夏自治州",
      "嘉峪关市",
      "定西市",
      "天水市",
      "庆阳市"
    ]
  },
  {
    local: "宁夏回族自治区",
    localcity: ["银川市", "固原市", "吴忠市", "石嘴山市", "中卫市"]
  },
  {
    local: "青海省",
    localcity: [
      "果洛藏族自治州",
      "海南藏族自治州",
      "玉树藏族自治州",
      "海东市",
      "黄南藏族自治州",
      "西宁市",
      "海西蒙古族藏族自治州",
      "海北藏族自治州"
    ]
  },
  {
    local: "新疆维吾尔族自治区",
    localcity: [
      "昌吉回族自治州",
      "阿克苏地区",
      "石河子市",
      "吐鲁番地区",
      "巴音郭楞蒙古自治州",
      "和田地区",
      "乌鲁木齐市",
      "博尔塔拉蒙古自治州",
      "伊犁市",
      "喀什地区",
      "克孜勒苏柯尔克孜自治州",
      "克拉玛依市",
      "哈密地区"
    ]
  }
  /*	,
	{local:"香港特别行政区",localcity:["香港特别行政区"]},
	{local:"澳门特别行政区",localcity:["澳门特别行政区"]},
	{local:"台湾省",localcity:["马祖","云林","宜兰","台中","苗栗","金门","南投","桃园","高雄","彰化","台东","屏东","花莲","澎湖","台北","新竹","基隆","台南","嘉义"]},
	{local:"国外",localcity:["国外"]}*/
];
/**
 *截止时间
 */
util.endTime = function(durTime) {
  var day = 0;
  var hour = 0;
  var min = 0;
  if (durTime >= 24 * 60 * 60 * 1000) {
    day = Math.floor(durTime / (24 * 60 * 60 * 1000));
    durTime = durTime - day * 24 * 60 * 60 * 1000;
    hour = Math.floor(durTime / (60 * 60 * 1000));
    durTime = durTime - hour * 60 * 60 * 1000;
    min = Math.floor(durTime / (60 * 1000));
  } else if (durTime >= 60 * 60 * 1000) {
    hour = Math.floor(durTime / (60 * 60 * 1000));
    durTime = durTime - hour * 60 * 60 * 1000;
    min = Math.floor(durTime / (60 * 1000));
  } else if (durTime >= 0) {
    min = Math.floor(durTime / (60 * 1000));
  }
  return day + "天" + hour + "小时" + min + "分";
};
util.getPageArray = function(currentPage, totalNum, pageSize) {
  var totalPage = null;
  if (totalNum % 10 == 0) {
    totalPage = parseInt(totalNum / pageSize);
  } else {
    totalPage = parseInt(totalNum / pageSize) + 1;
  }

  var array = new Array();

  var length = 8;
  var first = 1;
  var slider = 1;
  var begin = currentPage - parseInt(length / 2);
  if (begin < 1) {
    begin = 1;
  }
  var end = begin + length - 1;
  var last = totalPage;
  if (end >= last) {
    end = last;
    begin = end - length + 1;
    if (begin < first) {
      begin = first;
    }
  }
  if (begin > first) {
    var i = 0;
    for (i = first; i < first + slider && i < begin; i++) {
      array.push({ pageNo: i, pageName: i });
    }
    if (i < begin) {
      array.push({ pageNo: -1, pageName: "..." });
    }
  }

  for (var i = begin; i <= end; i++) {
    array.push({ pageNo: i, pageName: i });
  }

  if (last - end > slider) {
    array.push({ pageNo: -1, pageName: "..." });
    end = last - slider;
  }

  for (var i = end + 1; i <= last; i++) {
    array.push({ pageNo: i, pageName: i });
  }

  //	if(totalPage>9){
  //		//插入首页
  //		if(currentPage>5){
  //			array.push({"pageNo":1,"pageName":1});
  //			array.push({"pageNo":-1,"pageName":"..."})
  //		}
  //
  //		//当前页码小于等于5，则插入全部的前面页码
  //		if(currentPage<=5){
  //			for(var i=1;i<currentPage;i++){
  //				array.push({"pageNo":i,"pageName":i});
  //			}
  //		}
  //
  //		//插入当前页
  //		array.push({"pageNo":currentPage,"pageName":currentPage});
  //
  //		//当前页码之后继续插入剩余页码
  //		for(var i=currentPage+1;i<totalPage&&i<currentPage+4;i++){
  //			array.push({"pageNo":i,"pageName":i});
  //		}
  //
  //		if(totalPage-currentPage>=4){
  //			//添加...页面
  //			array.push({"pageNo":-1,"pageName":"..."});
  //			//添加末页
  //			array.push({"pageNo":totalPage,"pageName":totalPage})
  //		}
  //
  //	}
  //	else{
  //		//直接顺序输出所有的页码
  //		for(var i=1;i<=totalPage;i++){
  //			array.push({"pageNo":i,"pageName":i});
  //		}
  //	}
  return array;
};
//密码安全度校验
util.isSimplePassword = function(val) {
  var str = val.trim();
  if (str.length != 0) {
    reg = /^(?:\d+|[a-zA-Z]+)$/;
    if (reg.test(str)) {
      return true;
    } else {
      return false;
    }
  } else {
    return true;
  }
};

/**
 * [通过参数名获取url中的参数值]
 * 示例URL:http://htmlJsTest/getrequest.html?uid=admin&rid=1&fid=2&name=小明
 * @param  {[string]} queryName [参数名]
 * @return {[string]}           [参数值]
 */
util.GetQueryValue = function(queryName) {
  var url = location.href; //获取url中"?"符后的字串
  url = decodeURI(url);
  var theRequest = new Object();
  if (url.indexOf("?") != -1) {
    url = url.substring(url.indexOf("?") + 1);
    var str = url;
    strs = str.split("&");
    for (var i = 0; i < strs.length; i++) {
      theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
    }
  }
  if (theRequest[queryName]) {
    return theRequest[queryName];
  }

  return null;
};

/**
 * 解析url参数
 * @example ?id=12345&a=b
 * @return Object {id:12345, a:b}
 * */
util.urlParse = function() {
  var url = window.location.search;
  var obj = {};
  var reg = /[?&][^?&]+=[^?&]+/g;
  var arr = url.match(reg);
  // ['?id=12345','&a=b']
  if (arr) {
    for (var i = 0; i < arr.length; i++) {
      var tempArr = arr[i].substr(1).split("=");
      var key = decodeURIComponent(tempArr[0]);
      var val = decodeURIComponent(tempArr[1]);
      obj[key] = val;
    }
  }
  return obj;
};

/**
 * 解析url参数
 * @example Object {id:12345, a:b}
 * @return  id=12345&a=b
 * */
util.convertObj = function(data) {
  var _result = [];
  for (var key in data) {
    var value = data[key];
    if (value.constructor == Array) {
      value.forEach(function(_value) {
        _result.push(key + "=" + _value);
      });
    } else {
      _result.push(key + "=" + value);
    }
  }
  return _result.join("&");
};

// 复制的方法
util.copyText = function(text, callback) {
  // text: 要复制的内容， callback: 回调
  var tag = document.createElement("input");
  tag.setAttribute("id", "cp_hgz_input");
  tag.value = text;
  document.getElementsByTagName("body")[0].appendChild(tag);
  document.getElementById("cp_hgz_input").select();
  document.execCommand("copy");
  document.getElementById("cp_hgz_input").remove();
  if (callback) {
    callback(text);
  }
};
// localstorage本地定时缓存
util.timeLocalStorage = {
  Cache: {
    /**
     * 总容量5M
     * 存入缓存，支持字符串类型、json对象的存储
     * 页面关闭后依然有效 ie7+都有效
     * @param key 缓存key
     * @param stringVal
     * @time 数字 缓存有效时间（秒） 默认60s
     * 注：localStorage 方法存储的数据没有时间限制。第二天、第二周或下一年之后，数据依然可用。不能控制缓存时间，故此扩展
     * */
    put: function(key, stringVal, time) {
      try {
        if (!localStorage) {
          return false;
        }
        if (!time || isNaN(time)) {
          time = 60;
        }
        var cacheExpireDate = new Date() - 1 + time * 1000;
        var cacheVal = {
          val: stringVal,
          exp: cacheExpireDate
        };
        localStorage.setItem(key, JSON.stringify(cacheVal)); //存入缓存值
      } catch (e) {}
    },
    /**获取缓存*/
    get: function(key) {
      try {
        if (!localStorage) {
          return false;
        }
        var cacheVal = localStorage.getItem(key);
        var result = JSON.parse(cacheVal);
        var now = new Date() - 1;
        if (!result) {
          return null;
        } //缓存不存在
        if (now > result.exp) {
          //缓存过期
          this.remove(key);
          return "";
        }
        return result.val;
      } catch (e) {
        this.remove(key);
        return null;
      }
    },
    /**移除缓存，一般情况不手动调用，缓存过期自动调用*/
    remove: function(key) {
      if (!localStorage) {
        return false;
      }
      localStorage.removeItem(key);
    },
    /**清空所有缓存*/
    clear: function() {
      if (!localStorage) {
        return false;
      }
      localStorage.clear();
    }
  } //end Cache
};
