<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名信息查看</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxSchools}/schoolsGroomerRegister/groomerRegisterList">美容师报名列表</a></li>
		<li class="active"><a href="${ctxSchools}/schoolsGroomerRegister/view?id=${groomerRegister.id}">报名信息查看</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="groomerRegister"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.memberCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.name) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label> 
			<div class="controls">
				${fns:escapeHtml(groomerRegister.mobile) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label> 
			<div class="controls">
				${fns:getDictLabel(groomerRegister.gender, 'user_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
            <div id="otherLevelO" class="controls">
            	<c:set var="showCategory" value="${groomerRegister.groomerShow.showCategory}"></c:set>
				<c:choose>
				    <c:when test="${showCategory eq '1'}">
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="C"  ${fns:splitContains(groomerRegister.showLevel,"C",",")?"checked":""}/>
						<label>C</label>
				    </c:when>
				    <c:when test="${showCategory eq '2'}">
				    	<input name="showLevel" maxlength="50" class="disabled" type="radio" value="国际宠物美容师"  ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '3'}">
				    	<input name="showLevel" maxlength="50" class="disabled" type="radio" value="国际宠物美容师"  ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="宠物造型师&国际宠物美容师"  ${fns:splitContains(groomerRegister.showLevel,"宠物造型师&国际宠物美容师",",")?"checked":""}/>
						<label>宠物造型师&国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '4'}">
				    	<oa:dictRadios name="showLevel" value="${groomerRegister.showLevel}" cssClass="input-xlarge required" type="groomer_nurse_level" readonly="true" rangeItems="${groomerRegister.groomerShow.testLevel}"></oa:dictRadios>
				    </c:when>
					<c:when test="${showCategory eq '6'}">
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="C"  ${fns:splitContains(groomerRegister.showLevel,"C",",")?"checked":""}/>
						<label>C</label>
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="B"  ${fns:splitContains(groomerRegister.showLevel,"B",",")?"checked":""}/>
						<label>B</label>
						<input name="showLevel" maxlength="50" class="disabled" type="radio" value="A"  ${fns:splitContains(groomerRegister.showLevel,"A",",")?"checked":""}/>
						<label>A</label>
					</c:when>
					<c:when test="${showCategory eq '8'}">
						<oa:dictRadios name="showLevel" value="${groomerRegister.showLevel}" cssClass="input-xlarge required" type="groomer_cat_nurse_level" readonly="true" rangeItems="${groomerRegister.groomerShow.testLevel}"></oa:dictRadios>
					</c:when>
				    <c:otherwise>
				    	活动类型错误
				    </c:otherwise>
				</c:choose>
            </div>
		</div>
		
		<div class="control-group" style="width:80%">
			<label class="control-label">证件照：</label>
			<div class="controls">
				<img id="avatar" alt="" src="${ctxSchools}/file/image/${groomerRegister.avatar}" style="padding:10px;height:130px;"/>
			</div>
		</div>
		
	
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>	
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.groomerShow.showName) }
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.showCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动分类：</label>
			<div class="controls">
					${fns:getDictLabel(groomerRegister.groomerShow.showCategory, 'groomer_show_category', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.fee) }
			</div>
		</div>
	
		<div id="hiddenDiv"  class="control-group">
			<label class="control-label">比赛犬种：</label>
			<div class="controls">
				${fns:substringAfter(groomerRegister.showDogBreedStr,",")}
				${not empty groomerRegister.showDogBreedExtra?"# ":""}
				${fns:substringAfter(groomerRegister.showDogBreedExtra,",")}
			</div>
		</div>
		<c:if test="${groomerRegister.reviewState=='2' }">
			<div class="control-group">
				<label class="control-label">未通过原因：</label>
				<div class="controls">
					<font color="red">${fns:escapeHtml(groomerRegister.reviewRemarks)}</font>
				</div>
			</div>
		</c:if>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>