<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function birthCode(){
			layer.open({
	            type: 1,
	            title: "请输入新生犬身份识别登记卡编号",
	            shadeClose: true,
	            area: ['300px', '180px'],
	            content: '<form id="birthForm" action="${ctxPartner}/clubMember/validBirth"><div>'+
	            '<span>登记卡编号 :</span><input type="text" id="birthCode" name="birthCode" ></span></div></form>'
	            ,btn: ['确定', '取消']
	    		,yes: function(index){
	    			var a = $("#birthCode").val();
	    			if(a!=''){
	    				$("#birthForm").submit();
	    			}
	    		}
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxPartner}/clubMember/dogList">已缴费</a></li>
		<li class="active"><a href="${ctxPartner}/clubMember/dogOldList">未缴费</a></li>
		<li><a href="${ctxPartner}/clubMember/dogChipInjectList">芯片代打未缴费</a></li>
		<li><a href="${ctxPartner}/clubMember/dogAllNestList">整窝办理</a></li>

	</ul>
	<form:form id="searchForm" modelAttribute="dogBirthCertificate" action="${ctxPartner}/clubMember/dogOldList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="birthCerRegCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>申请时间从：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>申请时间至：</label>
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><font style="color:red;font-size:18px;">特别提醒:办理业务请于当天24点前缴费!</font></li>
		<%--	<li class="btns" style="float:right"><button  class="btn btn-primary" type="button" onclick="birthCode()" >新申请血统证书</button></li>
		--%>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>新犬主</th>
				<th>申请日期</th>
				<th>缴费</th>
				<th>删除</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBirthCertificate">
			<tr>
				<td>
					${fns:escapeHtml(dogBirthCertificate.birthCerRegCode)}
				</td>
				<td title="${fns:escapeHtml(dogBirthCertificate.tempMemberCode)}">
						${fns:escapeHtml(dogBirthCertificate.tempUserName)}
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
    			<td>
    				<c:choose>
    					<c:when test="${dogBirthCertificate.dogChip.paymentState=='2'&& dogBirthCertificate.dogChip.reviewState=='1' }">
    						<a style="color:red;" href="${ctxPartner}/clubMember/payment?birthid=${dogBirthCertificate.id}">办理缴费</a>
    					</c:when>
    					<c:when test="${dogBirthCertificate.dogChip.paymentState=='1'&& dogBirthCertificate.dogChip.reviewState=='0' }">
							<a style="color:red;" href="${ctxPartner}/clubMember/payment?birthid=${dogBirthCertificate.id}">办理缴费</a>
    					</c:when>
    				</c:choose>
    			</td>
    			<td>
    				<c:if test="${dogBirthCertificate.dogChip.paymentState=='1' }">
						<a href="${ctxPartner}/clubMember/deleteBirth?birthId=${dogBirthCertificate.id}" onclick="return confirmx('确认要删除该出生证明吗？', this.href)">删除</a>
    				</c:if>
    			</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>