<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容学校邮寄管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/trainschool/groomerSchoolMail/">美容学校邮寄列表</a></li>
    <shiro:hasPermission name="trainschool:groomerSchoolMail:edit">
        <li><a href="${ctx}/trainschool/groomerSchoolMail/form">美容学校邮寄添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="groomerSchoolMail" action="${ctx}/trainschool/groomerSchoolMail/"
           method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <form:hidden path="schoolId"/>
    <%--<ul class="ul-form">
                <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
                <li class="clearfix"></li>
            </ul>--%>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>美容学校名称</th>
        <th>发放日期</th>
        <th>发放数量</th>
        <th>备注信息</th>
        <shiro:hasPermission name="trainschool:groomerSchoolMail:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="groomerSchoolMail">
        <tr>
            <td>
                    ${groomerSchoolMail.schoolNameCn}
            </td>
            <td>
                <fmt:formatDate value="${groomerSchoolMail.releaseDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                    ${groomerSchoolMail.releaseNum}
            </td>
            <td>
                    ${groomerSchoolMail.remarks}
            </td>
            <shiro:hasPermission name="trainschool:groomerSchoolMail:edit">
                <td>
                    <a href="${ctx}/trainschool/groomerSchoolMail/form?id=${groomerSchoolMail.id}">修改</a>
                    <a href="${ctx}/trainschool/groomerSchoolMail/delete?id=${groomerSchoolMail.id}"
                       onclick="return confirmx('确认要删除该美容学校邮寄吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>