<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作学校管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					var id = '${trainingInstitution.id}';
					var password = $("#password").val();
					if(id==''&&password==''){
						alert("请填写登录密码");
						return 0;
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			//删除学校类型除1和7以外的
			$("#schoolType option").each(function() {
				var text = $(this).text(); //获取option的text
				var value = $(this).val(); //获取option的value
				if(value==""||value=="1"||value=="7"){
				}else{
					$(this).remove();
				}
			});

			//开放状态回显
			var loginFlag = '${trainingInstitution.user.loginFlag}';
			$("#user.loginFlag").find("option[value='"+loginFlag+"']").attr("selected",true);

			//以下字段如果有值不允许编辑
			var loginName = '${trainingInstitution.user.loginName}';
			if(loginName!=''){
				$("#loginName").attr("disabled",true);
				$("#passwordDiv").append("<span class='help-inline'><font color='red'>空值为不修改</font></span>");
			}else{
				$("#passwordDiv").append("<span class='help-inline'><font color='red'>*</font></span>");
			}
			var schoolShortName = '${trainingInstitution.schoolShortName}';
			if(schoolShortName!=''){
				$("#schoolShortName").attr("disabled",true);
			}

			var id = '${trainingInstitution.id}';
			if(id==''){
				//密码默认为123456
				$("#password").val("123456");
			}
		});

		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}

		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#responsibler").val(json.name);
			$("#memberCode").val(json.memberCode);
			$("#telephone").val(json.mobile);
		}
		
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/trainschool/trainingInstitution/groomerForm?id=${trainingInstitution.id}">合作学校<shiro:hasPermission name="trainschool:groomer:edit">${not empty trainingInstitution.id?'修改':'添加'}</shiro:hasPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="trainingInstitution" action="${ctx}/trainschool/trainingInstitution/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">登录帐号：</label>
			<div class="controls">
				<form:input id="loginName" path="user.loginName" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登录密码：</label>
			<div class="controls" id="passwordDiv">
				<form:input onfocus="this.type='password'" path="password" htmlEscape="false" maxlength="100" class="input-xlarge"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">学校中文名：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校英文名：</label>
			<div class="controls">
				<form:input path="schoolNameEn" htmlEscape="false" maxlength="100" class="input-xlarge  required"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">英文名缩写：</label>
			<div class="controls">
				<form:input path="schoolShortName" htmlEscape="false" maxlength="64" class="input-xlarge isEnglish required"/>
				<span class="help-inline"><font color="red">*</font></span>
				<ul>
					<li><font color="red">注:生成证书号必备!</font></li>
				</ul>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校资质：</label>
			<div class="controls">
				<%--<form:input path="schoolNameEn" htmlEscape="false" maxlength="100" class="input-xlarge  required"/>--%>
				<form:select path="qualifications" class="input-small">
					<form:options items="${fns:getDictList('qualifications')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-large required">
					<form:option value="" label="请选择"/>
					<c:forEach items="${province}" var="p">
						<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-large required">
					<form:option value="" label="请选择"/>
					<c:forEach items="${city}" var="c">
						<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				var extId = $("#province").val();
				//异步请求数据
				var url="${ctx}"+"/sys/area/treeData";
				$.get(url,{extId:extId},function(data){
					var content = "<option value=''></option>";
					for(var i in data){
						content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
					}
					$("#city").html(content).trigger("change");
				},"json")

			})
		</script>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">地址：</label>
			<div class="controls">
			${fns:escapeHtml(trainingInstitution.address)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">负责人会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" readonly="true" maxlength="100" class="input-large required"/>
				<%--<input type="hidden" name="memberName" id="memberName" value="${paymentProjectCart.memberName}">--%>
				<%--<input type="text" class="form-control" id="memberCode" readonly name="memberCode" value="${paymentProjectCart.memberCode}" required title="会员号不能为空！">--%>
				<button type="button" class="btn btn-default" onclick="searchUser()">查</button>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">负责人：</label>
			<div class="controls">
				<form:input path="responsibler" htmlEscape="false" readonly="true" maxlength="64" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">联系电话：</label>
			<div class="controls">
				<form:input path="telephone" htmlEscape="false" maxlength="64" class="input-xlarge isTel required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校类别：</label>
			<div class="controls">
				<form:select path="schoolType" class="input-medium required">
					<form:option value="" label="请选择"/>
					<form:options items="${fns:getDictList('school_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">合作开始日期：</label>
			<div class="controls">
				<%--<fmt:formatDate value="${trainingInstitution.startDate}" pattern="yyyy-MM-dd"/>--%>
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					   value="<fmt:formatDate value="${trainingInstitution.startDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止日期：</label>
			<div class="controls">
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${trainingInstitution.member.memberEndDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">开放状态：</label>
			<div class="controls">
				<form:select path="user.loginFlag" class="input-small required">
					<form:option value="1" label="是"/>
					<form:option value="0" label="否"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">合作编号：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.schoolMemberCode)}
			</div>
		</div>
		<div style = "clear:both;"/>
<%--		<div class="control-group">
			<label class="control-label">地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" maxlength="150" class="input-xlarge required"/>
			</div>
		</div>--%>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">学校logo：</label>
			<div class="controls">
				<sys:singleImgUpload module="trainingInstitution" imgId="${trainingInstitution.avatarBack}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<%--<span class="help-inline"><font color="#aaaaaa">只支持.jpg格式</font> </span>--%>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">详细介绍：</label>
			<div class="controls">
				<form:textarea path="introduce" htmlEscape="false" rows="4" maxlength="200" class="input-xxlarge " placeholder ="文本格式，200字以内"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="form-actions">
			<shiro:hasPermission name="trainschool:groomer:edit"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存" onclick="msgAlert()"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
		<script type="text/javascript">
			function msgAlert(){
				var id = $("#id").val();
				if(id==''){
					$("#inputForm").submit();
				}else{
					layer.confirm('该操作将同时更新同名学校的地址与电话!', {
						btn: ['确认','取消'] //按钮
					}, function(){
						$("#inputForm").submit();
					}, function(){
						layer.msg('已取消');
					});
				}
			}
		</script>
	</form:form>
</body>
</html>