<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>待邮寄物品管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option value='' code=''>全部</option>";
						var lists = json.items;
						var option = "";
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${expressQueue.province}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#province").append(html);
						if(option!=''){
							$("#province").val(option).select2().change();
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});




		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	
	
	
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/expressQueue/">待邮寄物品列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="expressQueue" action="${ctx}/sys/expressQueue/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li><label>会员姓名：</label>
				<form:input path="memberName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>省份：</label>
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
			</li>
			<li><label>城市：</label>
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
			</li>
				<script>
					$("#province").change(function(){
						$("#city").empty().val("").select2();
						$("#area").empty().val("").select2();
						var code = $(this).find("option:selected").attr("code");
						$.ajax({
							url:'${ctxCity}',
							data: {province_code:code},
							async:true,
							loadFlag:true,
							type:'get',
							cache:false,
							success:function(json){
								if(json.rc==0){
									var option = "";
									var html = "<option value='' code=''>全部</option>";
									var lists = json.items;
									for(var i = 0;i<lists.length;i++){
										html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
										if('${expressQueue.city}'==lists[i].city) {
											option = lists[i].city;
										}
									}
									$("#city").append(html);
									if(option!=''){
										$("#city").val(option).select2().change();
									}
								}else{
									layer.msg(json.msg);
								}
							}
						});
					})
				</script>
			<li><label>区域：</label>
				<form:select id="area" path="area" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
			</li>
			<script>
				$("#city").change(function(){
					$("#area").empty().val("").select2();
					var code = $(this).find("option:selected").attr("code");
					$.ajax({
						url:'${ctxArea}',
						data: {city_code:code},
						async:true,
						loadFlag:true,
						type:'get',
						cache:false,
						success:function(json){
							if(json.rc==0){
								var option = "";
								var html = "<option value='' code=''>全部</option>";
								var lists = json.items;
								for(var i = 0;i<lists.length;i++){
									html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
									if('${expressQueue.area}'==lists[i].area) {
										option = lists[i].area;
									}
								}
								$("#area").append(html);
								if(option!=''){
									$("#area").val(option).select2().change();
								}
							}else{
								layer.msg(json.msg);
							}
						}
					});
				})
			</script>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>会员姓名</th>
				<th>省份</th>
				<th>城市</th>
				<th>区域</th>
				<th>街道</th>
				<th>待收货物</th>
				<shiro:hasPermission name="sys:expressQueue:delete"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="expressQueue">
			<tr>
				<td>
					${expressQueue.memberCode}
				</td>
				<td>
					${expressQueue.memberName}
				</td>
				<td>
					${expressQueue.province}
				</td>
				<td>
					${expressQueue.city}
				</td>
				<td>
					${expressQueue.area}
				</td>
				<td>
					${expressQueue.street}
				</td>
				<td>
					${expressQueue.itemName}
				</td>
				<shiro:hasPermission name="sys:expressQueue:delete"><td>
					<a href="${ctx}/sys/expressQueue/delete?id=${expressQueue.id}" onclick="return confirmx('确认要删除该待邮寄物品吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>