<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬展裁判委派管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#btnImport").click(function () {
                $.jBox($("#importBox").html(), {
                    title: "犬展裁判信息导入", buttons: {"关闭": true},
                    bottomText: "导入文件不能超过3M，仅允许导入“xls”或“xlsx”格式文件！"
                });
            });

            $("#btnExport").click(function () {
                var exportInfo = '${exportList}';
                if (exportInfo == '') {
                    alert("委派结果为空，请先导入犬展裁判信息");
                    return;
                }
                var url = "${ctx}/show/delegate/export";
                var form = $("<form></form>").attr("action", url).attr("method", "post");
                form.append($("<input></input>").attr("type", "hidden").attr("name", "json").attr("value", exportInfo));
                form.appendTo('body').submit().remove();
            });

        });

        function importShowReferee() {
            loading('正在进行排序，请稍等');
            // setTimeout(function () {
            //     $("#importForm").submit();
            // },5000);
        }

    </script>
</head>
<body>
<div id="importBox" class="hide">
    <form id="importForm" action="${ctx}/show/delegate/import" method="post" enctype="multipart/form-data"
          class="form-search" style="padding-left:20px;text-align:center;"><br/>
        <input name="file" type="file" style="width:330px"/><br/><br/>　　
        <input id="btnImportSubmit" class="btn btn-primary" type="submit" onclick="importShowReferee()" value="   导    入   "/>
        <a href="${ctx}/show/delegate/import/template">下载模板</a>
    </form>
</div>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/show/delegate/">犬展裁判委派</a></li>
</ul>
<form:form id="searchForm" method="post" class="breadcrumb form-search">
    <ul class="ul-form">
        <shiro:hasPermission name="show:delegate:delegate">
            <li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="犬展裁判信息导入"/></li>
            <li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="犬展裁判信息导出"/></li>
        </shiro:hasPermission>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>犬展编号</th>
        <th>大区</th>
        <th>省份</th>
        <th>城市</th>
        <th>犬展开始时间</th>
        <th>犬展结束时间</th>
        <th>裁判</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${showList}" var="showRefereeVo">
        <tr>
            <td>
                    ${showRefereeVo.code}
            </td>
            <td>
                    ${showRefereeVo.region}
            </td>
            <td>
                    ${showRefereeVo.province}
            </td>
            <td>
                    ${showRefereeVo.city}
            </td>
            <td>
                <fmt:formatDate value="${showRefereeVo.startDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                <fmt:formatDate value="${showRefereeVo.endDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                    ${showRefereeVo.referee}
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
</body>
</html>