<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>香港赛事成绩表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/results/showResultsHk/">香港赛事成绩表列表</a></li>
		<li class="active"><a href="${ctx}/results/showResultsHk/form?id=${showResultsHk.id}">香港赛事成绩表<shiro:hasPermission name="results:showResultsHk:edit">${not empty showResultsHk.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="results:showResultsHk:edit">查看</shiro:lacksPermission></a></li>
		<shiro:hasPermission name="results:showResultsHk:edit"><li><a href="${ctx}/results/showResultsHk/ranking">香港积分榜统计</a></li></shiro:hasPermission>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showResultsHk" action="${ctx}/results/showResultsHk/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				<form:input path="showName" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">比赛日期：</label>
			<div class="controls">
				<input name="startTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${showResultsHk.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
				<font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BOB项成绩：</label>
			<div class="controls">
				<form:input path="resultBob" htmlEscape="false" maxlength="10" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BIS项成绩：</label>
			<div class="controls">
				<form:input path="resultBis" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BIG项成绩：</label>
			<div class="controls">
				<form:input path="resultBig" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				<form:input path="dogName" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主名：</label>
			<div class="controls">
				<form:input path="dogOwnerName" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬性别：</label>
			<div class="controls">
				<form:select path="dogGender" class="input-xlarge required"  >
                    <form:option value="" label="请选择"/>
                    <form:option value="公" label="公"/>
                    <form:option value="母" label="母"/>
                </form:select>
                <font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${showResultsHk.birthdate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
				<font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁殖人：</label>
			<div class="controls">
				<form:input path="breeder" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
				 <form:select  path="fciCode" class="input-xlarge required">
                    <form:option value="" label=""/>
                    <form:options items="${dogBreedList}" itemLabel="showEnName" itemValue="dogShowCode" htmlEscape="false"/>
                </form:select>
                <font color="red">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">年龄组别：</label>
			<div class="controls">
				<form:input path="ageGroup" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="results:showResultsHk:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>