<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展裁判管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/judge/showJudge/">犬展裁判列表</a></li>
		<shiro:hasPermission name="judge:showJudge:add"><li><a href="${ctx}/judge/showJudge/form">犬展裁判添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showJudge" action="${ctx}/judge/showJudge/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>裁判中/英文名：</label>
				<form:input path="judgeName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>裁判国籍：</label>
				<form:input path="citizenship" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>裁判姓名</th>
				<th>裁判国籍</th>
				<th>裁判性别</th>
				<th>备注信息</th>
				<shiro:hasPermission name="judge:showJudge:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showJudge">
			<tr>
				<td><a href="${ctx}/judge/showJudge/form?id=${showJudge.id}">
					${showJudge.judgeName}
				</a></td>
				<td>
					${showJudge.citizenship}
				</td>
				<td>
					${fns:getDictLabel(showJudge.judgeSex, 'sex', '')}
				</td>
				<td>
					${showJudge.remarks}
				</td>
				<td>
				<shiro:hasPermission name="judge:showJudge:view">
					<a href="${ctx}/judge/showJudge/view?id=${showJudge.id}">查看</a>
					</shiro:hasPermission>
				<shiro:hasPermission name="judge:showJudge:edit">
    				<a href="${ctx}/judge/showJudge/form?id=${showJudge.id}">修改</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="judge:showJudge:delete">
					<a href="${ctx}/judge/showJudge/delete?id=${showJudge.id}" onclick="return confirmx('确认要删除该犬展裁判吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>