<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>项目管理</title>
	<meta name="decorator" content="default"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/project/ckuProject/">项目列表</a></li>
		<li class="active"><a href="${ctx}/project/ckuProject/view?id=${ckuProject.id}">项目查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="ckuProject" action="${ctx}/project/ckuProject/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">项目名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="120" class="input-xlarge" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">项目所属部门：</label>
			<div class="controls">
				<form:input path="deptName" htmlEscape="false" maxlength="120" class="input-xlarge" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">项目负责人：</label>
			<div class="controls">
				<form:input path="adminName" htmlEscape="false" maxlength="120" class="input-xlarge" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">项目简介：</label>
			<div class="controls">
				<form:textarea path="introduction" htmlEscape="false" rows="4" maxlength="500" class="input-xlarge" style="resize: none;" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">项目开始时间：</label>
			<div class="controls">
				<input name="startTime" type="text" readonly="readonly" maxlength="20" class="input-xlarge Wdate"
					value="<fmt:formatDate value="${ckuProject.startTime}" pattern="yyyy-MM-dd"/>" readonly="true"/>
				
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">项目结束时间：</label>
			<div class="controls">
				<input name="endTime" type="text" readonly="readonly" maxlength="20" class="input-xlarge Wdate"
					value="<fmt:formatDate value="${ckuProject.endTime}" pattern="yyyy-MM-dd"/>"  readonly="true"/>
				
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>