<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>训练师资格证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/handler/handlerQualificationCertificate/export/trainer");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/handler/handlerQualificationCertificate/trainer/list");
			$("#searchForm").submit();
        	return false;
        }
		
		//批量提醒
		function todo(){
				var ids="";
				$(".certificateiId").each(function(){
					var id= $(this).val();
					ids+=id+',';
				});
				if (ids!=""){
					$.ajax({
		                type:"POST",
		                url: ctx+"/handler/handlerQualificationCertificate/reminder",
		                data : {'ids':ids},
		                dataType: 'json',
		                async: false, 
		                success: function(json){
		                	$.jBox.alert("提醒成功！","提示");
		                }
					});
				}else{
					$.jBox.alert("无提醒任务！","提示");
				}
			}
        
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerQualificationCertificate/trainer/list">训练师资格证书列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="handlerQualificationCertificate" action="${ctx}/handler/handlerQualificationCertificate/trainer/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>姓名/会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>报名序号：</label>
				<form:input path="handlerRegister.registerCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="handlerRegister.showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>培训机构：</label>
				<form:input path="handlerRegister.schoolNameCn" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>成绩：</label>
				<form:select path="handlerRegister.grade" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('handler_grade')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>资格级别：</label>
				<form:select path="certificateLevelEn" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="A" label="A"/>
					<form:option value="B" label="B"/>
					<form:option value="C" label="C"/>
					<form:option value="MASTER" label="教师级"/>
				</form:select>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>处理状态：</label>
				<form:select path="proccessState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
			<shiro:hasPermission name="handler:handlerQualificationCertificate:create"><input id="btnListSubmit" class="btn btn-primary" type="button" value="批量提醒"/></shiro:hasPermission>
			<shiro:hasPermission name="handler:handlerQualificationCertificate:export"><input id="btnExport" class="btn btn-primary" type="button" value="导出"/></shiro:hasPermission>
			<%--<shiro:hasPermission name="handler:handlerQualificationCertificate:add"><a href="${ctx}/handler/handlerQualificationCertificate/addFrom"><input id="btnAdd" class="btn btn-primary" type="button" value="录入资格证书"/></a></shiro:hasPermission>
			--%></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>性别</th>
				<th>移动电话</th>
				<th>培训机构</th>
				<th>比赛犬种</th>
				<th>赛事编号</th>
				<th>级别</th>
				<th>成绩</th>
				<th>申领缴费</th>
				<th>资格证书号</th>
				<th>倒计时</th>
				<th>查看</th>
				<shiro:hasPermission name="handler:handlerQualificationCertificate:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handlerQualificationCertificate">
			<tr>
				<td style="display:none">
					<input class="certificateiId"  type="text" style="display:none" value="${handlerQualificationCertificate.id}"/>
				</td>
				<td>
					${fns:escapeHtml(handlerQualificationCertificate.handlerRegister.registerCode)}
				</td>
				<td>
					<a href="${ctx}/sys/user/member/toMemberView?memberCode=${handlerQualificationCertificate.memberCode}">
					${fns:escapeHtml(handlerQualificationCertificate.memberCode)}
					</a>
				</td>
				<td>
					${fns:escapeHtml(handlerQualificationCertificate.member.name)}
				</td>
				<td>
					${fns:getDictLabel(handlerQualificationCertificate.member.gender,'user_gender','')}
				</td>
				<td>
					${fns:escapeHtml(handlerQualificationCertificate.member.mobile)}
				</td>
				<td>
					${fns:unescapeHtml(handlerQualificationCertificate.handlerRegister.schoolNameCn)}
				</td>
				<td>
					<%--${fns:escapeHtml(handlerQualificationCertificate.handlerRegister.desktopReviewerDog)}
					${fns:escapeHtml(handlerQualificationCertificate.handlerRegister.floorReviewerDog)}--%>
					${fns:escapeHtml(handlerQualificationCertificate.handlerRegister.anyBreed)}
					<%--${fns:escapeHtml(handlerQualificationCertificate.handlerRegister.groomerBreed)}--%>
				</td>
				<td>
					${fns:escapeHtml(handlerQualificationCertificate.handlerRegister.showCode)}
				</td>
				<td>
					${fns:getDictLabel(handlerQualificationCertificate.certificateLevelEn,'handler_test_level','')}
				</td>
				<td>
					<c:choose>
						<c:when test="${handlerQualificationCertificate.handlerRegister.grade=='0' or handlerQualificationCertificate.handlerRegister.grade=='1'}">
							<font color="red">${fns:getDictLabel(handlerQualificationCertificate.handlerRegister.grade, 'handler_grade', '')}</font>
						</c:when>
						<c:otherwise>
							<font color="green">${fns:getDictLabel(handlerQualificationCertificate.handlerRegister.grade, 'handler_grade', '')}</font>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
				<shiro:hasPermission name="finance:deductCost:deductCost">
					<c:choose>
						<c:when test="${handlerQualificationCertificate.paymentState=='1' && handlerQualificationCertificate.certificateLevelEn=='B' }">
							<a onclick="util.pay('${fns:escapeHtml(handlerQualificationCertificate.id)}','handler_qualification_certificate@partnerDogB',1,'','${fns:escapeHtml(handlerQualificationCertificate.memberCode)}')">
							<font color="red">${fns:getDictLabel(handlerQualificationCertificate.paymentState,'user_payment_state','')}</font>
							</a>
						</c:when>
						<c:when test="${handlerQualificationCertificate.paymentState=='1' && handlerQualificationCertificate.certificateLevelEn=='C' }">
							<a onclick="util.pay('${fns:escapeHtml(handlerQualificationCertificate.id)}','handler_qualification_certificate@partnerDogC',1,'','${fns:escapeHtml(handlerQualificationCertificate.memberCode)}')">
							<font color="red">${fns:getDictLabel(handlerQualificationCertificate.paymentState,'user_payment_state','')}</font>
							</a>
						</c:when>
						<c:when test="${handlerQualificationCertificate.paymentState=='1' && handlerQualificationCertificate.certificateLevelEn=='A' }">
							<a onclick="util.pay('${fns:escapeHtml(handlerQualificationCertificate.id)}','handler_qualification_certificate@partnerDogA',1,'','${fns:escapeHtml(handlerQualificationCertificate.memberCode)}')">
							<font color="red">${fns:getDictLabel(handlerQualificationCertificate.paymentState,'user_payment_state','')}</font>
							</a>
						</c:when>
						<c:when test="${handlerQualificationCertificate.paymentState=='1' && handlerQualificationCertificate.certificateLevelEn=='MASTER' }">
							<a onclick="util.pay('${fns:escapeHtml(handlerQualificationCertificate.id)}','handler_qualification_certificate@partnerDogM',1,'','${fns:escapeHtml(handlerQualificationCertificate.memberCode)}')">
							<font color="red">${fns:getDictLabel(handlerQualificationCertificate.paymentState,'user_payment_state','')}</font>
							</a>
						</c:when>
						<c:otherwise>
							<font color="green">${fns:getDictLabel(handlerQualificationCertificate.paymentState,'user_payment_state','')}</font>
						</c:otherwise>
					</c:choose>
				</shiro:hasPermission>
				</td>
				<td>
					<c:if test="${empty handlerQualificationCertificate.certificateCode && handlerQualificationCertificate.paymentState=='2'}">
					<shiro:hasPermission name="handler:handlerQualificationCertificate:create">
						<a href="${ctx}/handler/handlerQualificationCertificate/createCode?id=${fns:escapeHtml(handlerQualificationCertificate.id)}">点击生成</a>
					</shiro:hasPermission>
					</c:if>
					<c:if test="${not empty handlerQualificationCertificate.certificateCode}">
						${fns:escapeHtml(handlerQualificationCertificate.certificateCode)}
					</c:if>
				</td>
				<td>
					<c:choose>
						<c:when test="${handlerQualificationCertificate.paymentState =='2' }">
							<input class="gradeTime"  type="text" style="display:none" value=""/>
						</c:when>
						<c:otherwise>
							<input class="gradeTime"  type="text" style="display:none" 
							value="<fmt:formatDate value="${handlerQualificationCertificate.handlerRegister.gradeTime}" pattern="yyyy/MM/dd HH:mm:ss"/>"/>
							<div class="colockbox" id="colockbox1" style="width: 100%;  font-family: arial; text-align: center;"> 
								<span class="day" style="color: red;">00</span>天
								<span class="hour" style="color: red;">00</span>时
								<span class="minute" style="color: red;">00</span>分 
							</div>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<a href="${ctx}/handler/handlerQualificationCertificate/view?id=${fns:escapeHtml(handlerQualificationCertificate.id)}">查看</a>
					<a href="${ctx}/handler/handlerQualificationCertificate/trainer/form?id=${fns:escapeHtml(handlerQualificationCertificate.id)}">编辑</a>
				</td>
				<td>
					<c:choose>
						<c:when test="${not empty handlerQualificationCertificate.certificateCode && handlerQualificationCertificate.paymentState=='2' && handlerQualificationCertificate.printState=='0'}">
						<shiro:hasPermission name="handler:handlerQualificationCertificate:print">
							<a href="${ctx}/handler/handlerQualificationCertificate/trainer/partnerPrint?id=${fns:escapeHtml(handlerQualificationCertificate.id)}">打印</a>
						</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerQualificationCertificate.paymentState=='2' && handlerQualificationCertificate.printState=='1'}">
						<shiro:hasPermission name="handler:handlerQualificationCertificate:resetPrint">
							<a href="${ctx}/handler/handlerQualificationCertificate/resetPrint?id=${fns:escapeHtml(handlerQualificationCertificate.id)}">重置打印</a>
						</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerQualificationCertificate.paymentState=='1'}">
						<shiro:hasPermission name="handler:handlerQualificationCertificate:edit">
		    				<a href="${ctx}/handler/handlerQualificationCertificate/reminderOne?id=${fns:escapeHtml(handlerQualificationCertificate.id)}" >提醒领取资格证书</a>
		    			</shiro:hasPermission>
						</c:when>
					</c:choose>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<script type="text/javascript">
		//倒计时
		$(function(){
			$(".gradeTime").each(function(){
				var gradeTime= $(this).val();
				countDown(gradeTime,$(this).next());
			});
			
			
		});
		function countDown(time,timeArea){
			var end_time=new Date(time).getTime() + 61 * 24 * 60 * 60 * 1000;
			var day_elem = timeArea.find('.day');
			var hour_elem = timeArea.find('.hour');
			var minute_elem = timeArea.find('.minute');
			//var end_time = new Date(time).getTime(),//月份是实际月份-1
			var sys_second = (end_time-new Date().getTime())/1000;
			var timer = setInterval(function(){
				if (sys_second > 1) {
					sys_second -= 1;
					var day = Math.floor((sys_second / 3600) / 24);
					var hour = Math.floor((sys_second / 3600) % 24);
					var minute = Math.floor((sys_second / 60) % 60);
					day_elem && $(day_elem).text(day);//计算天
					$(hour_elem).text(hour<10?"0"+hour:hour);//计算小时
					$(minute_elem).text(minute<10?"0"+minute:minute);//计算分钟
				} else { 
					clearInterval(timer);
				}
			}, 1000);
		}
	</script>
</body>
</html>