<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>国际宠物美容师管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		top.$.jBox.tip.mess =  null;
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"证书导入", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
			
			$("#btnTemplate").click(function(){
				window.location ='${ctx}/groomer/internationalGroomerCertificate/downloadImportXls';
			});
			<c:if test="${not empty message}">
			$("#messageBox").show();
			</c:if>
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
			return false;
		}
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="${ctx}/groomer/internationalGroomerCertificate/">国际宠物美容师列表</a></li>
<%--<shiro:hasPermission name="groomer:internationalGroomerCertificate:edit"><li><a href="${ctx}/groomer/internationalGroomerCertificate/form">国际宠物美容师添加</a></li></shiro:hasPermission>--%>
</ul>

<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/groomer/internationalGroomerCertificate/uploadXls" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
<form:form id="searchForm" modelAttribute="internationalGroomerCertificate" action="${ctx}/groomer/internationalGroomerCertificate/" method="post" class="breadcrumb form-search">
	<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
	<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
	<ul class="ul-form">
		<li><label>会员号/姓名：</label>
			<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
		</li>
		<li><label>证书号：</label>
			<form:input path="certificateCode" htmlEscape="false" maxlength="64" class="input-medium"/>
		</li>
		<li><label>证书类型：</label>
			<form:select path="certificateType" class="input-medium">
				<form:option value="" label="全部"/>
				<form:options items="${fns:getDictList('groomer_certificate_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
		</li>
		<li><label>付款状态：</label>
			<form:select path="paymentState" class="input-medium">
				<form:option value="" label="全部"/>
				<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
		</li>
	</ul>
	<ul class="ul-form">
		<li><label>审核状态：</label>
			<form:select path="reviewState" class="input-medium">
				<form:option value="" label="全部"/>
				<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
		</li>
		<li><label>打印状态：</label>
			<form:select path="printState" class="input-medium">
				<form:option value="" label="全部"/>
				<form:options items="${fns:getDictList('print_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
		</li>
		<li><label>申请时间：</label>
			<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				   value="<fmt:formatDate value="${internationalGroomerCertificate.beginCreateDate}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
			<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				   value="<fmt:formatDate value="${internationalGroomerCertificate.endCreateDate}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
		</li>
		<li class="btns">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
			<%-- <shiro:hasPermission name="groomer:certificate:import"> --%>
			<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>
			<input id="btnTemplate" class="btn btn-primary" type="button" value="下载模板"/>
			<%-- </shiro:hasPermission> --%>
		</li>
		<li class="clearfix"></li>
	</ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th>证书编号</th>
		<th>证书类型</th>
		<th>会员号</th>
		<th>中文名</th>
		<th>缴费状态</th>
		<th>审核状态</th>
		<th>签发日期</th>
		<th>有效期</th>
		<th>打印</th>
		<th>操作</th>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${page.list}" var="internationalGroomerCertificate">
		<tr>
			<td>
					${internationalGroomerCertificate.certificateCode}
			</td>
			<td>
					${fns:getDictLabel(internationalGroomerCertificate.certificateType, 'groomer_certificate_type', '')}
			</td>
			<td>
				<a href="${ctx}/sys/user/member/form?id=${internationalGroomerCertificate.member.id}">
					${internationalGroomerCertificate.memberCode}
				</a>
			</td>
			<td>
					${internationalGroomerCertificate.cnName}
			</td>
			<td>
				${fns:getDictLabel(internationalGroomerCertificate.paymentState, 'user_payment_state', '')}
			</td>
			<td>
					${fns:getDictLabel(internationalGroomerCertificate.reviewState, 'review_state', '')}
			</td>
			<td>
				<fmt:formatDate value="${internationalGroomerCertificate.issueDate}" pattern="yyyy-MM-dd "/>
			</td>
			<td>
				<fmt:formatDate value="${internationalGroomerCertificate.endDate}" pattern="yyyy-MM-dd "/>
			</td>
			<td>
				<shiro:hasPermission name="groomer:internationalGroomerCertificate:print">
					<c:if test="${internationalGroomerCertificate.paymentState=='2'&&internationalGroomerCertificate.reviewState=='1' && internationalGroomerCertificate.printState == '0'}">
							<a href="${ctx}/groomer/internationalGroomerCertificate/print?id=${internationalGroomerCertificate.id}">
									打印证书</a>
					</c:if>
					<c:if test="${internationalGroomerCertificate.printState=='1'}">
						<a href="${ctx}/groomer/internationalGroomerCertificate/restPrint?id=${internationalGroomerCertificate.id}">
							重置打印</a>
					</c:if>
				</shiro:hasPermission>
			</td>
			<td>
				<a href="${ctx}/groomer/internationalGroomerCertificate/form?id=${internationalGroomerCertificate.id}">查看</a>
			</td>
			<%--<shiro:hasPermission name="groomer:internationalGroomerCertificate:edit"><td>--%>
				<%--<a href="${ctx}/groomer/internationalGroomerCertificate/form?id=${internationalGroomerCertificate.id}">修改</a>--%>
				<%--<a href="${ctx}/groomer/internationalGroomerCertificate/delete?id=${internationalGroomerCertificate.id}" onclick="return confirmx('确认要删除该国际美容师管理吗？', this.href)">删除</a>--%>
			<%--</td></shiro:hasPermission>--%>
		</tr>
	</c:forEach>
	</tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>