<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单项目管理</title>
	<meta name="decorator" content="default"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/paymentOrder/">订单列表</a></li>
		<shiro:hasPermission name="finance:paymentOrderProject:view"><li><a href="${ctx}/finance/paymentOrderProject/">项目活动</a></li></shiro:hasPermission>
		<shiro:hasPermission name="finance:paymentOrderProject:view"><li class="active"><a href="${ctx}/finance/paymentOrderProject/">项目活动统计</a></li></shiro:hasPermission>

	</ul>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>标识ID</th>
				<th>收费项目</th>
				<th>数量</th>
				<th>总价</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="paymentOrderDetail">
			<tr>
				<td>
					${fns:escapeHtml(paymentOrderDetail.projectName)}
				</td>
				<td>
					${fns:escapeHtml(paymentOrderDetail.chargingItemName)}
				</td>
				<td name="chargingItemCount">
					${fns:escapeHtml(paymentOrderDetail.chargingItemCount)}
				</td>
				<td name="chargingItemPrice">
					${fns:escapeHtml(paymentOrderDetail.chargingItemPrice)}
				</td>
			</tr>
		</c:forEach>
		<tr>
			<td colspan="2" style="text-align: center;">
				合计
			</td>
			<td id="count">

			</td>
			<td id="price">

			</td>
		</tr>
		</tbody>
	</table>
	<script>
		$(function(){
			var chargingItemCountList = $("td[name='chargingItemCount']");
			var chargingItemPriceList = $("td[name='chargingItemPrice']");
			var count = 0;
			var price=0;
			for(var i=0;i<chargingItemCountList.length;i++){
				count +=parseInt(chargingItemCountList[i].innerText);
				price+=parseFloat(chargingItemPriceList[i].innerText,2);
			}
			$("#count").html(count);
			$("#price").html(price.toFixed(2));
		})
	</script>
</body>
</html>