<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
        $(document).ready(function() {

        });
        function page(n,s){
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
        function createWxCode(orderId){
            parent.layer.open({
                type: 1,
                title: ['微信支付二维码', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['500px', '500px'],
                content: '<img src="/oa-web/api/v1/open/wxpay/pay/'+orderId+'" id="wxcode" height="450" width="490" alt="">'
//				content: '<img src="/oa-web/api/v1/open/allinpay/pay/'+orderId+'?paymentWay=24" id="paycode" height="450" width="490" alt="">'
            });
        }
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="${ctx}/finance/paymentOrder/">订单列表</a></li>
	<shiro:hasPermission name="finance:paymentOrderProject:view"><li><a href="${ctx}/finance/paymentOrderProject/">项目活动</a></li></shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="paymentOrder" action="${ctx}/finance/paymentOrder/" method="post" class="breadcrumb form-search">
	<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
	<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
	<ul class="ul-form">
		<li><label>订单编号：</label>
			<form:input path="orderCode" htmlEscape="false" maxlength="100" class="input-medium"/>
		</li>
		<li><label>会员号：</label>
			<form:input path="memberCode" htmlEscape="false" maxlength="50" class="input-medium"/>
		</li>
		<li><label>	订单金额：</label>
			<form:input path="totalPrice" htmlEscape="false" class="input-medium"/>
		</li>
		<li><label>	项目名称：</label>
			<form:input path="projectName" htmlEscape="false" class="input-medium"/>
		</li>
		<li><label>添加时间：</label>
			<input name="beginAddTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				   value="<fmt:formatDate value="${paymentOrder.beginAddTime}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
			<input name="endAddTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				   value="<fmt:formatDate value="${paymentOrder.endAddTime}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
		</li>
		<li><label>	删除状态：</label>
			<form:select path="delFlagsss" class="input-small">
				<form:option value="">全部</form:option>
				<form:option value="1" label="作废"/>
				<form:option value="0" label="有效"/>
			</form:select>
		</li>
		<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
		<li class="clearfix"></li>
	</ul>
</form:form>
<sys:message content="${message}"/>
<div class="alert" role="alert" style="text-align: right;">订单总计：${fns:escapeHtml(orderCount)}元</div>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th>订单编号</th>
		<th>会员编号</th>
		<th>订单金额</th>
		<th>申请时间</th>
		<th>项目名称</th>
		<th>支付方式</th>
		<th>凭证号</th>
		<th>删除状态</th>
		<th>订单状态</th>
		<th>创建人</th>
		<th>退款状态</th>
		<th>订单备注</th>
		<shiro:hasPermission name="finance:paymentOrderProject:view">
			<th>操作</th>
		</shiro:hasPermission>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${page.list}" var="paymentOrder">
		<tr>
			<td>
					${fns:escapeHtml(paymentOrder.orderCode)}
			</td>
			<td>
					${fns:escapeHtml(paymentOrder.memberCode)}
			</td>
			<td>
					${fns:escapeHtml(paymentOrder.totalPrice)}
			</td>
			<td>
				<fmt:formatDate value="${paymentOrder.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</td>
			<td>
					${fns:escapeHtml(paymentOrder.projectName)}
			</td>
			<td>
					${fns:getDictLabel(paymentOrder.paymentWay,'payment_way' ,'' )}
			</td>
			<td>
					${paymentOrder.voucherCode}
			</td>
			<td>
				<c:if test="${paymentOrder.delFlag==0}">有效</c:if>
				<c:if test="${paymentOrder.delFlag==1}">作废</c:if>
			</td>
			<td>
					${fns:getDictLabel(paymentOrder.paymentState,'user_payment_state' ,'' )}
			</td>
			<td>
				${not empty paymentOrder.createBy ? paymentOrder.createBy.name : ''}
			</td>
			<td>
				<c:if test="${paymentOrder.businessRefundState==1}">退款审核中</c:if>
				<c:if test="${paymentOrder.businessRefundState==2}">未通过</c:if>
				<c:if test="${paymentOrder.businessRefundState==3}">通过</c:if>
			</td>
			<td>
					${fns:escapeHtml(paymentOrder.remarks)}
			</td>
			<shiro:hasPermission name="finance:paymentOrderProject:view">
				<td>
					<c:if test="${paymentOrder.paymentWay =='28' and paymentOrder.paymentState=='1'}">
						<a href="javascript:;" onclick="createWxCode('${fns:escapeHtml(paymentOrder.id)}')">生成二维码</a>
					</c:if>
					<a href="${ctx}/finance/paymentOrder/form?id=${paymentOrder.id}">详情</a>
				</td>
			</shiro:hasPermission>
		</tr>
	</c:forEach>
	</tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>