<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬运动犬只管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//导入
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"会员导入", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});

			//显示导入错误提示
			var errorMsg = "${errorMsg}";
			var reg = new RegExp("##", "g")
			if (errorMsg != null && errorMsg != '' && typeof errorMsg != 'undefined') {
				alert(errorMsg.replace(reg, "\n"));
			}

			//导出
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出犬只信息吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/dogsporting/dog/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
<div id="importBox" class="hide">
	<form id="importForm" action="${ctx}/dogsporting/dog/import" method="post" enctype="multipart/form-data"
		  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
		<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
		<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		<a href="${ctx}/dogsporting/dog/import/template">下载模板</a>
	</form>
</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogsporting/dog/">犬运动犬只列表</a></li>
		<shiro:hasPermission name="dogsporting:dog:edit"><li><a href="${ctx}/dogsporting/dog/editForm">犬运动犬只添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogSportingDogs" action="${ctx}/dogsporting/dog/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬名：</label>
				<form:input path="dogName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬主会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>犬只品种：</label>
				<form:select path="dogType" class="input-xlarge required">
					<form:option value="" label="全部"/>
					<form:options items="${dogTypeList}" itemLabel="breedCnName" itemValue="dogBreedCode" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>证书编号：</label>
				<form:input path="certificateCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>犬只体型：</label>
				<form:select path="somatotype" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_somatotype')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="dogsporting:dog:import">
				<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入犬只信息"/></li>
			</shiro:hasPermission>
			<shiro:hasPermission name="dogsporting:dog:export">
				<li class="btns"><button id="btnExport" type="button" class="btn btn-primary" >导出犬只信息</button></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>证书号</th>
				<th>犬名</th>
				<th>犬主人</th>
				<th>芯片号</th>
				<th>犬只性别</th>
				<th>犬只品种</th>
				<th>出生日期</th>
				<th>毛色</th>
				<th>犬只体型</th>
				<shiro:hasPermission name="dogsporting:dog:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogSportingDogs">
			<tr>
				<td>
						${dogSportingDogs.certificateCode}
				</td>
				<td>
						${dogSportingDogs.dogName}
				</td>
				<td>
					${dogSportingDogs.memberName}
				</td>
				<td>
						${dogSportingDogs.identificationFlag}
				</td>
				<td>
					${fns:getDictLabel(dogSportingDogs.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${dogSportingDogs.dogTypeCn}
				</td>
				<td>
					<fmt:formatDate value="${dogSportingDogs.birthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
						${dogSportingDogs.colorFlag}
				</td>
				<td>
					${fns:getDictLabel(dogSportingDogs.somatotype, 'dog_somatotype', '')}
				</td>


				<td>
					<shiro:hasPermission name="dogsporting:dog:view">
						<a href="${ctx}/dogsporting/dog/viewForm?id=${dogSportingDogs.id}">查看</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="dogsporting:dog:edit">
						<a href="${ctx}/dogsporting/dog/editForm?id=${dogSportingDogs.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="dogsporting:dog:print">
						<c:if test="${dogSportingDogs.printState=='0'}">
							<a href="${ctx}/dogsporting/dog/print?id=${dogSportingDogs.id}">打印</a>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="dogsporting:dog:resetPrint">
						<c:if test="${dogSportingDogs.printState=='1'}">
							<a href="${ctx}/dogsporting/dog/resetPrint?id=${dogSportingDogs.id}">重置打印</a>
						</c:if>
					</shiro:hasPermission>
				</td>

			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>