<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>双亲对比父母犬审核</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-horizontal .control-label {
		    width: 150px!important;
		}
		
		.form-horizontal .controls {
		    margin-left: 100px;
		    padding-top: 3px;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/dogdnaparentscompare/dogDnaParentsCompare/auditFMdog',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("审核成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("审核失败,错误信息："+data.msg);
 						}
 				    });
					closeLoading();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogDnaParentsCompareAudit" class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>   

    <div class="control-group">
    </div>
	<div class="control-group"  style="width:100%">
		<label class="control-label">出生证明编号：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.birthCode}
		</div>
	</div>
	
	<div class="control-group" >
		<label class="control-label">父血统证书号：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.fdogPedigreeCertified}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">父犬主会员号：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.fdogMemberCode}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">父犬主会员：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.fdogMemberName}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">父犬主审核人：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.fdogReviewUserName}
		</div>
	</div>
	<div class="control-group" style="width:100%">
		<label class="control-label">父犬主审核时间：</label>
		<div class="controls">
				<fmt:formatDate value="${dogDnaParentsCompareAudit.fdogReviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
		</div>
	</div>
	
	<div class="control-group" style="width:100%">
		<label class="control-label">父犬主审核状态：</label>
		<div class="controls">
					<c:choose>
					  <c:when test="${dogDnaParentsCompareAudit.fdogReviewState !='1'}">
	                    <form:select id="fdogReviewState" path="fdogReviewState" class="input-small" >
							<form:options items="${fns:getDictList('dog_dna_parents_compare_audit_review_state')}" itemLabel="label" 
								itemValue="value" htmlEscape="false" />
						</form:select>
	                   </c:when>
	                   <c:otherwise>
	                     	${fns:getDictLabel(dogDnaParentsCompareAudit.fdogReviewState, 'dog_dna_parents_compare_audit_review_state', '')}
	                		<form:hidden path="fdogReviewState"/>
	                   </c:otherwise>
	                </c:choose>		
		</div>
	</div>
	<div class="control-group" style="width:100%">
		<label class="control-label">父犬主审核意见：</label>
		<div class="controls">
			<form:textarea path="fdogReviewRemarks" rows="3" cols="20" class="input-xlarge" maxlength="100"  
					readonly="${dogDnaParentsCompareAudit.fdogReviewState =='1'?true:false}"/>
		</div>
	</div>
	 <div class="control-group" >
		<label class="control-label">母血统证书号：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.mdogPedigreeCertified}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">母犬主会员号：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.mdogMemberCode}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">母犬主会员：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.mdogMemberName}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">母犬主审核人：</label>
		<div class="controls">
				${dogDnaParentsCompareAudit.mdogReviewUserName}
		</div>
	</div>
	<div class="control-group" style="width:100%">
		<label class="control-label">母犬主审核时间：</label>
		<div class="controls">
				<fmt:formatDate value="${dogDnaParentsCompareAudit.mdogReviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
		</div>
	</div>
	
	<div class="control-group" style="width:100%">
		<label class="control-label">母犬主审核状态：</label>
		<div class="controls">
					<c:choose>
					  <c:when test="${dogDnaParentsCompareAudit.mdogReviewState !='1'}">
	                   <form:select id="mdogReviewState" path="mdogReviewState" class="input-small">
							<form:options items="${fns:getDictList('dog_dna_parents_compare_audit_review_state')}" itemLabel="label" 
								itemValue="value" htmlEscape="false"/>
						</form:select>
	                   </c:when>
	                   <c:otherwise>
	                     	${fns:getDictLabel(dogDnaParentsCompareAudit.mdogReviewState, 'dog_dna_parents_compare_audit_review_state', '')}
	                  		<form:hidden path="mdogReviewState"/>
	                   </c:otherwise>
	                </c:choose>		
		</div>
	</div>
	<div class="control-group" style="width:100%">
		<label class="control-label">母犬主审核意见：</label>
		<div class="controls">
			<form:textarea path="mdogReviewRemarks" rows="3" cols="20" class="input-xlarge"  maxlength="100"  
					readonly="${dogDnaParentsCompareAudit.mdogReviewState =='1'?true:false}"/>
		</div>
	</div>
	

	<div class="control-group" style="text-align: center;width:100%">
	 	<c:if test="${dogDnaParentsCompareAudit.mdogReviewState !='1' || dogDnaParentsCompareAudit.fdogReviewState !='1'}">
	 		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
	 	</c:if>
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>