<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只激活管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/dogactivation/dogActivation/">犬只激活列表</a></li>
    <shiro:hasPermission name="dog:dogActivation:edit">
        <li><a href="${ctx}/dogactivation/dogActivation/form">犬只激活添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="dogActivation" action="${ctx}/dogactivation/dogActivation/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>出生纸编号：</label>
            <form:input path="birthCode" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>上架状态：0未上架；1已上架：</label>
            <form:input path="state" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li><label>审核状态：未审核0；通过1；未通过2：</label>
            <form:input path="reviewState" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li><label>付款的状态：未支付1；已支付2：</label>
            <form:input path="paymentState" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>出生纸编号</th>
        <th>报价</th>
        <th>犬只所在城市</th>
        <th>电话</th>
        <th>联系人</th>
        <th>上架状态：0未上架；1已上架</th>
        <th>审核状态：未审核0；通过1；未通过2</th>
        <th>审核时间</th>
        <th>审核的意见</th>
        <th>流水号</th>
        <th>付款的状态：未支付1；已支付2</th>
        <th>付款时间</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="dog:dogActivation:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogActivation">
        <tr>
            <td><a href="${ctx}/dogactivation/dogActivation/form?id=${dogActivation.id}">
                    ${dogActivation.birthCode}
            </a></td>
            <td>
                    ${dogActivation.price}
            </td>
            <td>
                    ${dogActivation.city}
            </td>
            <td>
                    ${dogActivation.mobile}
            </td>
            <td>
                    ${dogActivation.linkman}
            </td>
            <td>
                    ${dogActivation.state}
            </td>
            <td>
                    ${dogActivation.reviewState}
            </td>
            <td>
                <fmt:formatDate value="${dogActivation.reviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${dogActivation.reviewRemarks}
            </td>
            <td>
                    ${dogActivation.runningNumber}
            </td>
            <td>
                    ${dogActivation.paymentState}
            </td>
            <td>
                <fmt:formatDate value="${dogActivation.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${dogActivation.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${dogActivation.remarks}
            </td>
            <shiro:hasPermission name="dog:dogActivation:edit">
                <td>
                    <a href="${ctx}/dogactivation/dogActivation/form?id=${dogActivation.id}">修改</a>
                    <a href="${ctx}/dogactivation/dogActivation/delete?id=${dogActivation.id}"
                       onclick="return confirmx('确认要删除该犬只激活吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>