package com.thinkgem.jeesite.modules.sys.security;

import java.util.Arrays;

import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5CredentialMatcher extends HashedCredentialsMatcher{
	private static final Logger log = LoggerFactory.getLogger(MD5CredentialMatcher.class);
	
    public MD5CredentialMatcher(String hashAlgorithm) {
		super(hashAlgorithm);
	}

	@Override
    protected boolean equals(Object tokenCredentials, Object accountCredentials) {
        if (log.isDebugEnabled()) {
            log.debug("Performing credentials equality check for tokenCredentials of type [" +
                    tokenCredentials.getClass().getName() + " and accountCredentials of type [" +
                    accountCredentials.getClass().getName() + "]");
        }
        if (isByteSource(tokenCredentials) && isByteSource(accountCredentials)) {
            if (log.isDebugEnabled()) {
                log.debug("Both credentials arguments can be easily converted to byte arrays.  Performing " +
                        "array equals comparison");
            }
            byte[] tokenBytes = toBytes(tokenCredentials);
            byte[] accountBytes = toBytes(accountCredentials);
            return Arrays.equals(Arrays.copyOfRange(tokenBytes, 4, 12), accountBytes);
        } else {
            return accountCredentials.equals(tokenCredentials);
        }
    }
}
