/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v2.kennel.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.kennel.service.RestStarKennelService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 犬只信息管理Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/cku/v2/starKennel")
public class CkuStarKennelControllerV2 extends BaseRestController {

	@Autowired
	private RestStarKennelService restStarKennelService;

	/**
	 *
	 * @description: 星级犬舍联盟申请条件校验的接口
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午4:11:11
	 */
	@RequestMapping(value = "/applyCheck", method = RequestMethod.GET)
	@ResponseBody
	public void applyCheck(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restStarKennelService.applyCheck(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 星级犬舍联盟根据城市和关键字查询俱乐部信息的接口
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午4:11:11
	 */
	@RequestMapping(value = "/getClubByCityAndKey", method = RequestMethod.GET)
	@ResponseBody
	public void getClubByCityAndKey(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restStarKennelService.getClubByCityAndKey(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 星级犬舍联盟根据会员号查询犬舍信息的接口
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午4:11:11
	 */
	@RequestMapping(value = "/getKennelByMemberCode", method = RequestMethod.GET)
	@ResponseBody
	public void getKennelByMemberCode(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restStarKennelService.getKennelByMemberCode(request);
		ServletUtils.writeResponse(response, result);
	}

}