package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.RESTResponse;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.groomer.dao.GroomerRegisterDao;
import com.cku.oa.show.service.ChildShowsService;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.sys.coupon.dao.SysCouponDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.finance.entity.RestPaymentOrderDetail;
import com.cku.restful.v1.sys.model.RestRefundAble;
import com.cku.restful.v1.sys.service.RefundService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.netty.util.internal.StringUtil;
import net.sf.json.JSONObject;

/**
 * Created by lyyz on 2019/8/21. 退费业务
 */
@Controller
@RequestMapping(value = "/api/v1/open/refund")
public class RefundController extends BaseRestController {
	@Autowired
	ShowApplyService showApplyService;
	@Autowired
	ChildShowsService childShowsService;
	@Autowired
	GroomerRegisterDao groomerRegisterDao;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private RefundService refundService;
	@Autowired
	private SysCouponDao sysCouponDao;

	@RequestMapping(value = "refundDict", method = RequestMethod.GET)
	public void refundDict(HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, new RESTResponse("data", DictUtils.getDictList("business_refund_reason")));
	}

	/**
	 * 根据订单号 业务号查找申请退款 业务数据
	 *
	 * @param paymentOrderDetail
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "refundApply", method = RequestMethod.POST)
	public void refundApply(@RequestBody RestPaymentOrderDetail paymentOrderDetail, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = refundApplyParameterVerification(paymentOrderDetail, 0);
		if (result != null) {
			ServletUtils.writeResponse(response, result);
			return;
		}

		Member member = UserUtils.getLoginMember();

		// 俱乐部不需要查会员号,根据创建人查询
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setMemberCode(member.getMemberCode());
		detail.setOrderCode(paymentOrderDetail.getOrderCode());
		detail.setBusinessId(paymentOrderDetail.getBusinessId());
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findAllList(detail);
		Map<String, List<PaymentOrderDetail>> collect = orderDetailList.stream()
				.filter(i -> org.apache.commons.lang3.StringUtils.isNotEmpty(i.getBusinessId())
						&& org.apache.commons.lang3.StringUtils.isNotEmpty(i.getBusinessOrderCode()))
				.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessOrderCode));
		result = refundService.getBusinessList(detail.getBusinessId(), collect);
		// StringBuffer sb = new StringBuffer();
		// StringBuffer sbTable = new StringBuffer();
		// collect.entrySet().forEach(i -> {
		// sb.append("'" + i.getKey() + "'").append(",");
		// if (StringUtil.isNullOrEmpty(String.valueOf(sbTable)))
		// sbTable.append(i.getValue().get(0).getBusinessTable());
		// });
		// if (sb.length() > 0) sb.deleteCharAt(sb.length() - 1);
		// if (StringUtil.isNullOrEmpty(String.valueOf(sb))) {
		// ServletUtils.writeResponse(response, new RESTResponse(-1, "没有符合条件的数据"));
		// return;
		// }
		// result = refundService.getBusinessList(String.valueOf(sb),
		// String.valueOf(sbTable));
		result.getData().getJSONArray("data").stream().forEach(i -> {
			StringBuffer rs = new StringBuffer();
			StringBuffer r = new StringBuffer();
			StringBuffer rr = new StringBuffer();
			orderDetailList.stream().filter(p -> StringUtils.isNotEmpty(p.getBusinessIds())
					&& p.getBusinessIds().contains(String.valueOf(((JSONObject) i).get("id")))).forEach(o -> {
						if (StringUtil.isNullOrEmpty(String.valueOf(rs))) {
							rs.append(o.getBusinessRefundState());
							r.append(o.getBusinessRefundReason());
							rr.append(refundService.getRefundable(o.getBusinessId(), o.getBusinessIds(),
									o.getBusinessRefundState(), o.getOrderCode()).getFlag());
						}
					});
			((JSONObject) i).put("businessRefundState", String.valueOf(rs));
			((JSONObject) i).put("businessRefundReason", String.valueOf(r));
			((JSONObject) i).put("refundable", Boolean.valueOf(rr.toString()));
		});
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据 订单号 业务序号和业务数据序号更改业务数据申请状态
	 *
	 * @param paymentOrderDetail
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "refundApplyOperation", method = RequestMethod.POST)
	public void refundApplyOperation(@RequestBody RestPaymentOrderDetail paymentOrderDetail, HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		RESTResponse result = refundApplyParameterVerification(paymentOrderDetail, 1);
		if (result != null) {
			ServletUtils.writeResponse(response, result);
			return;
		}

		Member member = UserUtils.getLoginMember();

		// 俱乐部不需要查会员号,根据创建人查询
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setMemberCode(member.getMemberCode());
		detail.setOrderCode(paymentOrderDetail.getOrderCode());
		detail.setBusinessId(paymentOrderDetail.getBusinessId());
		detail.setBusinessIds(paymentOrderDetail.getBusinessIds());

		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findAllList(detail);
		if (orderDetailList.size() > 0) {
			PaymentOrderDetail orderDetail = orderDetailList.get(0);
			// 上线前改为最终上线日期,上线之后一天产生的订单可以申请退款
			Date onLineDate = new Date(2020 - 1900, 2 - 1, 18 + 1, 0, 0);
			// 验证业务状态 和是否为新订单（写死的日期）
			if (!orderDetail.getCreateDate().after(onLineDate)) {
				ServletUtils.writeResponse(response, new RESTResponse(-1, "此订单为旧订单，不允许系统退款！"));
				return;
			}
		}

//		// 赛事业务特殊处理，暂时关闭退费功能
//		if ("1027".equals(paymentOrderDetail.getBusinessId()) || "1030".equals(paymentOrderDetail.getBusinessId())
//				|| "1033".equals(paymentOrderDetail.getBusinessId()) || "1036".equals(paymentOrderDetail.getBusinessId())
//				|| "1039".equals(paymentOrderDetail.getBusinessId()) || "1042".equals(paymentOrderDetail.getBusinessId())
//				|| "1070".equals(paymentOrderDetail.getBusinessId()) || "1073".equals(paymentOrderDetail.getBusinessId())) {
//			ServletUtils.writeResponse(response, new RESTResponse(-1, "比赛退费功能关闭。"));
//			return;
//		}

		// 国外血统证书换发，需特殊处理
		if ("1004".equals(paymentOrderDetail.getBusinessId()) && !CollectionUtils.isEmpty(orderDetailList)) {
			PaymentOrderDetail newDetail = new PaymentOrderDetail();
			newDetail.setMemberCode(member.getMemberCode());
			newDetail.setOrderCode(paymentOrderDetail.getOrderCode());
			newDetail.setBusinessId(paymentOrderDetail.getBusinessId());
			newDetail.setBusinessOrderCode(orderDetailList.get(0).getBusinessOrderCode());
			orderDetailList = paymentOrderDetailDao.findAllList(newDetail);
		}
		
		// 金质证书，需特殊处理
		if ("1204".equals(paymentOrderDetail.getBusinessId()) && !CollectionUtils.isEmpty(orderDetailList)) {
			PaymentOrderDetail newDetail = new PaymentOrderDetail();
			newDetail.setMemberCode(member.getMemberCode());
			newDetail.setOrderCode(paymentOrderDetail.getOrderCode());
			newDetail.setBusinessId(paymentOrderDetail.getBusinessId());
			newDetail.setBusinessOrderCode(orderDetailList.get(0).getBusinessOrderCode());
			orderDetailList = paymentOrderDetailDao.findAllList(newDetail);
		}

		// 如果使用了需要均摊的优惠券，就不能退款
		List<SysCoupon> coupons = sysCouponDao.getCouponXNList(paymentOrderDetail.getOrderCode());
		if (coupons.size() > 0) {
			ServletUtils.writeResponse(response, new RESTResponse(-1, "该订单如需退款，请致电客服：400-6607000申请退款。"));
			return;
		}

		if (orderDetailList.stream().filter(i -> !StringUtil.isNullOrEmpty(i.getBusinessRefundState())).count() > 0) {
			ServletUtils.writeResponse(response, new RESTResponse(-1, "该业务单已申请退款"));
			return;
		}
		for (PaymentOrderDetail pod : orderDetailList) {
			pod.setBusinessRefundState("1");
			pod.setBusinessRefundTime(new Timestamp(System.currentTimeMillis()));
			pod.setBusinessRefundReason(paymentOrderDetail.getBusinessRefundReason());
			paymentOrderDetailDao.update(pod);
		}
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 * @param paymentOrderDetail
	 * @return
	 */
	public RESTResponse refundApplyParameterVerification(RestPaymentOrderDetail paymentOrderDetail, int i) {
		if (paymentOrderDetail == null)
			return new RESTResponse(-1, "参数为空");

		if (StringUtil.isNullOrEmpty(paymentOrderDetail.getOrderCode()))
			return new RESTResponse(-1, "订单号不能为空");

		if (StringUtil.isNullOrEmpty(paymentOrderDetail.getBusinessId()))
			return new RESTResponse(-1, "业务序号不能为空");

		if (i == 1) {
			PaymentOrder paymentOrder = paymentOrderDao.getByorderCode(paymentOrderDetail.getOrderCode());
			if (!"2".equals(paymentOrder.getPaymentState())) {
				return new RESTResponse(-1, "未付款的订单不能申请退款");
			}

			RestRefundAble refundAble = refundService.getRefundable(paymentOrderDetail.getBusinessId(),
					paymentOrderDetail.getBusinessIds(), null, paymentOrderDetail.getOrderCode());
			if (!refundAble.getFlag()) {
				return new RESTResponse(-1, refundAble.getMsg());
			}

			if (StringUtil.isNullOrEmpty(paymentOrderDetail.getBusinessIds()))
				return new RESTResponse(-1, "业务数据序号不能为空");

			if (StringUtil.isNullOrEmpty(paymentOrderDetail.getBusinessRefundReason()))
				return new RESTResponse(-1, "退款原因不能为空");
		}
		return null;
	}
}
