package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.finance.service.PaymentPayLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alipay.config.AlipayConfig;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.restful.v1.show.service.RestShowApplyService;
import com.cku.restful.v1.sys.utils.PayUtil;
import com.cku.util.ServletUtils;

/**
 *
 * <p>Title:CabAliPayController </p>
 * <p>Description: 宠爱王国App支付宝支付</p>
 * <p>Company: </p>
 * @author zhuoHeng
 * @date 2017年2月8日 上午9:55:15
 */
@Controller
@RequestMapping(value = "/api/v1/open/cabAliPay")
public class MobileAliPayController extends BaseRestController {

	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private RestShowApplyService restShowApplyService;
	@Autowired
	private ShopOrderService shopOrderService;
	@Autowired
	private PaymentPayLogService paymentPayLogService;

	/**
	 *
	 * @Description：发起支付宝支付所需参数生成方法
	 * @author: zhuoHeng
	 * @version: 2017年2月9日 下午5:57:38
	 */
	@RequestMapping(value="/pay" , method = RequestMethod.GET)
	@ResponseBody
	public void getOrderInfoByAliPay(HttpServletRequest request,HttpServletResponse response) throws IOException {
		String title = "";//订单描述
		String totalPrice = "";//订单金额
		String path = request.getContextPath();
		String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path;
		String orderId = request.getParameter("orderId");
		//TODO 回调地址修改
//		"http://43.227.252.141:8182/oa-web/api/v1/open/alipay/notifyUrl";
	    String ali_call_back_url = basePath+AlipayConfig.notify_url;//回调页面
	    String seller_id = AlipayConfig.seller_id;//商户编号
	    PaymentOrder order = paymentOrderService.get(orderId);//订单信息
	    //如果订单已删除。报错提示
  		if("1".equals(order.getDelFlag())){
  			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该订单已删除，请勿支付");
  		}
		//抢购订单必须使用余额支付
		if("1".equals(order.getIsBuying())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "抢购订单只可用余额支付!");
		}
  		if(order != null && order.getPaymentState().equals("1")){
  			totalPrice = order.getTotalPrice();//订单金额
  			title = "CKU业务扣费";
  			//支付宝、微信支付不允许支付包含赛事报名的订单
  			if(restShowApplyService.isShowApplyOrder(order)){
  				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该订单包含赛事报名项，请用余额支付");
  			}
  		}else{
  			//判断是否是商城订单
  			ShopOrder sOrder = shopOrderService.get(orderId);
  			if(sOrder != null && sOrder.getPaymentState().equals("1")){
  				totalPrice = sOrder.getPrice();
  				title = "CKU商城扣费";
  			}else{
  				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"订单验证失败");
  			}
  		}
  		String[] parameters={
  	          "service=\"mobile.securitypay.pay\"",//固定值（手机快捷支付）
  	          "partner=\""+AlipayConfig.partner+"\"",//合作身份者ID（16位）
  	          "_input_charset=\""+AlipayConfig.input_charset+"\"",
  	          "notify_url=\""+ali_call_back_url+"\"",//TODO 通知地址（回调地址）
  	          "out_trade_no=\""+orderId+"\"",//商户内部订单号
  	          "subject=\""+title+"\"",//测试
  	          "payment_type=\"1\"",//固定值
  	          "seller_id=\""+seller_id+"\"",//账户邮箱
  	          "total_fee=\""+totalPrice+"\"",//TODO 支付金额（元）
  	          "body=\""+title+"\"",//订单说明
  	          "it_b_pay=\"30m\""//订单过期时间 30分钟过期无效
  	    };

		//增加支付日志
		paymentPayLogService.savePayLog(order.getId(), "1");
		//签名
		String signOrderUrl = signAllString(parameters);
	    RESTResponse result = new RESTResponse("data", signOrderUrl);

		ServletUtils.writeResponse(response, result);

	 }

	/**
	 * 支付宝签名
	 * @param array
	 * @return
	 */
	private String signAllString(String [] array){
	   StringBuffer sb = new StringBuffer("");
	   for (int i = 0; i < array.length; i++) {
	      if(i==(array.length-1)){
	         sb.append(array[i]);
	      }else{
	         sb.append(array[i]+"&");
	      }
	   }
	   System.out.println(sb.toString());
	   String sign = "";
	   try {
	      sign = URLEncoder.encode(PayUtil.sign(sb.toString(), AlipayConfig.RSA_PRIVATE, "utf-8"), "utf-8");//private_key私钥
	   } catch (UnsupportedEncodingException e) {
	      e.printStackTrace();
	   }
	   sb.append("&sign=\""+sign+"\"&");
	   sb.append("sign_type=\"RSA\"");
	   return sb.toString();
	}

}
