package com.cku.restful.v1.sys.service;

import java.util.Date;
import java.util.Objects;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentPayLogService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.JedisUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName PayCallBackService
 **/
@Slf4j
@Service
public class PayCallBackTaskService {

	@Autowired
	private PaymentPayLogService paymentPayLogService;

	@Autowired
	private PaymentOrderService paymentOrderService;

	@Autowired
	private RestOrderService restOrderService;

	@Async("payCallBack")
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void payCallBack(String rdsKey, String orderId, String transactionId, String decryptToString) {
		log.info("==========微信异步回调开始=========" + DateUtils.formatDateTime(new Date()));
		try {
			PaymentOrder order = paymentOrderService.get(orderId);
			if (Objects.nonNull(order) && "1".equals(order.getPaymentState())
					&& StringUtils.isNotEmpty(order.getOrderCode())) {
				// 保存回调的支付日志,更新支付方式
				paymentPayLogService.updatePayInfo(orderId, transactionId, decryptToString, "24");
				// 后台添加功能-现场微信支付 代码修改-lyy
				if (!"28".equals(order.getPaymentWay())) {
					// 24代表微信支付
					order.setPaymentWay("24");
				}
				// 修改第三方订单号
				order.setTransactionId(transactionId);
				long current = System.currentTimeMillis();
				log.info("处理支付回调业务处理 Start===============" + current);
				// 会员端支付后处理逻辑
				restOrderService.afterPay(order);
				log.info("处理支付回调业务处理 End===============" + (System.currentTimeMillis() - current));
				// 修改支付日志支付状态
				paymentPayLogService.updatePayState(orderId, "2", null);
				JedisUtils.getResource().setex(rdsKey, 60 * 60 * 24, "true");
			} else if (order != null && "2".equals(order.getPaymentState())
					&& !StringUtils.isEmpty(order.getOrderCode())) {
				log.info("用户支付成功，订单已经处理过");
				JedisUtils.getResource().setex(rdsKey, 60 * 60 * 24, "true");
			} else {
				log.error("用户支付成功，但是处理失败，没有找到待处理订单");
				// 修改支付日志支付状态
				paymentPayLogService.updatePayState(orderId, "3", "用户支付成功，但是处理失败，没有找到待处理订单");
				JedisUtils.getResource().del(rdsKey);
			}
		} catch (Exception e) {
			log.error("微信支付，回调业务处理失败。", e);
			// 修改支付日志支付状态
			paymentPayLogService.updatePayState(orderId, "3", ExceptionUtil.printStackTrace(e));
			JedisUtils.getResource().del(rdsKey);
		}
		log.info("==========微信异步回调结束=========" + DateUtils.formatDateTime(new Date()));
	}
}
