package com.cku.restful.v1.buying.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.buying.dao.AdvertisementDao;
import com.cku.oa.buying.dao.BuyingOrderDao;
import com.cku.oa.buying.entity.Advertisement;
import com.cku.oa.buying.entity.BuyingOrder;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.buying.model.RestAdvertisement;
import com.cku.restful.v1.buying.model.RestBuyingOrder;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * Created by user on 2016/12/10.
 */
@Service
@Transactional(readOnly = true)
public class RestAdvertisementService {
	
	@Autowired
	public AdvertisementDao advertisementDao;
	@Autowired
	public DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	public KennelService kennelService;
	@Autowired
	public BuyingOrderDao buyingOrderDao;
	@Autowired
	public PaymentChargingItemService paymentChargingItemService;
	@Autowired
	public PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	public PaymentOrderDao paymentOrderDao;
	//犬种百科 页面码
	private static final String ENCYCLOPEDIA_DOGS_PAGEITEM = "E-001";

	
	/**
	 * 获取广告抢购列表
	 * @Author chaixueteng
	 * @2017年11月20日下午3:08:11
	 */
	public RESTResponse getList(HttpServletRequest request) {
		List<Advertisement> advertisementList = advertisementDao.findAllList(new Advertisement());
		List<RestAdvertisement> list = new ArrayList<RestAdvertisement>();
		for (Advertisement advertisement : advertisementList) {
			RestAdvertisement vo = new RestAdvertisement();
			BeanUtil.copyProperties(vo, advertisement, "yyyy-MM-dd");
			list.add(vo);
		}
		return new RESTResponse("list", list);
	}

	/**
	 * 购买页详情
	 * @Author chaixueteng
	 * @2017年11月21日上午10:19:27
	 */
	public RESTResponse get(String pageItem) {
		Member member = UserUtils.getLoginMember();
		Advertisement advertisement = advertisementDao.getByPageItem(pageItem);
		if("2".equals(advertisement.getVersion())){//二期广告位需购买过一期的才行
			//验证是否购买过一期
			int orderCount = buyingOrderDao.getOrderByVersion(member.getMemberCode(),"1");
			if(orderCount<=0){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有购买过下方广告位的用户才可抢购首页广告位");
			}
		}
		//检查产品是否已抢购完毕
		checkAdvertisement(advertisement,null,false,"2");
		if(member == null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该会员的登录信息不存在");
		}
		if(advertisement==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"抢购的广告位不存在!");
		}
		Date saleStartTime = advertisement.getSaleStartTime();
		if(saleStartTime.getTime()>new Date().getTime()){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"抢购还未开始,敬请期待!");
		}
		//校验会员专业有效
		dogBirthCertificateService.validateMDogOwner(member.getMemberCode());
		//校验犬舍有效
		Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
		if(kennel==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"非常抱歉，本次合作只面向犬舍用户!");
		}
		if(kennel.getEndTime()==null||(kennel.getEndTime().getTime()+86399000)<System.currentTimeMillis()){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"您的犬舍为无效犬舍,请续费后再进行购买!");
		}
		//校验犬舍审核状态
		if(!"1".equals(kennel.getReviewState())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"您的犬舍审核状态不是通过状态!");
		}
		//除百科犬种外,其他页面广告位只允许购买一次
		validBuyingCount(member,advertisement,advertisement.getVersion(),null);
		String dogType=null;
		RestAdvertisement vo = new RestAdvertisement();
		BeanUtil.copyProperties(vo, advertisement, "yyyy-MM-dd");
		//根据产品代码检查剩余数量
		checkCommodityCount(vo,dogType);
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(vo.getChargingItemId());
		vo.setPrice(paymentChargingItem.getPrice());
		JSONObject jo = new JSONObject();
		// 犬基本信息
		jo.put("advertisement", vo);
		jo.put("name", member.getName());
		jo.put("mobile", member.getMobile());
		return new RESTResponse("data", vo);
	}

	/**
	 * 检查产品是否已没有库存
	 * @Author chaixueteng
	 * @2017年11月22日下午1:42:33
	 */
	public void checkAdvertisement(Advertisement advertisement,String dogType,boolean b,String paymentState) {
		if(!ENCYCLOPEDIA_DOGS_PAGEITEM.equals(advertisement.getPageItem())){//百科犬种进入后默认为6 
			int checkCommodityCount = buyingOrderDao.checkCommodityCount(advertisement.getId(),null,advertisement.getVersion(),paymentState);
			int mostCount = Integer.parseInt(advertisement.getMostCount());
			if(mostCount<=checkCommodityCount){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该产品已抢购完!");
			}
		}else{
			if(b){
				int checkCommodityCount = buyingOrderDao.checkCommodityCount(advertisement.getId(),dogType,advertisement.getVersion(),paymentState);
				int mostCount = Integer.parseInt(advertisement.getMostCount());
				if(mostCount<=checkCommodityCount){
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该犬种已抢购完!");
				}
			}
		}
	}

	/**
	 * 根据产品代码检查剩余数量
	 * @Author chaixueteng
	 * @2017年11月22日上午10:57:40
	 */
	private void checkCommodityCount(RestAdvertisement advertisement, String dogType) {
		if(ENCYCLOPEDIA_DOGS_PAGEITEM.equals(advertisement.getPageItem())){
			if(dogType==null){
				advertisement.setRemainingNumber(advertisement.getMostCount());
			}else{
				int checkCommodityCount = buyingOrderDao.checkCommodityCount(advertisement.getId(),dogType,advertisement.getVersion(),"2");
				int mostCount = Integer.parseInt(advertisement.getMostCount());
				int a=mostCount-checkCommodityCount;
				String valueOf = String.valueOf(a);
				advertisement.setRemainingNumber(valueOf);
			}
		}else{
			int checkCommodityCount = buyingOrderDao.checkCommodityCount(advertisement.getId(),null,advertisement.getVersion(),"2");
			int mostCount = Integer.parseInt(advertisement.getMostCount());
			int a=mostCount-checkCommodityCount;
			String valueOf = String.valueOf(a);
			advertisement.setRemainingNumber(valueOf);
		}
	}

	/**
	 * 除百科犬种外,其他页面广告位只允许购买一次
	 * @Author chaixueteng
	 * @2017年11月22日上午10:34:14
	 */
	private void validBuyingCount(Member member, Advertisement advertisement, String version,String dogType) {
		User user = member.getUser();
		if(!ENCYCLOPEDIA_DOGS_PAGEITEM.equals(advertisement.getPageItem())){
			int byPageItem = buyingOrderDao.getByPageItem(user.getId(),advertisement.getId(),version);
			if(byPageItem>=1){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"每个页面的广告位只允许购买一次!");
			}
		}else{
			if(StringUtils.isNotBlank(dogType)){
				int byPageItem = buyingOrderDao.getByPageDogType(user.getId(),advertisement.getId(),version,dogType);
				if(byPageItem>=1){
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"每个犬种的广告位只允许购买一次!");
				}
			}
		}
	}
	
	/**
	 * 犬种百科根据犬种获取剩余数量
	 * @Author chaixueteng
	 * @2017年11月21日上午10:19:27
	 */
	public RESTResponse getByDogType(String id,String version,String dogType) {
		Advertisement advertisement = advertisementDao.get(id);
		advertisement.setVersion(version);
		Member member = UserUtils.getLoginMember();
		//检查产品是否已抢购完毕
		checkAdvertisement(advertisement,dogType,true,"2");
		//百科犬种每个犬种页面广告位只允许购买一次
		validBuyingCount(member,advertisement,advertisement.getVersion(),dogType);
		RestAdvertisement vo = new RestAdvertisement();
		BeanUtil.copyProperties(vo, advertisement, "yyyy-MM-dd");
		//根据产品代码检查剩余数量
		checkCommodityCount(vo,dogType);
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(vo.getChargingItemId());
		vo.setPrice(paymentChargingItem.getPrice());
		return new RESTResponse("data", vo);
	}

	/**
	 * 确认购买
	 * @Author chaixueteng
	 * @2017年11月22日下午2:15:30
	 */
	@Transactional(readOnly = false)
	public synchronized RESTResponse post(String json) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		RestBuyingOrder vo = BeanUtil.toBean(json, RestBuyingOrder.class);
		// 参数校验
		validateParameter(vo);
		//抢购检验
		Advertisement advertisement = advertisementDao.get(vo.getCommodityId());
		//检查购买次数
		validBuyingCount(member,advertisement,vo.getVersion(),vo.getDogType());
		//检查库存
		if(StringUtils.isBlank(vo.getDogType())){
			checkAdvertisement(advertisement,vo.getDogType(),false,"2");
		}else{
			checkAdvertisement(advertisement,vo.getDogType(),true,"2");
		}
		//二期广告位需购买过一期的才行
		if("2".equals(advertisement.getVersion())){
			//验证是否购买过一期
			int orderCount = buyingOrderDao.getOrderByVersion(member.getMemberCode(),"1");
			if(orderCount<=0){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有购买过下方广告位的用户才可抢购首页广告位");
			}
		}
		// 构造持久对象
		BuyingOrder po = buildPo(vo,advertisement);
		//添加订单
		String orderId = toOrder(po,advertisement);
		return new RESTResponse("data",orderId);
	}
	
	/**
	 * 添加订单
	 * @Author chaixueteng
	 * @2017年11月22日下午6:01:43
	 */
	@Transactional(readOnly = false)
	private String toOrder(BuyingOrder po,Advertisement advertisement) {
		PaymentOrder paymentOrder = new PaymentOrder();
		paymentOrder.setMemberCode(po.getMemberCode());
		Double orderTotal = Double.valueOf(po.getPrice());
		paymentOrder.setIsBuying("1");
		//保存订单
		String runningNumber = SysCodeUtil.getPayRunningNumberWithMemberCode(paymentOrder.getMemberCode());
		String loginType = UserUtils.getLoginUser().getLoginType();
		paymentOrder.setOrderCode(runningNumber);
		paymentOrder.setAddTime(po.getCreateDate());
		paymentOrder.setLocked("0");
		paymentOrder.setTotalPrice(orderTotal.toString());
		paymentOrder.setPaymentState("1");
		paymentOrder.setSource(loginType);
		paymentOrder.preInsert();
		paymentOrderDao.insert(paymentOrder);
		//生成订单详情
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setOrderCode(paymentOrder.getOrderCode());
		detail.setAddTime(paymentOrder.getCreateDate());
		detail.setProccessState("0");
		detail.setTotalPrice(paymentOrder.getTotalPrice());
		detail.setNum("1");
		detail.setPrice(po.getPrice());
		detail.setBusinessIds(po.getId());
		detail.setBusinessTable("buying_order");
		detail.preInsert();
		detail.setChargingItemId(advertisement.getChargingItemId());
		detail.setMemberCode(po.getMemberCode());
		detail.setMemberName(po.getName());
		detail.setChargingItemName(advertisement.getChargingItemName());
		paymentOrderDetailDao.insert(detail);
		
		//更新业务表不为空且不为会员表的收费项
		if(StringUtils.isNotBlank(detail.getBusinessTable())&&!"sys_member".equals(detail.getBusinessTable())&&!"kennel".equals(detail.getBusinessTable())){
			String businessIds = detail.getBusinessIds();
			if("dog_birth_certificate".equals(detail.getBusinessTable())){
				//出生纸特殊处理
				paymentOrderDao.updateDogBirthCertificateRunningNo(paymentOrder.getOrderCode(), businessIds);
			}else{
				paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), detail.getBusinessTable(), businessIds);
			}
		}
		return paymentOrder.getId();
	}

	/**
	 * 构造抢购订单
	 * @Author chaixueteng
	 * @2017年11月22日下午3:59:54
	 */
	@Transactional(readOnly = false)
	private BuyingOrder buildPo(RestBuyingOrder vo,
			Advertisement advertisement) {
		Member member = UserUtils.getLoginMember();
		BuyingOrder buyingOrder = new BuyingOrder();
		buyingOrder.setCommodityId(advertisement.getId());
		buyingOrder.setCommodityName(advertisement.getProductName());
		buyingOrder.setDogType(vo.getDogType());
		buyingOrder.setMemberCode(member.getMemberCode());
		buyingOrder.setName(vo.getName());
		buyingOrder.setMobile(vo.getMobile());
		buyingOrder.setPaymentState("1");
		buyingOrder.setPaymentTime(null);
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(advertisement.getChargingItemId());
		buyingOrder.setPrice(paymentChargingItem.getPrice());
		buyingOrder.setVersion(advertisement.getVersion());
		buyingOrder.preInsert();
		//统一增值为15分钟有效期
		Calendar calendar = Calendar.getInstance();//日历对象
		calendar.setTime(buyingOrder.getCreateDate());//设置当前日期
		calendar.add(Calendar.MINUTE, 15); //加15分钟
		Date createDateMinute = calendar.getTime();
		buyingOrder.setDelTime(createDateMinute);
		buyingOrderDao.insert(buyingOrder);
		return buyingOrder;
	}

	/**
	 * 参数校验
	 * @Author chaixueteng
	 * @2017年11月22日下午2:27:04
	 */
	private void validateParameter(RestBuyingOrder vo) {
		if (StringUtils.isBlank(vo.getCommodityId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "产品代码不能为空");
		}
		if ("6".equals(vo.getCommodityId())&&StringUtils.isBlank(vo.getDogType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种不能为空");
		}
		if(StringUtils.isBlank(vo.getMobile())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "联系电话不能为空");
		}
		if(StringUtils.isBlank(vo.getName())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "联系人不能为空");
		}
	}

	/**
	 * 点击进入二期 广告位抢购页
	 * @Author chaixueteng
	 * @2017年12月1日上午9:43:39
	 */
	public RESTResponse getByVersion(String version) {
		Member member = UserUtils.getLoginMember();
		//验证是否购买过一期
		int orderCount = buyingOrderDao.getOrderByVersion(member.getMemberCode(),version);
		if(orderCount<=0){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有购买过下方广告位的用户才可抢购首页广告位");
		}
		return new RESTResponse();
	}

}
