/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.web;

import com.cku.restful.v1.breeder.service.BreederDogNewbornService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 配种证明Controller
 *
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Controller
@RequestMapping(value = "/api/v1/breeder/dog/dognewborn")
public class BreederDogNewbornController extends BaseRestController {

    @Autowired
    private BreederDogNewbornService service;

    @RequestMapping(value = "", method = RequestMethod.POST)
    public void post(@RequestBody String json,HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.post(request,json));
    }

    @RequestMapping(value = "/order/{id}", method = RequestMethod.GET)
    public void order(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.order(id));
    }

    /**
     * @description: 获取名下可配种列表
     * @author: laiguanglong
     * @date: 2017/9/5 13:51
     */
    @RequestMapping(value = "/getBreedableDog", method = RequestMethod.GET)
    public void getBreedableDog(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.getBreedableDog(request));
    }

    /**
     * @description: 查询并校验母犬
     * @author: laiguanglong
     * @date: 2017/9/5 13:51
     */
    @RequestMapping(value = "/getMotherDog", method = RequestMethod.GET)
    public void getMotherDog(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.getMotherDog(request));
    }

    /**
     * @description: 校验配种日期
     * @author: laiguanglong
     * @date: 2017/9/5 13:51
     */
    @RequestMapping(value = "/checkBreedDate", method = RequestMethod.GET)
    public void checkBreedDate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.checkBreedDate(request));
    }
    
    /**
     * 获取价格信息
     * @param json
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "/getPriceInfo", method = RequestMethod.GET)
	@ResponseBody
	public void getPriceInfo(@RequestBody String json,HttpServletRequest request, HttpServletResponse response) 
			throws Exception {
    	 ServletUtils.writeResponse(response, service.getPriceInfo(request,json));
    }
    
    /**
     * 获取可用优惠券列表
     * @param json
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "/getCoupons", method = RequestMethod.GET)
	@ResponseBody
	public void getCoupons(HttpServletRequest request, HttpServletResponse response) throws Exception {
    	 ServletUtils.writeResponse(response, service.getCoupons(request));
    }
    
    /**
     * 获取总价
     * @param json
     * @param request
     * @param response
     * @throws Exception
     */
    @RequestMapping(value = "/getTotalPrice", method = RequestMethod.GET)
  	@ResponseBody
  	public void getTotalPrice(@RequestBody String json,HttpServletRequest request, HttpServletResponse response) 
  			throws Exception {
      	 ServletUtils.writeResponse(response, service.getTotalPrice(request,json));
      }

}