package com.cku.restful.v1.breeder.model;

/**
 * @description: 犬只激活搜索更多条件标签
 * @author: laiguanglong
 * @date: 2017/10/30 17:08
 */
public enum DogActivationSearchLabelOtherEnum {
    KESHANGMEN("公", "1", "male"),
    PEIGUO("母", "2", "female"),
    DUOTUZHANGSHI("3个月", "3", "threeMonth");

    private final String label;
    private final String value;
    private final String parameter;

    DogActivationSearchLabelOtherEnum(String label, String value, String parameter) {
        this.label = label;
        this.value = value;
        this.parameter = parameter;
    }

    public String getLabel() {
        return label;
    }

    public String getValue() {
        return value;
    }

    public String getParameter() {
        return parameter;
    }

    public static DogActivationSearchLabelOtherEnum getByValue(String value) {
        for (DogActivationSearchLabelOtherEnum e : DogActivationSearchLabelOtherEnum.values()) {
            if (e.value.equals(value)) {
                return e;
            }
        }
        return null;
    }
}
