package com.cku.restful.v1.appreciation.model;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@ApiModel
@NoArgsConstructor
@AllArgsConstructor
public class RestAppreciationCourse implements Serializable {

	private static final long serialVersionUID = -8606324525265916411L;

	@ApiModelProperty(value = "课程ID")
	private String id;

	@ApiModelProperty(value = "课程编号")
	private String courseCode;

	@ApiModelProperty(value = "课程名称")
	private String courseName;

	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "课程开始日期")
	private Date startDate;

	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "课程结束日期")
	private Date endDate;

	@ApiModelProperty(value = "讲师名称")
	private String teacher;

	@ApiModelProperty(value = "地点")
	private String courseLocation;

	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "课件最新更新日期")
	private Date lastCoursewareUpdateDate;

}
