package com.cku.partner.club.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipChangeService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sys.entity.ExpressSend;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressSendService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;


/**
 * Title: com.cku.partner.club.service
 * Description:
 * Company: cab
 *
 * @author yuanshuai
 * @date 2018/9/13 14:01
 */
@Service
@Transactional(readOnly = true)
public class ClubDogAppraisalService {

    private static final String DOG_CHIP = "241";//芯片费
    private static final String DOG_CHIP_SERVICE = "240";//电子芯片埋植服务费
    private static final String DOG_APPRAISAL_SERVICE = "14";//纯种犬鉴定服务费
    private static final String DOG_APPRAISAL_REGISTER = "15";//纯种犬鉴定证书登记费
    private static final String DOG_APPRAISAL_DNA = "246";//登记服务费(纯种犬DNA样本)

    @Autowired
    private DogAppraisalService dogAppraisalService;
    @Autowired
    private DogService dogService;
    @Autowired
    private MemberService memberService;
//    @Autowired
//    private ExpressQueueService expressQueueService;
    @Autowired
    private PaymentChargingItemService paymentChargingItemService;
    @Autowired
    private LoginServerService loginServerService;
    @Autowired
    private RestOrderService restOrderService;
    @Autowired
    private PaymentOrderDetailDao paymentOrderDetailDao;
    @Autowired
    private PaymentOrderService paymentOrderService;
    @Autowired
    private DogChipChangeService dogChipChangeService;
    @Autowired
    private DogBloodSaveService dogBloodSaveService;
    @Autowired
    private DogBirthCertificateService dogBirthCertificateService;
    @Autowired
    private DogChipChangeDao dogChipChangeDao;
    @Autowired
	DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private ExpressSendService expressSendService;
	
	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;
	
	@Autowired
    public OrgDogTypeLimitService orgDogTypeLimitService;
	
	@Autowired
	private DogTypeService dogTypeService;

    public DogAppraisal get(DogAppraisal dogAppraisal) {
        return dogAppraisalService.get(dogAppraisal);
    }

    public Page<DogAppraisal> findPage(Page<DogAppraisal> dogAppraisalPage, DogAppraisal dogAppraisal) {
        return dogAppraisalService.findPage(dogAppraisalPage, dogAppraisal);
    }

    @Transactional(readOnly = false)
    public String print(DogAppraisal print, Model model) {
        //准备打印数据
        DogAppraisal dogAppraisal = dogAppraisalService.get(print.getId());
        Dog dog = dogService.get(dogAppraisal.getDogId());
        return dogService.processPrintBusiness(dog, model, Boolean.FALSE);
    }

    public String printDna(DogAppraisal dogAppraisal, Model model) {
        dogAppraisalService.printDna(dogAppraisal, model);
        return "partner/dogAppraisal/dogAppraisalDnaPrint";
    }

    /**
     * @Description： 犬只鉴定添加
     * @author: yuanshuai
     * @date: 2018/9/19 16:26
     */
    @Transactional(readOnly = false)
    public void add(DogAppraisal dogAppraisal) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        //判断犬种是否有效
        if("singleTypeClub".equals(org.getOrgType()) && !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(),dogAppraisal.getDogBreed())){
            throw new ZAException(ZAErrorCode.ZA_ERROR,"俱乐部不经营此犬种，如有疑问，请联系CKU。");
        }
        //查找会员
        Member member = memberService.getByMemberCode(dogAppraisal.getDogOwnerCode());
        if (member == null || StringUtils.isBlank(member.getId())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号有误");
        }
        if ("230".equals(dogAppraisal.getDogBreed())
                || "166".equals(dogAppraisal.getDogBreed())
                || "147".equals(dogAppraisal.getDogBreed())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "西藏獒犬、德国牧羊犬、罗威纳犬不可在地方俱乐部办理");
        }
        //参数校验
        validateParameter(dogAppraisal, member);
        //业务校验
        buildPo(dogAppraisal, member);
        //审核状态不为不通过添加dna记录
        if (!"0".equals(dogAppraisal.getReviewState())) {
            addDnaBloodSave(dogAppraisal);
        }
        //写入业务表
        dogAppraisalService.save(dogAppraisal);
        //添加订单
        dogAppraisal = get(dogAppraisal);
        buildOrder(dogAppraisal);
    }

    /**
     * @Description： 添加DNA血样留存
     * @author: yuanshuai
     * @date: 2018/9/28 10:33
     */
    private void addDnaBloodSave(DogAppraisal dogAppraisal) {
        DogBloodSave dogBloodSave = new DogBloodSave();
        dogBloodSave.setShowAppraisalCode(dogAppraisal.getShowAppraisalCode());
        dogBloodSave.setPaymentMemberCode(dogAppraisal.getPaymentMemberCode());
        dogBloodSave.setPrice(paymentChargingItemService.get(DOG_APPRAISAL_DNA).getPrice());
        dogBloodSave.setIsCanceled("0");
        dogBloodSave.setPaymentState("1");
        dogBloodSaveService.save(dogBloodSave);
    }

    /**
     * @Description： 添加芯片变更
     * @author: yuanshuai
     * @date: 2018/9/29 16:42
     */
    private void addDogChipChange(DogAppraisal dogAppraisal, String chipCode) {
        DogChipChange dogChipChange = new DogChipChange();
        dogChipChange.setShowAppraisalCode(dogAppraisal.getShowAppraisalCode());
        dogChipChange.setChipCodeNew(chipCode);
        dogChipChange.setPaymentMemberCode(dogAppraisal.getDogOwnerCode());
        dogChipChange.setReviewState("1");
        dogChipChange.setReviewTime(new Date());
        dogChipChange.setPaymentState("2");
        PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(dogAppraisal.getRunningNumber());
        dogChipChange.setRunningNumber(paymentOrder.getOrderCode());
        dogChipChange.setPaymentTime(paymentOrder.getPaymentTime());
        dogChipChange.setProcessState("1");
        dogChipChange.setProcessTime(new Date());
        //芯片变更记录表中增加一条变更记录
        dogChipChangeService.save(dogChipChange);
    }


    /**
     * @description: 参数校验
     * @author: laiguanglong
     * @date: 2016年9月9日 上午9:41:47
     */
    private void validateParameter(DogAppraisal vo, Member member) {
        if (StringUtils.isBlank(vo.getDogName())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬名为空");
        }
        if (StringUtils.isBlank(vo.getDogBreed())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种为空");
        }
        //校验犬种是否符合当前用户
        loginServerService.findDogTypeByMemberSite(vo.getDogBreed(), member.getMemberSite());
        if (StringUtils.isBlank(vo.getDogFurColor())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "毛色为空");
        }
        if (StringUtils.isBlank(vo.getDogGender())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "性别为空");
        }
        if (!"1".equals(vo.getDogGender()) && !"2".equals(vo.getDogGender())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "性别只能为1或2");
        }
        if (vo.getBirthday() == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期为空");
        }
        if (new Date().before(vo.getBirthday())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期必须小于当前日期");
        }
        //6）	办理此业务需要保证cku会员（基础或者专业）有效
        if (!MemberUtil.isActiveMember(member)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务仅限有效会员办理");
        }
        if (!"basic".equals(member.getMemberType()) && !"professional".equals(member.getMemberType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务仅限基础会员或专业会员办理");
        }
        //犬名为英文名
        if (!vo.getDogName().matches("^[a-zA-Z ]+$")) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬名只能是英文");
        }
        //犬只年龄大于9个月
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(vo.getBirthday());
        calendar.add(Calendar.MONTH, 9); //月份加x
        if (calendar.getTimeInMillis() > System.currentTimeMillis()) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄必须大于9个月");
        }
    }

    /**
     * @Description： 芯片号查重
     * @author: yuanshuai
     * @date: 2018/9/29 14:25
     */
    private void validateChipCode(String dogChip, String id) {
        //芯片号查重
        if (StringUtils.isNotBlank(dogChip)) {
            //出生纸
            DogBirthCertificate dogBirthCertificate = new DogBirthCertificate();
            dogBirthCertificate.setIdentificationFlag(dogChip);
            List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateService.findList(dogBirthCertificate);
            if (dogBirthCertificateList.size() > 0) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号" + dogChip + "已被其他登记卡使用");
            }
            //鉴定
            DogAppraisal dogAppraisal = new DogAppraisal();
            dogAppraisal.setDogChip(dogChip);
            List<DogAppraisal> appraisalList = dogAppraisalService.findList(dogAppraisal);
            if (appraisalList.size() > 0) {
                if (!id.equals(appraisalList.get(0).getId())) {
                    throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号" + dogChip + "已被其他鉴定记录使用");
                }
            }
        }
    }

    private void buildPo(DogAppraisal dogAppraisal, Member member) {
        dogAppraisal.setDogOwnerCode(member.getMemberCode());
        dogAppraisal.setDogOwnerName(member.getName());
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        if (org == null || StringUtils.isBlank(org.getId())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "俱乐部账户有误");
        }
        //设置地方俱乐部信息 填充赛事编号
        dogAppraisal.setHospitalId(org.getId());
        dogAppraisal.setMainShowInfo(org.getName());
        if (StringUtils.isNotBlank(dogAppraisal.getHospitalId())) {
            dogAppraisalService.setOrgInfo(dogAppraisal);
        }
        dogAppraisal.setPaymentMemberCode(org.getMemberCode());
        //鉴定类型
        dogAppraisal.setIdentifyType("0");
        //获取收费项
        List<PaymentChargingItem> items = getDogAppraisalItem(dogAppraisal);
        //获取金额
        double totalPrice = 0.00;
        for (PaymentChargingItem item : items) {
            totalPrice += Double.parseDouble(item.getPrice());
        }
        dogAppraisal.setPrice(String.valueOf(totalPrice));
        //犬只鉴定表审核状态5为待审核
        dogAppraisal.setPaymentState("1");
        dogAppraisal.setProcessState("0");
    }

    /**
     * @param dogAppraisal
     * @description: 获取犬只鉴定收费项
     * @author: laiguanglong
     * @date: 2017/5/10 14:25
     */
    private List<PaymentChargingItem> getDogAppraisalItem(DogAppraisal dogAppraisal) {
        if (dogAppraisal == null) {
            throw new ZAException(ZAErrorCode.ZA_ERROR, "获取收费项信息有误");
        }
        List<PaymentChargingItem> list = new ArrayList<>();
        list.add(paymentChargingItemService.get(DOG_APPRAISAL_SERVICE));
        if (!"0".equals(dogAppraisal.getReviewState())) {
            list.add(paymentChargingItemService.get(DOG_APPRAISAL_REGISTER));
            list.add(paymentChargingItemService.get(DOG_APPRAISAL_DNA));
            if (!StringUtils.isBlank(dogAppraisal.getChipInject())
                    && "0".equals(dogAppraisal.getChipInject())) {
                list.add(paymentChargingItemService.get(DOG_CHIP));
                list.add(paymentChargingItemService.get(DOG_CHIP_SERVICE));
            }
        }
        return list;
    }

    /**
     * @param dogAppraisal
     * @Description：生成订单
     * @author: yuanshuai
     * @date: 2018/9/19 16:48
     */
    @Transactional(readOnly = false)
    public List<PaymentOrderDetail> buildOrder(DogAppraisal dogAppraisal) {
        //dna血样留存
        DogBloodSave dogBloodSave = null;
        if (!"0".equals(dogAppraisal.getReviewState())) {
            dogBloodSave = dogBloodSaveService.getByShowAppraisalCode(dogAppraisal.getShowAppraisalCode());
            if (dogBloodSave == null || StringUtils.isBlank(dogBloodSave.getId())) {
                throw new ZAException(ZAErrorCode.ZA_ERROR, "犬只DNA血样留存信息有误。");
            }
        }
        //收费项
        List<PaymentChargingItem> itemList = getDogAppraisalItem(dogAppraisal);
        //build order
        PaymentOrder order = new PaymentOrder();
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        Member member = org.getMember();
        order.setMemberCode(dogAppraisal.getDogOwnerCode());
        order.setMemberName(dogAppraisal.getDogOwnerCode());
        order.setAddTime(new Date());
        order.setSource(member.getLoginType());
        //build order detail
        double totalPrice = 0.00;
        List<PaymentOrderDetail> detailList = new ArrayList<>();
        for (PaymentChargingItem item : itemList) {
            totalPrice += Double.parseDouble(item.getPrice());
            PaymentOrderDetail detail = new PaymentOrderDetail();
            detail.setAddTime(order.getAddTime());
            detail.setProccessState("0");
            detail.setTotalPrice(item.getPrice());
            detail.setNum("1");
            detail.setPrice(item.getPrice());
            if (DOG_APPRAISAL_SERVICE.equals(item.getId())) {
                detail.setBusinessIds(dogAppraisal.getId());
                detail.setBusinessTable("dog_appraisal");
            }
            if (DOG_APPRAISAL_DNA.equals(item.getId())) {
                detail.setBusinessIds(dogBloodSave.getId());
                detail.setBusinessTable("dog_blood_save");
            }
            detail.setChargingItemName(item.getName());
            detail.setChargingItemId(item.getId());
            detail.setMemberCode(order.getMemberCode());
            detail.setMemberName(order.getMemberName());
            detailList.add(detail);
        }
        //保存订单
        restOrderService.saveOrder(order, totalPrice, order.getAddTime());
        //save orderDetail
        for (PaymentOrderDetail detail : detailList) {
            detail.setOrderCode(order.getOrderCode());
            detail.preInsert();
            paymentOrderDetailDao.insert(detail);
        }
        //更新业务表的订单号
        dogAppraisal.setShowAppraisalOrderRunningNumber(order.getOrderCode());
        dogAppraisal.setRunningNumber(order.getOrderCode());
        dogAppraisalService.save(dogAppraisal);
        if (!"0".equals(dogAppraisal.getReviewState())) {
            dogBloodSave.setRunningNumber(order.getOrderCode());
            dogBloodSaveService.save(dogBloodSave);
        }
        return detailList;
    }

    /**
     * @Description： 修改
     * @author: yuanshuai
     * @date: 2018/9/20 16:52
     */
    @Transactional(readOnly = false)
    public void edit(DogAppraisal dogAppraisal) {
        DogAppraisal po = dogAppraisalService.get(dogAppraisal);
        //芯片号查重
        validateChipCode(dogAppraisal.getDogChip(), dogAppraisal.getId());
        //添加芯片变更记录
        if ("0".equals(po.getProcessState())
                && "2".equals(po.getPaymentState())
                && StringUtils.isNotBlank(dogAppraisal.getDogChip())) {
            DogChipChange dogChipChange = dogChipChangeDao.getByShowAppraisalCode(po.getShowAppraisalCode());
            if (dogChipChange == null) {
                addDogChipChange(po, dogAppraisal.getDogChip());
            }
        }
        //修改信息
        po.setDogFurColor(dogAppraisal.getDogFurColor());
        po.setDogGender(dogAppraisal.getDogGender());
        po.setIdentifier(dogAppraisal.getIdentifier());
        po.setIdentifySite(dogAppraisal.getIdentifySite());
        po.setIdentifyDate(dogAppraisal.getIdentifyDate());
        po.setDogChip(dogAppraisal.getDogChip());
        po.setReviewRemarks(dogAppraisal.getReviewRemarks());
        dogAppraisalService.edit(po);
    }

}