package com.cku.oa.sys.web;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;

/**
 * 合作机构、合作医院Controller
 * @author fanhuibin
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/club")
public class ClubController extends BaseController {

	@Autowired
	private OrgService orgService;
	
	@ModelAttribute
	public Org get(@RequestParam(required=false) String id) {
		Org entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = orgService.get(id);
		}
		if (entity == null){
			entity = new Org();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:club:view")
	@RequestMapping(value = {"list", ""})
	public String list(Org org, HttpServletRequest request, HttpServletResponse response, Model model) {
		org.setOrgType("club");
		Page<Org> page = orgService.findPage(new Page<Org>(request, response), org); 
		model.addAttribute("page", page);
		Date currentDate = new Date();
		model.addAttribute("currentDate",currentDate);
		return "oa/club/clubList";
	}

	@RequiresPermissions("sys:club:view")
	@RequestMapping(value = "form")
	public String form(Org org, Model model) {
		model.addAttribute("org", org);
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(org.getProvince()));
		if(StringUtils.isEmpty(org.getId())){
			return "oa/club/clubAdd";
		}else{
			return "oa/club/clubForm";
		}
	}

	@RequiresPermissions("sys:club:view")
	@RequestMapping(value = "save")
	public String save(Org org, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(StringUtils.isEmpty(org.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:club:add");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:club:edit");
		}
		if(!hasPermission){
			throw new AuthorizationException("用户权限不足");
		}
		
		if (!beanValidator(model, org)){
			return form(org, model);
		}
		orgService.save(org);
		addMessage(redirectAttributes, "保存俱乐部成功");
		return "redirect:"+Global.getAdminPath()+"/sys/club/?repage";
	}
	
	@RequiresPermissions("sys:club:delete")
	@RequestMapping(value = "delete")
	public String delete(Org org, RedirectAttributes redirectAttributes) {
		orgService.delete(org);
		addMessage(redirectAttributes, "删除合作机构成功");
		return "redirect:"+Global.getAdminPath()+"/sys/club/?repage";
	}
	
}