package com.cku.oa.sys.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.user.KennelType;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.entity.user.MemberType;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.CheckPswUtil;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.util.MD5Generator;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.servlet.ValidateCodeServlet;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.security.OAuthToken;
import com.thinkgem.jeesite.modules.sys.security.UsernamePasswordToken;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

@Service
@Transactional(readOnly = true)
public class UserService {
	@Autowired
	private MemberService memberService;
	@Autowired
	private SystemService systemService;
	@Autowired
	private EmailRemindService emailRemindService;
	@Autowired
	private UserDao userDao;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private KennelDao kennelDao;

	private static final String MODE = Global.getConfig("mode");

	public User get(String id) {
		return userDao.get(id);
	}

	/**
	 *
	 * @description: 密码找回申请
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午3:59:31
	 */
	@Transactional(readOnly = false)
	public RESTResponse applyChangePassword(HttpServletRequest request) {
		String loginName = request.getParameter("loginName");
		String userType = request.getParameter("userType");
		String validateCode = request.getParameter("validateCode");
		String mailType = request.getParameter("mailType");
		if (StringUtils.isBlank(userType)) {
			userType = loginServerService.getLoginServerByUrl(request).getUserType();
		}
		// 参数校验
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号为空");
		}
		if (StringUtils.isBlank(userType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "用户类型为空");
		}
		if (StringUtils.isBlank(validateCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		Session session = UserUtils.getSession();
		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		if (code == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请从新获取验证码");
		}
		// 重置验证码
		session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
		if (!validateCode.toLowerCase().equals(code)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
		}
		User user = systemService.getUserByLoginNameAndUserType(loginName, userType);
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, userType);
			if (user == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的账号不存在");
			}
		}
		String ticket = applyChangePassword(user.getLoginName(), userType);

		user.setMailType(mailType);
		emailRemindService.ChangePasswordMail(user, ticket);
		JSONObject jo = new JSONObject();
		jo.put("email", user.getEmail());
		return new RESTResponse("data", jo);
	}

	/**
	 *
	 * @description: 账号注册
	 * @author: laiguanglong
	 * @date: 2016年9月25日 下午1:27:19
	 */
	@Transactional(readOnly = false)
	public void Regist(String email, String password, String name, String loginName, String validateCode, String mobile,
			String mailType, LoginServer loginServer) {
		// 参数校验
		if (StringUtils.isBlank(email)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮箱为空");
		}
		if (StringUtils.isBlank(password)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码为空");
		}
		if (StringUtils.isBlank(name)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "姓名为空");
		}
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名为空");
		}
		if (StringUtils.isBlank(validateCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		if (StringUtils.isBlank(mobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号为空");
		}
		Session session = UserUtils.getSession();
		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		if (code == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		if (!validateCode.toLowerCase().equals(code)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
		}
		if (!CheckPswUtil.checkMemberPassword(password)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_PASSWORD_SIMPLE, "密码太简单，建议密码长度大于8位,使用字母与数字混合，并且尽量不要有连续的数字或字母");
		}
		// 登录名查重
		if (userDao.check("login_name", loginName, loginServer.getUserType()).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该登录名已存在，请换一个登录名");
		}
		User checkUser = new User();
		checkUser.setEmail(email);
		List<User> emailCheck = systemService.findUser(checkUser);
		if (emailCheck.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该邮箱已被使用，请换一个邮箱");
		}

		// 邮箱查重
		if (userDao.check("email", email, loginServer.getUserType()).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该邮箱已被使用，请换一个邮箱");
		}
		// 手机号查重
		if (userDao.check("mobile", mobile, loginServer.getUserType()).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该手机号已被使用，请换一个手机号");
		}
		// 添加User记录
		User user = new User();
		user.setLoginName(loginName);
		user.setPassword(MD5Generator.generate16(password));
		user.setName(name);
		user.setEmail(email);
		user.setMobile(mobile);
		user.setUserType(loginServer.getUserType());// 会员
//		user.setLoginFlag("0");//1表示可登录，不为1表示不可登录
		user.setMailCheck("0");// 0表示未验证邮箱
		String ticket = UUID.randomUUID().toString();
		user.setTicket(ticket);//

		user.setMailType(mailType);
//		user.setTicketTime(ticketTime);
		systemService.saveUser(user);
		emailRemindService.RegisteMail(user);
	}

	/**
	 * 激活帐号
	 * 
	 * @param loginName 登录的帐号
	 * @param ticket    验证的密码
	 */
	@Transactional(readOnly = false)
	public void activeUser(String loginName, String ticket, String type) {
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名为空");
		}
		if (StringUtils.isBlank(ticket)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		if (StringUtils.isBlank(type)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "用户类型为空");
		}
		User user = systemService.getUserByLoginNameAndUserType(loginName, type);
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, type);
			if (user == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的账号不存在");
			}
		}
		if (!ticket.equals(user.getTicket())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
		}
		user.setLoginFlag("1");// 1表示可登录，不为1表示不可登录
		user.setMailCheck("1");// 0表示未验证邮箱
		systemService.saveUser(user);
	}

	/**
	 *
	 * @description: 登录
	 * @author: laiguanglong
	 * @date: 2016年9月25日 下午1:27:06
	 */
	@Transactional(readOnly = false)
	public void login(String loginName, String password, String validateCode, String host, String weixinId,
			LoginServer loginServer) {
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
		}
		if (StringUtils.isBlank(password)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码不能为空");
		}
		// 验证码校验
		checkValidateCode(validateCode);
		String userType;
		String loginType;
		if (loginServer == null) {
			userType = "2";
			loginType = "";
		} else {
			userType = loginServer.getUserType();
			loginType = loginServer.getUserTypeNameEn();
		}
		User user = systemService.getUserByLoginNameAndUserType(loginName, userType);
		// 如果用登录名找不到对应的记录，改用邮箱查询
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, userType);
			if (user != null) {
				loginName = user.getLoginName();
			}
		}
		if (user == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
		}
		if (!user.getPassword().equals(MD5Generator.generate16(password))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
		}
		if (!"1".equals(user.getLoginFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该帐号未激活，或者不允许登录会员中心");
		}

		// 将用户信息存放到登录信息里
		UsernamePasswordToken token = new UsernamePasswordToken(loginName, password.toCharArray(), userType, false,
				host, validateCode, false, loginType);
		SecurityUtils.getSubject().login(token);

		// 更新微信id字段
		if (weixinId != null) {
			if ("".equals(weixinId)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "微信号weixinId为空");
			} else {
				// 更新微信id字段
				user.setWeixinId(weixinId);
				userDao.updateWeixinId(user);
			}
		}
	}

	/**
	 *
	 * @description: 犬舍登录
	 * @author:
	 * @date:
	 */
	@Transactional(readOnly = false)
	public RESTResponse kennelLogin(String loginName, String password) {
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
		}
		if (StringUtils.isBlank(password)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码不能为空");
		}
		List<User> userList = userDao.getByLoginName(loginName);
		// 如果用登录名找不到对应的记录，改用邮箱查询
		if (Collections3.isEmpty(userList)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
		}
		User user = null;
		for (User data : userList) {
			if (data.getUserType().equals("2")) {
				user = data;
			} else {
				user = userList.get(0);
			}
		}
		if (StringUtils.isBlank(user.getPassword()) || !user.getPassword().equals(MD5Generator.generate16(password))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
		}
		if (!"1".equals(user.getLoginFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该帐号未激活，或者不允许登录");
		}
		Member member = memberService.getByUserId(user.getId());
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员帐号不存在");
		}
		if (StringUtils.isBlank(member.getMemberType()) || !"professional".equals(member.getMemberType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "仅限有效专业会员登录");
		}
		if (member.getMemberEndDate() == null || new Date().getTime() > member.getMemberEndDate().getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员帐号已过期");
		}
		Kennel kennel = kennelDao.getKennelByMemberCode(member.getMemberCode());
		if (kennel == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍帐号不存在");
		}
		if (kennel.getEndTime() == null || new Date().getTime() > kennel.getEndTime().getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍帐号已过期");
		}
		if (StringUtils.isNotBlank(kennel.getReviewState()) && !"1".equals(kennel.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍无效");
		}
		Map<String, Object> map = new HashMap<>();
		map.put("name", kennel.getName());
		map.put("memberCode", kennel.getMemberCode());
		map.put("kennelCode", kennel.getKennelCode());
		map.put("city", member.getCity());
		map.put("province", member.getProvince());
		map.put("street", member.getStreet());
		map.put("breedName", kennel.getBreedName());
		map.put("createDate", kennel.getCreateDate());
		return new RESTResponse("data", map);
	}

	/**
	 *
	 * @description: 手机token登录
	 * 
	 */
	@Transactional(readOnly = false)
	public void loginMobile(String token, String key, String host) {
		// 解密
		String md5key = MD5Generator.generate16(token + "vipMobile");
		if (!key.equals(md5key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录没有授权信息！");
		}
		User user = UserUtils.getUserInfoByToken(token);
		if (user == null || user.getMobileTokenTime() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录没有授权信息！");
		} else {
			long beforeTime = user.getMobileTokenTime().getTime();
			long afterTime = System.currentTimeMillis();
			long aa = (afterTime - beforeTime) / (1000 * 60);
			if (aa > 5) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录授权信息过期，请重新登录！");
			}
		}
		Session session = UserUtils.getSession();
		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		// 重置验证码
		session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
		UsernamePasswordToken tokenMobile = new UsernamePasswordToken(user.getLoginName(),
				user.getPassword().toCharArray(), "2", false, host, code, true, true);
		SecurityUtils.getSubject().login(tokenMobile);
	}

	@Transactional(readOnly = false)
	public void oauthLogin(String loginName, String password, String host, String client_id) {
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
		}
		if (StringUtils.isBlank(password)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码不能为空");
		}
		User user = systemService.getUserByLoginNameAndUserType(loginName, "2");
		// 如果用登录名找不到对应的记录，改用邮箱查询
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, "2");
			if (user != null) {
				loginName = user.getLoginName();
			}
		}

		if (user == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
		}
		if (!user.getPassword().equals(MD5Generator.generate16(password))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
		}
		if (!"1".equals(user.getLoginFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该帐号未激活，或者不允许登录会员中心");
		}

		// 将用户信息存放到登录信息里
		OAuthToken token = new OAuthToken(loginName, password.toCharArray(), "2", false, host, client_id);
		SecurityUtils.getSubject().login(token);
	}

	/**
	 * 申请修改密码
	 */
	@Transactional(readOnly = false)
	public String applyChangePassword(String loginName, String userType) {
		User user = systemService.getUserByLoginNameAndUserType(loginName, userType);
		String ticket = UUID.randomUUID().toString();
		user.setTicket(ticket);
		systemService.saveUser(user);
		return ticket;
	}

	/**
	 * 更新用户信息
	 */
	@Transactional(readOnly = false)
	public void updateUserInfo(User user, Member member) {
		// 2019.12.10将邮箱判重注释掉（王梓要求）
//		if(StringUtils.isNotBlank(member.getEmail()) && memberService.emailCheck(member.getEmail(),member.getId(),member.getMemberSite()).contains("false")){
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮箱重复，请重新输入！");
//		};
		// 20180118 安全手机功能其他联系方式修改可以重复
//		if(memberService.mobileCheck(member.getMobile(),member.getId()).indexOf("false")>-1){
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号码重复，请重新输入！");
//		};
		memberService.save(member);
		systemService.saveUser(user);
	}

	/**
	 * 通过ticket修改密码
	 */
	@Transactional(readOnly = false)
	public void confirmChangePassword(String loginName, String type, String newPassword, String ticket) {
		User user = systemService.getUserByLoginNameAndUserType(loginName, type);
		if (ticket.equals(user.getTicket())) {
			user.setTicket("");
			user.setTicketTime(null);
			systemService.updateUserInfo(user);
			systemService.updatePasswordById(user.getId(), loginName, newPassword);
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "修改密码失败");
		}
	}

	/**
	 * 通过密码修改密码
	 */
	@Transactional(readOnly = false)
	public void ChangePasswordByOldPassword(User user, String newPassword, String oldPassword) {
		user = systemService.getUserByLoginNameAndUserType(user.getLoginName(), user.getUserType());
		if (systemService.entryptPassword(oldPassword).equals(user.getPassword())) {
			user.setTicket("");
			user.setTicketTime(null);
			systemService.updateUserInfo(user);
			systemService.updatePasswordById(user.getId(), user.getLoginName(), newPassword);
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "修改密码失败");
		}
	}

	/**
	 *
	 * @description: 外籍会员缴费MEMER_FOREIGN
	 * @author: laiguanglong
	 * @date: 2016年9月23日 下午2:49:12
	 */
	public void memerForeignSql(StringBuffer buffer, String businessId, Member member) {
		if (!"foreign".equals(member.getMemberType())) {
			throw new ZAException(-1, "会员不是外籍会员不能缴费！");
		}
		String date = "";
		if (member.getMemberEndDate() != null && member.getMemberEndDate().getTime() > System.currentTimeMillis()) {
			date = DateUtils.get1YearLater(member.getMemberEndDate());
		} else {
			date = DateUtils.get1YearLater(new Date());
		}
		buffer.append("UPDATE sys_member SET ").append("member_end_date = '").append(date).append("' ")
				.append("WHERE id='").append(businessId).append("'");

		RemindService remindService = (RemindService) SpringContextHolder.getBean("remindService");
		String s[] = date.split("-");
		String d = s[0] + "年" + s[1] + "月" + s[2] + "日";
		StringBuffer sb = new StringBuffer();
		sb.append("您的外籍会员缴费业务办理成功，会员有效期").append(d).append("。");
		remindService.addRemind(sb.toString(), member.getMemberCode());
	}

	/**
	 *
	 * @description: 基础会员升级为专业会员MEMBER_BASIC_TO_PROFESSIONAL
	 * @author: laiguanglong
	 * @date: 2016年9月23日 下午2:28:27
	 */
	public void memberBasicToProfessionalSql(StringBuffer buffer, String businessId, String memberCode) {
		// 会员升级为专业会员的时候需要重新缴费，重新计算会员的时间
		// 设置会员的截止时间为今天。
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		String date = format.format(new Date());
		buffer.append("UPDATE sys_member SET ").append("member_type = '").append(MemberType.professional.toString())
				.append("', member_end_date = '").append(date).append("' ").append("WHERE id='").append(businessId)
				.append("'");

		RemindService remindService = (RemindService) SpringContextHolder.getBean("remindService");
		remindService.addRemind("您的基础会员升级为专业会员业务办理成功，恭喜您成为cku专业会员。", memberCode);
	}

	/**
	 *
	 * @description: 基础会员缴费MEMER_BASIC
	 * @author: zhangjunwu
	 * @date: 2020年06月04日 下午2:49:12
	 */
	public void memerBasicSql(StringBuffer buffer, String businessId, Member member2) {
		Member member = memberService.get(businessId);
		if (!MemberUtil.isBasicMember(member) && member.getMemberEndDate() != null) {
			throw new ZAException(-1, "会员不是基础会员不能缴费！");
		}
		String date = "";
		Date current = new Date();// 当前日期
		if (member.getMemberEndDate() != null && member.getMemberEndDate().after(current)) {
			date = DateUtils.get1YearLater(member.getMemberEndDate());
		} else {
			date = DateUtils.get1YearLater(current);
		}
		buffer.append("UPDATE sys_member SET ")
				.append("member_card_type=" + MemberCardTypeEnum.SILVER_CARD.code() + ",member_end_date = '")
				.append(date).append("' ");
		buffer.append(",member_type = '").append(MemberType.basic.toString()).append("' ");
		if (member.getMemberEndDate() == null) {
			buffer.append(",first_payment_time = '").append(DateUtils.getDateTime()).append("' ");
		}
		buffer.append("WHERE id='").append(businessId).append("'");
	}

	/**
	 *
	 * @description: 专业会员初次注册费MEMBER_PROFESSIONAL_FIRST
	 * @author: zhangjunwu
	 * @date: 2020年06月04日 下午2:49:12
	 */
	public void memberProfessionalFirstSql(StringBuffer buffer, String businessId) {
		Date current = new Date();// 当前日期
		String date = DateUtils.formatDate(current, "yyyy-MM-dd");
		buffer.append("UPDATE sys_member SET ").append("member_type = '").append(MemberType.professional.toString())
				.append("', member_end_date = '").append(date).append("' ").append("WHERE id='").append(businessId)
				.append("';");
	}

	/**
	 *
	 * @description: 专业会员缴费MEMBER_PROFESSIONAL
	 * @author: zhangjunwu
	 * @date: 2020年06月04日 下午2:49:12
	 */
	public void memberProfessionalSql(StringBuffer buffer, String businessId, Member member2) {
		Member member = memberService.get(businessId);
		Kennel kennel = kennelDao.getKennelByMemberCode(member.getMemberCode());
		String memberCardType = MemberCardTypeEnum.GOLDEN_CARD.code();
		if (kennel != null && !"3".equals(kennel.getReviewState())) {
			if (KennelType.permanent.toString().equals(kennel.getType())) {
				memberCardType = MemberCardTypeEnum.PURPLE_CARD.code();
			} else {
				memberCardType = MemberCardTypeEnum.PLATINUM_CARD.code();
			}
		}
		Calendar calendar = Calendar.getInstance();// 日历对象
		calendar.add(Calendar.MONTH, -1);// 月份-1
		// 根据当前日期获取用户的日期，如果用户过期没超过一个月，则在原来的时间上续费1年
		// 如果用户过期超过一个月，则一方面需要缴纳初次登记费，另一方面日期要按缴费当天计算
		String date = "";
		if (member.getMemberEndDate() == null || member.getMemberEndDate().before(calendar.getTime())) {
			date = DateUtils.get1YearLater(new Date());
		} else {
			// 用户过期小于一个月或未过期
			date = DateUtils.get1YearLater(member.getMemberEndDate());
		}
		buffer.append("UPDATE sys_member SET ").append("member_card_type=" + memberCardType + ",member_type = '")
				.append(MemberType.professional.toString()).append("', member_end_date = '").append(date).append("' ")
				.append("WHERE id='").append(businessId).append("';");
	}

	/**
	 *
	 * @description: 会员与犬舍信息同步，与后到期的保持一致
	 * @author: zhangjunwu
	 * @date: 2020年06月04日 下午2:49:12
	 */
	public void memberExpireIdenticalSql(StringBuffer buffer, String businessId) {
		Member member = memberService.get(businessId);
		if (!MemberUtil.isProfessionalBreedMember(member)) {
			throw new ZAException(-1, "会员不是繁育专业会员不能缴费！");
		}
		Date memberEndDate = member.getMemberEndDate();
		Date kennelEndDate = member.getKennel().getEndTime();
		if (memberEndDate.after(kennelEndDate)) {
			buffer.append("UPDATE kennel SET ").append(" end_time = '")
					.append(DateUtils.formatDate(memberEndDate, "yyyy-MM-dd")).append("' ").append("WHERE id='")
					.append(member.getKennel().getId()).append("' ");
		} else if (memberEndDate.before(kennelEndDate)) {
			buffer.append("UPDATE sys_member SET ").append(" member_end_date = '")
					.append(DateUtils.formatDate(kennelEndDate, "yyyy-MM-dd")).append("' ").append("WHERE id='")
					.append(member.getId()).append("' ");
		} else {
			throw new ZAException(-1, "有效期相同，无需补齐日期！");
		}
	}

	/**
	 *
	 * @description: 专业繁育会员初次注册费MEMBER_PROFESSIONAL_BREED_FIRST
	 * @author: zhangjunwu
	 * @date: 2020年06月04日 下午2:49:12
	 */

	public void memberProfessionalBreedFirstSql(StringBuffer buffer, String businessId) {
		// 年度和永久均有此收费项，故不做处理
	}

	/**
	 *
	 * @description: 专业繁育会员登记费MEMBER_PROFESSIONAL_BREED
	 * @author: zhangjunwu
	 * @date: 2020年06月04日 下午2:49:12
	 */
	public void memberProfessionalBreedSql(StringBuffer buffer, String businessId) {
		Member member = memberService.get(businessId);
		Kennel kennel = member.getKennel();
		Calendar calendar = Calendar.getInstance();// 日历对象
		calendar.add(Calendar.MONTH, -1);// 月份-1
		String date = "";
		Date today = new Date();
		if (MemberType.professional.toString().equals(member.getMemberType())) {
			if (member.getMemberEndDate() == null || member.getMemberEndDate().before(calendar.getTime())) {
				date = DateUtils.get1YearLater(today);
			} else if (!MemberCardTypeEnum.PLATINUM_CARD.code().equals(member.getMemberCardType())
					&& (kennel.getEndTime() == null || !kennel.getEndTime().after(today))
					&& member.getMemberEndDate().before(today)) {
				date = DateUtils.get1YearLater(today);
			} else {
				date = DateUtils.get1YearLater(member.getMemberEndDate());
			}
		} else {
			date = DateUtils.get1YearLater(today);
		}

		buffer.append("UPDATE sys_member SET ")
				.append("member_card_type=" + MemberCardTypeEnum.PLATINUM_CARD.code() + ",member_type = '")
				.append(MemberType.professional.toString()).append("' ");
		if (member.getMemberEndDate() == null) {
			buffer.append(",first_payment_time = '").append(DateUtils.getDateTime()).append("' ");
		}
		buffer.append(", member_end_date = '").append(date).append("' ").append("WHERE id='").append(member.getId())
				.append("'; ");

		buffer.append("UPDATE kennel SET ").append("end_time = '").append(date).append("' ").append(" ,type = 'year' ")
				.append("WHERE id='").append(kennel.getId()).append("'; ");
	}

	/**
	 * 计算月龄
	 *
	 * @param date
	 * @param birthdate
	 * @return
	 */
	private int getMonthAge(Date date, Date birthdate) {
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		int monthAge = dateCalendar.get(Calendar.MONTH) - birthdateCalendar.get(Calendar.MONTH);
		if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar.get(Calendar.YEAR)) {
			monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar.get(Calendar.YEAR)) * 12 + monthAge;
		}
		birthdateCalendar.add(Calendar.MONTH, monthAge);
		if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
			monthAge = monthAge - 1;
		}
		return monthAge;
	}
	/**
	 *
	 * @description: 专业繁育会员初次注册费MEMBER_PROFESSIONAL_BREED_FIRST
	 * 
	 */
//	public void memberProfessionalBreedFirstSql(StringBuffer buffer,String businessId){
//		Date current = new Date();//当前日期
//		String date = DateUtils.formatDate(current, "yyyy-MM-dd");
//		
//	   	buffer.append("UPDATE sys_member SET ").append("member_type = '").append(MemberType.professional.toString())
//	   	.append("', member_end_date = '").append(date).append("' ")
//	       .append("WHERE id='").append(businessId).append("';");
//	   	
//		buffer.append("UPDATE kennel SET ").append("end_time = '").append(date).append("' ")
//	    .append("WHERE id='").append(businessId).append("';");
//	}

	/**
	 *
	 * @description: 专业繁育会员初次注册费MEMBER_PROFESSIONAL_BREED_FIRST
	 * 
	 */
	public void memberProfessionalBreedSql(StringBuffer buffer, String businessId, String memberCode) {
		String date = DateUtils.get1YearLater(new Date());

		buffer.append("UPDATE sys_member SET ").append("member_type = '").append(MemberType.professional.toString())
				.append("', member_end_date = '").append(date).append("' ").append("WHERE id='").append(businessId)
				.append("';");

//		buffer.append("UPDATE kennel SET ").append("end_time = '").append(date).append("' ")
//	    .append("WHERE member_code='").append(memberCode).append("';");
	}

	/**
	 *
	 * @description: 美容师会员续费更新Sql
	 * @author: laiguanglong
	 * @date: 2016年10月12日 下午2:10:57
	 */
	public void memberGroomerRenewSql(StringBuffer buffer, String businessId, Member member) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Date now = new Date();
		member.getGroomerEndDate();
		member.getGroomerType();
		String date = null;
		String memberDate = null;
		String groomerType = null;
		buffer.append("UPDATE sys_member SET ");
		if (member.getGroomerEndDate() != null && now.before(member.getGroomerEndDate())) {
			// 未过期
			date = "groomer_end_date";
			groomerType = member.getGroomerType();
			Boolean dateFlag = retDate(member.getGroomerEndDate(), member.getMemberEndDate(), member.getMemberType());
			if (dateFlag) {// 不同步会员截止日期
				buffer.append("groomer_type=\"" + groomerType + "\",groomer_end_date = DATE_ADD(" + date
						+ ",INTERVAL 1 YEAR) WHERE id='").append(businessId).append("'");
			} else {// 同步会员截止日期
				buffer.append("groomer_type=\"" + groomerType
						+ "\",member_card_type = if(member_card_type='100','1010',member_card_type),member_end_date=DATE_ADD("
						+ date + ",INTERVAL 1 YEAR),groomer_end_date = DATE_ADD(" + date
						+ ",INTERVAL 1 YEAR) WHERE id='").append(businessId).append("'");
			}
		} else {// 过期
			date = "'" + format.format(now) + "'";
			if (StringUtils.isBlank(member.getGroomerType())) {
				groomerType = "reserve";
			} else {
				groomerType = member.getGroomerType();
			}
			Boolean dateFlag = retDate(member.getGroomerEndDate(), member.getMemberEndDate(), member.getMemberType());
			if (dateFlag) {// 不同步会员截止日期
				date = "'" + format.format(now) + "'";
				buffer.append("groomer_type=\"" + groomerType + "\",groomer_end_date = DATE_ADD(" + date
						+ ",INTERVAL 1 YEAR) WHERE id='").append(businessId).append("'");
			} else {// 同步会员截止日期
				buffer.append("groomer_type=\"" + groomerType
						+ "\",member_card_type = if(member_card_type='100','1010',member_card_type),member_end_date=DATE_ADD("
						+ date + ",INTERVAL 1 YEAR),groomer_end_date = DATE_ADD(" + date
						+ ",INTERVAL 1 YEAR) WHERE id='").append(businessId).append("'");
			}
		}
	}

	/**
	 * 比较截止日期(美容和会员的)
	 * 
	 * @Author chaixueteng
	 * @2017年7月11日下午6:44:33
	 */
	public Boolean retDate(Date groomerDate, Date memberDate, String memberType) {
		Calendar calendar = Calendar.getInstance();// 日历对象
		if (groomerDate == null) {
			groomerDate = new Date();
		}
		calendar.setTime(groomerDate);// 设置当前日期
		calendar.add(Calendar.YEAR, 1);// 年份+1
		Date groomerNewDate = calendar.getTime();
		if (!"professional".equals(memberType)) {// 只同步基础会员的 不同步专业会员的
			if (memberDate != null && memberDate.getTime() > groomerNewDate.getTime()) {
				return true;// 不同步会员截止日期
			} else {
				return false;// 同步会员截止日期
			}
		} else {
			return true;
		}
	}

	/**
	 *
	 * @description: 美容学校会员缴费更新Sql
	 * @author: laiguanglong 截至时间为空则合作开始日期加一年。截至时间不为空则在截至时间的基础上加一年
	 * @date: 2016年10月12日 下午2:10:57
	 */
	public void memberGroomerSchoolMemberRenewSql(StringBuffer buffer, String businessId, Member member) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		if (member.getMemberEndDate() == null) {
			TrainingInstitution schools = trainingInstitutionDao.getBySchoolMemberCode(member.getMemberCode());
			// 合作开始日期大于当前日期情况下（合作开始日期+1年）
			if (schools.getEndDate() != null && schools.getEndDate().getTime() > new Date().getTime()) {
				buffer.append("UPDATE sys_member SET member_end_date = DATE_ADD('"
						+ format.format(schools.getStartDate()) + "',INTERVAL 1 YEAR) WHERE id='").append(businessId)
						.append("'");
			} else {
				// 当前日期+一年
				buffer.append("UPDATE sys_member SET member_end_date = DATE_ADD(now(),INTERVAL 1 YEAR) WHERE id='")
						.append(businessId).append("'");
			}
		} else {
			// 截止日期大于当前日期情况下（截止日期+1年）
			if (member.getMemberEndDate().getTime() > new Date().getTime()) {
				buffer.append("UPDATE sys_member SET member_end_date = DATE_ADD('"
						+ format.format(member.getMemberEndDate()) + "',INTERVAL 1 YEAR) WHERE id='").append(businessId)
						.append("'");
			} else {
				// 当前日期+一年
				buffer.append("UPDATE sys_member SET member_end_date = DATE_ADD(now(),INTERVAL 1 YEAR) WHERE id='")
						.append(businessId).append("'");
			}
			// buffer.append("UPDATE sys_member SET member_end_date =
			// DATE_ADD(member_end_date,INTERVAL 1 YEAR) WHERE
			// id='").append(businessId).append("'");
		}
	}

	@Transactional(readOnly = false)
	public User newRegistAndBindMember(String loginName, String memberId) {
		String mobile = loginName;
		Member dbMember = memberService.get(memberId);
		String userType = StringUtils.isBlank(dbMember.getMemberSite()) ? "2" : dbMember.getMemberSite();
		if (dbMember.getUser() != null && StringUtils.isNotBlank(dbMember.getUser().getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前会员存在网站账号ID,请联系技术部处理");
		}
		if (this.bindMobileCheck(mobile, null, null).contains("false")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前手机已被其他用户注册或绑定，不允许重复使用");
		}
		if (memberService.safeMobileCheck(mobile, memberId, userType).contains("false")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前手机已被其他用户注册或绑定，不允许重复使用");
		}
		// 登录名查重
		if (userDao.check("login_name", mobile, userType).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该登录名已存在，请换一个登录名");
		}
		// 添加User记录
		User user = new User();
		user.setLoginName(mobile);
		user.setPassword(MD5Generator.generate16(CheckPswUtil.generateRandomString(8)));
		user.setName(StringUtils.isNotBlank(dbMember.getName()) ? dbMember.getName() : mobile);
		user.setMobile(mobile);
		user.setBindMobile(mobile);
		user.setPhone(mobile);
		user.setUserType(userType);
		user.setMailCheck("0");// 0表示未验证邮箱
		user.setLoginFlag("1");
		user.setTicket(UUID.randomUUID().toString());
		user.setBindMobile(mobile);
		systemService.saveUser(user);
		int row = memberService.updateUserId(user.getId(), dbMember.getMemberCode(), mobile);
		if (row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "创建失败");
		}

		return user;
	}

	/**
	 *
	 * @Description：基于手机号注册宠爱王国账号
	 * @author: zhuoHeng
	 * @version: 2017年5月23日 上午10:28:19
	 */
	@Transactional(readOnly = false)
	public User newRegist(String password, String name, String loginName, String mobile, LoginServer loginServer) {
		return insertUser(password, name, loginName, mobile, loginServer);
	}

	/**
	 *
	 * @Description：基于手机号注册宠爱王国账号和会员
	 * @author: zhuoHeng
	 * @version: 2017年6月2日 下午4:52:59
	 */
	@Transactional(readOnly = false)
	public User newRegistMember(String password, String name, String loginName, String mobile, Member member,
			LoginServer loginServer) {
		User user = insertUser(password, name, loginName, mobile, loginServer);
		member.setUser(user);
		member.setMemberSite(loginServer.getMemberSite());// 会员类型
		memberService.newMemberRegister(member);
		return user;
	}

	/**
	 * @description: 写入User表
	 * @author: laiguanglong
	 * @date: 2018/3/5 11:22
	 */
	@Transactional(readOnly = false)
	private User insertUser(String password, String name, String loginName, String mobile, LoginServer loginServer) {
		// 参数校验
		if (StringUtils.isBlank(password)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码为空");
		}
		if (StringUtils.isBlank(name)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "姓名为空");
		}
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名为空");
		}
		if (StringUtils.isBlank(mobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号为空");
		}
		// 登录名查重
		if (userDao.check("login_name", loginName, loginServer.getUserType()).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该登录名已存在，请换一个登录名");
		}
		// 手机号查重
		/*
		 * if(userDao.check("mobile",mobile).size()>0){ throw new
		 * ZAException(ZAErrorCode.ZA_VALID_FAILED, "该手机号已被使用，请换一个手机号"); }
		 */
		// 添加User记录
		User user = new User();
		user.setLoginName(loginName);
		user.setPassword(MD5Generator.generate16(password));
		user.setName(name);
		user.setMobile(mobile);
		user.setUserType(loginServer.getUserType());
		user.setMailCheck("1");// 0表示未验证邮箱
		user.setLoginFlag("1");
		String ticket = UUID.randomUUID().toString();
		user.setTicket(ticket);
		user.setBindMobile(mobile);
		systemService.saveUser(user);
		return user;
	}

	/**
	 *
	 * @Description：基于手机号注册宠爱王国账号后存储登录信息
	 * @author: zhuoHeng
	 * @version: 2017年5月23日 下午2:56:42
	 */
	@Transactional(readOnly = false)
	public void internalLogin(String loginName, String password, String host, String weixinId,
			LoginServer loginServer) {
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
		}
		User user = new User();
		user = systemService.getUserByLoginNameAndUserType(loginName, loginServer.getUserType());
		// 如果用登录名找不到对应的记录，改用邮箱查询
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, loginServer.getUserType());
			if (user != null) {
				loginName = user.getLoginName();
			}
		}
		if (user == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
		}
		if (!user.getPassword().equals(MD5Generator.generate16(password))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
		}
		if (!"1".equals(user.getLoginFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该帐号未激活，或者不允许登录会员中心");
		}

		// 将用户信息存放到登录信息里
		UsernamePasswordToken token = new UsernamePasswordToken(loginName, password.toCharArray(),
				loginServer.getUserType(), false, host, null, false, loginServer.getUserTypeNameEn());
		SecurityUtils.getSubject().login(token);

		// 更新微信id字段
		if (weixinId != null) {
			if ("".equals(weixinId)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "微信号weixinId为空");
			} else {
				// 更新微信id字段
				user.setWeixinId(weixinId);
				userDao.updateWeixinId(user);
			}
		}
	}

	/**
	 *
	 * @Description：校验用户名是否符合选择的密码找回方式
	 * @author: zhuoHeng
	 * @version: 2017年5月26日 上午11:08:43
	 */
	@Transactional(readOnly = false)
	public RESTResponse validateLoginName(String loginName, String type, LoginServer loginServer) {
		RESTResponse rest = new RESTResponse();
		User user = systemService.getUserByLoginNameAndUserType(loginName, loginServer.getUserType());
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, loginServer.getUserType());
			if (user == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的账号不存在");
			}
		}
		if ("mobile".equals(type)) {
			if (StringUtils.isBlank(user.getBindMobile())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该账号目前不支持此方式找回密码");
			}
		} else if ("mail".equals(type)) {
			if (StringUtils.isBlank(user.getEmail())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该账号目前不支持此方式找回密码");
			} else {
				rest = resetPasswordByEmail(loginName, user.getUserType());
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺失密码找回途径参数");
		}
		return rest;
	}

	/**
	 *
	 * @Description：发送重置密码邮件
	 * @author: zhuoHeng
	 * @version: 2017年5月26日 下午4:15:10
	 */
	@Transactional(readOnly = false)
	public RESTResponse resetPasswordByEmail(String loginName, String userType) {
		User user = systemService.getUserByLoginNameAndUserType(loginName, userType);
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, userType);
			if (user == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的账号不存在");
			}
		}
		String ticket = applyChangePassword(user.getLoginName(), userType);

		emailRemindService.ChangePasswordMail(user, ticket);
		JSONObject jo = new JSONObject();
		String email = user.getEmail();
		String[] emails = email.split("@");
		if (emails[0].length() > 3) {
			email = emails[0].substring(0, 3) + "***" + "@" + emails[1];
		}
		jo.put("email", email);
		return new RESTResponse("data", jo);
	}

	/**
	 *
	 * @Description：session存储找回密码的手机号
	 * @author: zhuoHeng
	 * @version: 2017年5月26日 下午5:14:23
	 */
	public void cacheMobile(String loginName, HttpServletRequest request) {
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		User user = systemService.getUserByLoginNameAndUserType(loginName, loginServer.getUserType());
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, loginServer.getUserType());
			if (user == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的账号不存在");
			} else if (StringUtils.isBlank(user.getBindMobile())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "用户不存在绑定的手机号");
			}
		}
		HttpSession session = request.getSession();
		session.setAttribute("cacheMobile", user.getBindMobile());
		session.setAttribute("cacheId", user.getId());
	}

	/**
	 *
	 * @Description：重置密码
	 * @author: zhuoHeng
	 * @version: 2017年5月31日 下午7:38:37
	 */
	@Transactional(readOnly = false)
	public void resetNewPassword(String id, String newPassword) {
		User user = userDao.get(id);
		if (user != null) {
			systemService.updatePasswordById(user.getId(), user.getLoginName(), newPassword);
		} else if (!CheckPswUtil.checkMemberPassword(newPassword)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_PASSWORD_SIMPLE, "密码太简单，建议密码长度大于8位,使用字母与数字混合，并且尽量不要有连续的数字或字母");
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "修改密码失败");
		}
	}

	/**
	 *
	 * @Description：校验找回密码的用户名是否有效、验证码是否正确
	 * @author: zhuoHeng
	 * @version: 2017年6月5日 下午3:06:27
	 */
	@Transactional(readOnly = false)
	public RESTResponse validateLoginName(HttpServletRequest request) {
		String loginName = request.getParameter("loginName");
		String userType = loginServerService.getLoginServerByUrl(request).getUserType();
		String validateCode = request.getParameter("validateCode");
		// 参数校验
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号为空");
		}
		if (StringUtils.isBlank(validateCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		Session session = UserUtils.getSession();
		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		if (code == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请重新获取验证码");
		}
		// 重置验证码
		session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
		if (!validateCode.toLowerCase().equals(code)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
		}
		User user = systemService.getUserByLoginNameAndUserType(loginName, userType);
		if (user == null) {
			user = UserUtils.getByEmailAndUserType(loginName, userType);
			if (user == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
			}
		}
		return new RESTResponse();
	}

	/**
	 * @description: 验证码校验
	 * @author: laiguanglong
	 * @date: 2017/8/16 18:20
	 */
	public void checkValidateCode(String validateCode) {
		Session session = UserUtils.getSession();
		if (Global.isDevMode() && "6666".equals(validateCode)) {// 不是开发模式，需要校验验证码
			// 重置验证码
			session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
		} else {
			if (StringUtils.isBlank(validateCode)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
			}
			String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
			if (code == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请从新获取验证码");
			}
			if (!validateCode.toLowerCase().equals(code)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
			}
			// 重置验证码
			session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
		}
	}

	/**
	 * @Description： 设置绑定手机
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/20 18:05
	 */
	@Transactional(readOnly = false)
	public void updateBindMobile(User user, String mobile) {
		user.setBindMobile(mobile);
		userDao.updateBindMobile(user);
	}

	/**
	 * @Description： 校验绑定手机号重复验证
	 * 
	 * @author: yuanshuai
	 * @date: 2018/1/4 14:25
	 */
	public String bindMobileCheck(String param, String id, String userType) {
		List<User> userList = userDao.check("bind_mobile", param, userType);
		if (userList.size() > 0) {
			if (id != null) {
				String id2 = userList.get(0).getId();
				if (!id2.equals(id)) {
					return "{\"rc\":false}";
				}
			} else {
				return "{\"rc\":false}";
			}
		}
		return "{\"rc\":true}";
	}

	public List<User> findByIds(List<String> idList) {
		if (CollectionUtils.isEmpty(idList)) {
			return Collections.emptyList();
		}
		return userDao.findByIds(idList);
	}
	
	public Map<String,String> getNameMapByIds(List<String> idList) {
		if(CollectionUtils.isEmpty(idList)) {
			return Maps.newHashMap();
		}
		List<User> list = userDao.findMemberNameByIds(idList);
		return list.stream().collect(Collectors.toMap(User::getId,User::getName));
	}

}
