package com.cku.oa.sys.coupon.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.common.PaymentItemConstant;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderProject;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.dao.SysCouponDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.entity.UserCouponCompose;
import com.cku.oa.sys.coupon.vo.CouponGroupVO;
import com.cku.oa.sys.coupon.vo.SysCouponEntityVO;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.ConstantUtils;
import com.cku.oa.sys.util.PinYinUtil;
import com.cku.restful.v1.sys.model.CouponTypeResponse;
import com.cku.restful.v1.sys.model.RestCouponCompose;
import com.cku.restful.v1.sys.model.RestCouponComposeList;
import com.cku.restful.v1.sys.model.RestCouponComposePost;
import com.cku.restful.v1.sys.model.RestCouponComposePostResponse;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 优惠劵Service
 * 
 * @author 柴雪腾
 * @version 2018-04-12
 */
@Service
@Transactional(readOnly = true)
public class SysCouponService extends CrudService<SysCouponDao, SysCoupon> {
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Autowired
	private MemberDao memberDao;

	public SysCoupon get(String id) {
		return super.get(id);
	}

	public List<SysCoupon> findList(SysCoupon sysCoupon) {
		return super.findList(sysCoupon);
	}

	public Page<SysCoupon> findPage(Page<SysCoupon> page, SysCoupon sysCoupon) {
		return super.findPage(page, sysCoupon);
	}

	@Transactional(readOnly = false)
	public void save(SysCoupon sysCoupon) {
		super.save(sysCoupon);
	}

	@Transactional(readOnly = false)
	public void delete(SysCoupon sysCoupon) {
		super.delete(sysCoupon);
	}

	/**
	 * 查询优惠劵
	 * 
	 * @Author 张向
	 * @2019年2月15日
	 * @param
	 */
	@Transactional(readOnly = false)
	public List<SysCoupon> findCouponList(String memberCode, String state) {
		return dao.findCouponList(memberCode, state);
	}

	/**
	 * 查询优惠劵数量
	 * 
	 * @Author yuanshuai
	 * @date: 2019/10/16 15:09
	 */
	@Transactional(readOnly = false)
	public String findCouponCount(String memberCode, String state) {
		return dao.findCouponCount(memberCode, state);
	}

	public SysCoupon getOneByGroupId(String groupId) {
		List<SysCoupon> couponList = dao.getByGroupId(groupId);
		if (CollectionUtils.isEmpty(couponList)) {
			return null;
		}
		return couponList.get(0);
	}

	public List<SysCoupon> getByGroupId(String groupId) {
		return dao.getByGroupId(groupId);
	}

	/**
	 * 生成优惠劵
	 * 
	 * @Author chaixueteng
	 * @2018年4月12日下午2:55:25
	 * @param
	 */
	@Transactional(readOnly = false)
	public void saveCoupon(String memberCode, String couponName, String facePrice, Date validDate, Date effectiveDate,
			String target, String targetId, String explains, int num, String couponType) {
		try {
			for (int i = 0; i < num; i++) {
				SysCoupon sysCoupon = new SysCoupon();
				sysCoupon.setMemberCode(memberCode);
				sysCoupon.setCouponName(couponName);
				sysCoupon.setFacePrice(facePrice);
				sysCoupon.setValidDate(validDate);
				sysCoupon.setEffectiveDate(effectiveDate);
				sysCoupon.setTarget(target);
				sysCoupon.setCouponCode(SysCodeUtil.getCouponCode());
				sysCoupon.setUseState("0");// 使用状态
				sysCoupon.setTargetId(targetId);//
				sysCoupon.setCouponType(couponType);
				if ("Y".equals(explains)) {// 传"Y"默认说明为 "仅限本人使用不可转让"
					sysCoupon.setExplains("仅限本人使用不可转让");
				} else {
					sysCoupon.setExplains(explains);
				}
				super.save(sysCoupon);
			}
		} catch (Exception e) {
			logger.info("保存失败", e);
			throw new ZAException(ZAErrorCode.ZA_ERROR, "优惠券保存失败");

		}
	}

	@Transactional(readOnly = false)
	public void saveCouponCompose(String memberCode, String couponName, String facePrice, Date validDate,
			Date effectiveDate, String target, String targetId, String explains, int num, String couponType,
			String useState, String runningNumber, String userComposeId, String remarks) {
		try {
			for (int i = 0; i < num; i++) {
				SysCoupon sysCoupon = new SysCoupon();
				sysCoupon.setMemberCode(memberCode);
				sysCoupon.setCouponName(couponName);
				sysCoupon.setFacePrice(facePrice);
				sysCoupon.setValidDate(validDate);
				sysCoupon.setEffectiveDate(effectiveDate);
				sysCoupon.setTarget(target);
				sysCoupon.setCouponCode(SysCodeUtil.getCouponCode());
				sysCoupon.setUseState("0");// 使用状态
				sysCoupon.setTargetId(targetId);//
				sysCoupon.setCouponType(couponType);
				sysCoupon.setUseState(useState);
				sysCoupon.setRunningNumber(runningNumber);
				sysCoupon.setUserCouponComposeId(userComposeId);
				sysCoupon.setRemarks(remarks);
				if ("Y".equals(explains)) {// 传"Y"默认说明为 "仅限本人使用不可转让"
					sysCoupon.setExplains("仅限本人使用不可转让");
				} else {
					sysCoupon.setExplains(explains);
				}
				super.save(sysCoupon);
			}
		} catch (Exception e) {
			logger.info("保存失败", e);
			throw new ZAException(ZAErrorCode.ZA_ERROR, "优惠券保存失败");

		}
	}

	/**
	 * 生成优惠劵
	 * 
	 * @Author chaixueteng
	 * @2018年4月12日下午2:55:25
	 * @param
	 */
	@Transactional(readOnly = false)
	public SysCoupon saveCoupon(String memberCode, String couponName, String facePrice, Date validDate, Date effDate,
			String target, String targetId, String explains, int num, String couponType, String couponDefId) {
		SysCoupon sysCoupon = null;
		try {
			for (int i = 0; i < num; i++) {
				sysCoupon = new SysCoupon();
				sysCoupon.setMemberCode(memberCode);
				sysCoupon.setCouponName(couponName);
				sysCoupon.setFacePrice(facePrice);
				sysCoupon.setValidDate(validDate);
				sysCoupon.setEffectiveDate(effDate);
				sysCoupon.setTarget(target);
				sysCoupon.setCouponCode(SysCodeUtil.getCouponCode());
				sysCoupon.setUseState("0");// 使用状态
				sysCoupon.setTargetId(targetId);//
				sysCoupon.setCouponType(couponType);
				if ("Y".equals(explains)) {// 传"Y"默认说明为 "仅限本人使用不可转让"
					sysCoupon.setExplains("仅限本人使用不可转让");
				} else {
					sysCoupon.setExplains(explains);
				}
				sysCoupon.setCouponDefId(couponDefId);
				super.save(sysCoupon);
			}
		} catch (Exception e) {
			logger.info("保存失败", e);
			throw new ZAException(ZAErrorCode.ZA_ERROR, "优惠券保存失败");

		}
		return sysCoupon;
	}

	/**
	 * 构造优惠劵
	 * 
	 * @Author chaixueteng
	 * @2018年4月12日下午2:55:25
	 * @param
	 */
	public void buildCoupon(List<DogBirthCertificate> poList, int num) {
		Member member = UserUtils.getLoginMember();
		List<SysCoupon> list = dao.findCouponListByTarget(member.getMemberCode(), "0", "dogBirthCertificate");
		for (int i = 0; i < num; i++) {
			SysCoupon sc = list.get(i);
			sc.setTargetId(poList.get(0).getFmdogBreedCertifiedCode());
			sc.setUseState("1");// 改为已使用
			dao.update(sc);
		}
	}

	/**
	 * 构造参赛券
	 * 
	 * @Author zhangxiang
	 * @2019年2月14日 10:20
	 * @param
	 */
	public void buildCouponState(Dog dog, ShowApply showApply, int num) {
		Member member = UserUtils.getLoginMember();
		SysCoupon sysCoupon = new SysCoupon();
		sysCoupon.setMemberCode(member.getMemberCode());
		sysCoupon.setState("0");// 可用的
		sysCoupon.setTargetId(dog.getPedigreeCertifiedCode());
		List<SysCoupon> list = super.findList(sysCoupon);
		for (int i = 0; i < num; i++) {
			// showApply.getId()+"#"+
			SysCoupon sc = list.get(i);
			sc.setUseState("1");// 改为已使用
			sc.setTargetId(showApply.getId() + "#" + dog.getPedigreeCertifiedCode());
			dao.update(sc);
		}
	}

	@Transactional(readOnly = false)
	public void updateMemberCode(SysCoupon sysCoupon) {
		dao.updateMemberCode(sysCoupon);
	}

	public SysCoupon getByTargetId(String targetId) {
		List<SysCoupon> couponList = dao.getByTargetId(targetId);
		if (Collections3.isEmpty(couponList)) {
			return null;
		}
		return couponList.get(0);
	}

	public PaymentCart buildPaymentCart(SysCoupon po, String shortName, String businessOrderCode, String memberCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("sys_coupon");
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setBusinessIds(po.getTargetId());
		paymentCart.setMemberCode(memberCode);
		return paymentCart;
	}

	public List<SysCouponEntityVO> findAvailableListCouponList(String memberCode) {
		return dao.findAvailableListCouponList(memberCode);
	}

	/**
	 * 按照类型 查询优惠劵
	 * 
	 * @Author 张向
	 * @2019年2月15日
	 * @param
	 */
	@Transactional(readOnly = false)
	public List<SysCoupon> findCouponListByTarget(String memberCode, String state, String target) {
		return dao.findCouponListByTarget(memberCode, state, target);
	}

	@Transactional(readOnly = false)
	public void saveNum(SysCoupon sysCoupon) {
		for (int i = 0; i < sysCoupon.getNum(); i++) {
			SysCoupon sysCoupon1 = new SysCoupon();
			BeanUtils.copyProperties(sysCoupon, sysCoupon1);
			if ("dogvideo".equals(sysCoupon1.getCouponName())) {
				sysCoupon1.setCouponType("1");
				sysCoupon1.setFacePrice("288");
				sysCoupon1.setTarget("dogvideo");
				sysCoupon1.setCouponName("视频鉴定抵扣券");
			} else if ("memberdog".equals(sysCoupon1.getCouponName())) {
				sysCoupon1.setCouponType("1");
				sysCoupon1.setFacePrice("50");
				sysCoupon1.setTarget("memberdog");
				sysCoupon1.setCouponName("代金券");
			}

			sysCoupon1.setUseState("0");
			sysCoupon1.setCouponCode(SysCodeUtil.getCouponCode());
			sysCoupon1.setId(IdGen.uuid());
			User user = UserUtils.getUser();
			sysCoupon1.setUpdateBy(user);
			sysCoupon1.setUpdateDate(new Date());
			sysCoupon1.setCreateDate(new Date());
			sysCoupon1.setCreateBy(user);
			dao.insert(sysCoupon1);
		}
	}

	@Transactional(readOnly = false)
	public List<SysCoupon> getListByCouponDefId(String[] ids) {
		return dao.getListByCouponDefId(ids);

	}

	@Transactional(readOnly = false)
	public SysCoupon getCouponAndCheck(String couponId) throws Exception {
		SysCoupon coupon = get(couponId);
		if (coupon == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "券ID不对！");
		}
		Date now = new Date();
		if (!("0".equals(coupon.getUseState())
				&& ((coupon.getEffectiveDate() == null || (!now.before(coupon.getEffectiveDate())))
						&& (coupon.getValidDate() == null || (!now.after(coupon.getValidDate())))))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "券不能使用！");
		}
		return coupon;
	}

	/**
	 * 查询优惠包列表
	 */
	public ResultDto<RestCouponComposeList> composeList(String composeType) {
		Member member = UserUtils.getLoginMember();
		// 马犬不粘死
		boolean show = true;
		if (member.getMemberCode().startsWith("MC")) {
			show = false;
		}
		Map<String, List<RestCouponCompose>> map = new HashMap<>();
		List<RestCouponCompose> list = dao.composeList(composeType);
		list.forEach(item -> {
			if ("2".equals(item.getId()) || "4".equals(item.getId())) {
				item.setRecommend(Boolean.TRUE);
			}
		});
		list.stream().collect(Collectors.groupingBy(RestCouponCompose::getComposeType, Collectors.toList()))
				.forEach(map::put);
		RestCouponComposeList result = RestCouponComposeList.builder().certificates(map.get("certificate"))
				.registers(map.get("register")).show(show).build();

		return ResultDto.success(result);
	}

	@Transactional
	public ResultDto<RestCouponComposePostResponse> composePost(RestCouponComposePost vo) {
		Member member = UserUtils.getLoginMember();
		Integer cardType = UserUtils.getMemberCardType(member);
		String composeId = vo.getId();
		// 登记卡:铂金卡及紫金卡可购买
		if ("1".equals(composeId) || "2".equals(composeId)) {
			if (cardType < CardTypeEnum.PLATINUM_CARD.code()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "铂金卡及紫金卡会员可购买使用！");
			}
		}
		// 血统证书: 银卡及银卡以上可购买
		if ("3".equals(composeId) || "4".equals(composeId)) {
			if (cardType < CardTypeEnum.SILVER_CARD.code()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "银卡及银卡会员以上可购买使用！");
			}
		}
		// 写入业务
		UserCouponCompose userCompose = saveCouponCompose(composeId, member, 0, "");
		// 写入购物车
		List<PaymentCart> carts = buildCartIds(composeId, userCompose);

		return ResultDto.success(buildResp(carts, vo));
	}

	private RestCouponComposePostResponse buildResp(List<PaymentCart> carts, RestCouponComposePost vo) {
		StringBuffer cartIds = new StringBuffer();
		BigDecimal bd = new BigDecimal(0);
		for (PaymentCart cart : carts) {
			cartIds.append(cart.getId() + ",");
			bd = bd.add(new BigDecimal(cart.getTotalPrice()));
		}
		String ids = cartIds.toString().endsWith(",") ? cartIds.toString().substring(0, cartIds.length() - 1)
				: cartIds.toString();
		String originalPrice = "", composeType = "", composeDesc = "", couponPrice = "";
		switch (vo.getId()) {
		case "1":
			originalPrice = "1000";
			composeType = "登记卡抵扣券套餐B";
			couponPrice = "100";
			composeDesc = "登记卡抵扣券";
			break;
		case "2":
			originalPrice = "3000";
			composeType = "登记卡抵扣券套餐A";
			couponPrice = "100";
			composeDesc = "登记卡抵扣券";
			break;
		case "3":
			originalPrice = "2000";
			composeType = "血统证书抵扣券套餐B";
			couponPrice = "400";
			composeDesc = "血统证书抵扣券";
			break;
		case "4":
			originalPrice = "4000";
			composeType = "血统证书抵扣券套餐A";
			couponPrice = "400";
			composeDesc = "血统证书抵扣券";
			break;
		default:
			break;
		}
		RestCouponComposePostResponse resp = RestCouponComposePostResponse.builder().cartId(ids)
				.price(bd.toPlainString()).originalPrice(originalPrice).num(carts.get(0).getNum())
				.composeDesc(composeDesc).composeType(composeType).couponPrice(couponPrice).build();
		return resp;
	}

	/**
	 * 保存用户购买优惠包记录
	 * 
	 * @param composeId 购买记录id
	 * @param member    用户
	 * @param useNum    已使用次数
	 * @param target    使用对象
	 * @return
	 */
	@Transactional
	public UserCouponCompose saveCouponCompose(String composeId, Member member, int useNum, String target) {
		RestCouponCompose couponCompose = dao.getComposeById(composeId);
		if (Objects.isNull(couponCompose)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠包信息不存在");
		}
		String id = IdGen.uuid();
		UserCouponCompose obj = new UserCouponCompose();
		obj.setId(id);
		obj.setComposeId(composeId);
		obj.setMemberCode(member.getMemberCode());
		obj.setPaymentState("1");
		obj.setCreateDate(new Date());
		obj.setTarget(target);
		obj.setUseNum(useNum);
		dao.saveCouponCompose(obj);
		return obj;
	}

	public List<PaymentCart> buildCartIds(String composeId, UserCouponCompose userCompose) {
		String businessOrderCode = IdGen.uuid();
		return buildComposePaymentCart(composeId, businessOrderCode, userCompose);
	}

	private List<PaymentCart> buildComposePaymentCart(String composeId, String businessOrderCode,
			UserCouponCompose userCompose) {
		List<PaymentCart> carts = new ArrayList<>();
		/**
		 * 1:登记卡X10 2:登记卡X30 3:血统证书X5 4:血统证书X10
		 */
		switch (composeId) {
		case "1":
			// 登记卡优惠包*10（建档服务费）
			PaymentCart registerArchivesCart10 = buildCart(PaymentItemConstant.ARCHIVES_COMPOSE_10, businessOrderCode,
					userCompose.getId(), 10);
			carts.add(registerArchivesCart10);
			// 登记卡优惠包*10（芯片费）
			PaymentCart chipCart10 = buildCart(PaymentItemConstant.CHIP_COMPOSE, businessOrderCode, userCompose.getId(),
					10);
			carts.add(chipCart10);
			break;
		case "2":
			// 登记卡优惠包*30（建档服务费）
			PaymentCart registerArchivesCart30 = buildCart(PaymentItemConstant.ARCHIVES_COMPOSE_30, businessOrderCode,
					userCompose.getId(), 30);
			carts.add(registerArchivesCart30);
			// 登记卡优惠包*30（芯片费）
			PaymentCart chipCart30 = buildCart(PaymentItemConstant.CHIP_COMPOSE, businessOrderCode, userCompose.getId(),
					30);
			carts.add(chipCart30);
			break;
		case "3":
			// 血统证书优惠包*5（建档服务费）
			PaymentCart certificateArchivesCart5 = buildCart(PaymentItemConstant.CERTIFICATE_ARCHIVES_COMPOSE_5,
					businessOrderCode, userCompose.getId(), 5);
			carts.add(certificateArchivesCart5);
			// 血统证书优惠包*5（信息管理费）
			PaymentCart infor5 = buildCart(PaymentItemConstant.INFOR_COMPOSE, businessOrderCode, userCompose.getId(),
					5);
			carts.add(infor5);
			// 血统证书优惠包*5（鼻纹登记服务费）
			PaymentCart nose5 = buildCart(PaymentItemConstant.DOG_NOSE_COMPOSE, businessOrderCode, userCompose.getId(),
					5);
			carts.add(nose5);
			// 血统证书优惠包*5（新生犬CKU血统证书费）
			PaymentCart cku5 = buildCart(PaymentItemConstant.CKU_COMPOSE, businessOrderCode, userCompose.getId(), 5);
			carts.add(cku5);
			break;
		case "4":
			// 血统证书优惠包*10（建档服务费）
			PaymentCart certificateArchivesCart10 = buildCart(PaymentItemConstant.CERTIFICATE_ARCHIVES_COMPOSE_10,
					businessOrderCode, userCompose.getId(), 10);
			carts.add(certificateArchivesCart10);
			// 血统证书优惠包*10（信息管理费）
			PaymentCart infor10 = buildCart(PaymentItemConstant.INFOR_COMPOSE, businessOrderCode, userCompose.getId(),
					10);
			carts.add(infor10);
			// 血统证书优惠包*10（鼻纹登记服务费）
			PaymentCart nose10 = buildCart(PaymentItemConstant.DOG_NOSE_COMPOSE, businessOrderCode, userCompose.getId(),
					10);
			carts.add(nose10);
			// 血统证书优惠包*10（新生犬CKU血统证书费）
			PaymentCart cku10 = buildCart(PaymentItemConstant.CKU_COMPOSE, businessOrderCode, userCompose.getId(), 10);
			carts.add(cku10);
			break;
		default:
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数错误!");
		}
		return carts;
	}

	private PaymentCart buildCart(String shortName, String businessOrderCode, String businessId, int num) {
		PaymentCart cart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = getCounpoComposeItem(shortName);
		cart.setChargingItemId(paymentChargingItem.getId());
		cart.setChargingItemName(paymentChargingItem.getName());
		cart.setNum(String.valueOf(num));
		cart.setPrice(paymentChargingItem.getPrice());
		cart.setTotalPrice(String.valueOf(Double.parseDouble(paymentChargingItem.getPrice()) * num));
		cart.setBusinessOrderCode(businessOrderCode);
		cart.setBusinessTable("user_coupon_compose");
		cart.setBusinessIds(businessId);
		PaymentCartService paymentCartService = (PaymentCartService) SpringContextHolder.getBean("paymentCartService");
		paymentCartService.addToCart(cart, "1201");
		return cart;
	}

	public PaymentChargingItem getCounpoComposeItem(String shorName) {
		return paymentChargingItemService.getByShortName(shorName);
	}

	public RestCouponCompose getComposeById(String id) {
		return dao.getComposeById(id);
	}

	public Page<CouponGroupVO> findGroupPage(Page<SysCoupon> page, SysCoupon entity) {
		Page<CouponGroupVO> resultPage = new Page<CouponGroupVO>();
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		entity.setPage(page);
		resultPage.setList(dao.findGroupList(entity));
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			resultPage.setList(new ArrayList<CouponGroupVO>(0));
		}
		resultPage.setCount(page.getCount());
		return resultPage;
	}

	/**
	 * 发放优惠券
	 */
	@Transactional
	public void sendCouponCompose(String userComposeId) {
		// 查询购买记录
		UserCouponCompose userCompose = dao.getUserComposeById(userComposeId);
		String couponName = "", target = "", explains = "", reamrks = "";
		if ("1".equals(userCompose.getComposeId()) || "2".equals(userCompose.getComposeId())) {
			couponName = "登记卡抵扣券";
			target = ConstantUtils.COUPON_TARGET_DOGBIRTHCERTIFICATE;
			explains = "购买后一年内有效";
			reamrks = "1".equals(userCompose.getComposeId()) ? "登记卡950优惠包-10张" : "登记卡2700优惠包-30张";
		}
		if ("3".equals(userCompose.getComposeId()) || "4".equals(userCompose.getComposeId())) {
			couponName = "血统证书抵扣券";
			target = ConstantUtils.COUPON_TARGET_DOGCHIPAPPLY;
			explains = "仅限12月龄以内犬只可用,购买后一年内有效";
			reamrks = "3".equals(userCompose.getComposeId()) ? "血统证书1750优惠包-5张" : "血统证书3200优惠包-10张";
		}

		Calendar calendar = Calendar.getInstance();
		calendar.setTime(new Date());
		calendar.add(Calendar.YEAR, 1);
		String validDate = DateUtils.formatDate(calendar.getTime(), "yyyy-MM-dd 00:00:00");
		// 未使用
		for (int i = 0; i < userCompose.getNum() - userCompose.getUseNum(); i++) {
			saveCouponCompose(userCompose.getMemberCode(), couponName, userCompose.getFacePrice(),
					DateUtils.parseDate(validDate), new Date(), target, "", explains, 1, "2", "0", "", userComposeId,
					reamrks);
		}
		// 已使用
		if (userCompose.getUseNum() > 0) {
			String[] targetIds = userCompose.getTarget().split(",");
			for (int i = 0; i < userCompose.getUseNum(); i++) {
				saveCouponCompose(userCompose.getMemberCode(), couponName, userCompose.getFacePrice(),
						DateUtils.parseDate(validDate), new Date(), target, targetIds[i], explains, 1, "2", "1",
						userCompose.getRunningNumber(), userComposeId, reamrks);
			}
		}

	}

	/**
	 * 获取券类型
	 */
	public ListResultDto<CouponTypeResponse> getCouponType() {
		List<CouponTypeResponse> respList = new ArrayList<>();
		List<Dict> dictList = DictUtils.getDictList("coupon_type");
		dictList.forEach(item -> {
			CouponTypeResponse resp = new CouponTypeResponse();
			resp.setLabel(item.getLabel());
			resp.setValue(item.getValue());
			respList.add(resp);
		});

		return ListResultDto.success(respList);
	}

	public List<CouponGroupVO> findGroupList(SysCoupon entity) {
		return dao.findGroupList(entity);
	}

	public List<SysCoupon> getListByIds(String memberCode, List<String> ids) {
		return dao.getListByIds(memberCode, ids);
	}

	public void buildUseCoupon(List<SysCoupon> list, String targetId) {
		list.stream().forEach(a -> {
			a.setTargetId(targetId);
			a.setUseState("1");// 改为已使用
			dao.update(a);
		});
	}

	public static void main(String[] args) {
		Calendar now = Calendar.getInstance();
		Date effDate = now.getTime();
		now.add(Calendar.MONTH, 12);
		Date validDate = now.getTime();

		Calendar now1 = new GregorianCalendar();

		now1.setTime(validDate);
		now1.add(Calendar.DATE, 1);
		validDate = now1.getTime();

		String eff = DateUtils.formatDate(effDate, "yyyy-MM-dd");
		String valid = DateUtils.formatDate(validDate, "yyyy-MM-dd");

		boolean flag = validDate.after(effDate);
		System.out.println(flag);

		System.out.println(eff + " " + valid);

	}

	public Integer findExpireNum(SysCoupon sysCoupon) {
		return dao.findExpireNum(sysCoupon);
	}

	public UserCouponCompose getUserComposeById(String id) {
		return dao.getUserComposeById(id);
	}

	public String importFileTemplate(HttpServletResponse response) throws IOException {
		String fileName = "优惠券数据导入模板.xlsx";
		List<SysCoupon> list = Lists.newArrayList();
		SysCoupon coupon = new SysCoupon();
		coupon.setMemberCode("会员号");
		coupon.setCouponName("代金券");
		coupon.setFacePrice("50");
		coupon.setCouponNum(1);
		coupon.setEffectiveDate(new Date());
		coupon.setValidDate(new Date());
		list.add(coupon);
		new ExportExcel("优惠券信息", SysCoupon.class, 2).setDataList(list).write(response, fileName).dispose();
		return null;
	}

	@Transactional(readOnly = false)
	public void importCoupon(MultipartFile file)
			throws InvalidFormatException, IOException, IllegalAccessException, InstantiationException {
		ImportExcel ei = new ImportExcel(file, 1, 0);
		List<SysCoupon> list = ei.getDataList(SysCoupon.class);
		boolean error = false;
		StrBuilder strBuilder = new StrBuilder();
		for (SysCoupon coupon : list) {
			if (StringUtils.isBlank(coupon.getMemberCode()) && StringUtils.isBlank(coupon.getMemberCode())
					&& StringUtils.isBlank(coupon.getFacePrice())) {
				continue;
			}

			if (StringUtils.isBlank(coupon.getMemberCode())) {
				error = recordError(strBuilder, "会员号不能为空");
			}

			if (StringUtils.isBlank(coupon.getCouponName())) {
				error = recordError(strBuilder, "优惠劵名称不能为空");
			}

			if (StringUtils.isBlank(coupon.getFacePrice())) {
				error = recordError(strBuilder, "优惠劵面值不能为空");
			}

			if (coupon.getNum() == null) {
				error = recordError(strBuilder, "优惠劵数量不能为空");
			}

			if (coupon.getValidDate() == null) {
				error = recordError(strBuilder, "优惠券有效期不能为空");
			}

			if (coupon.getEffectiveDate() == null) {
				error = recordError(strBuilder, "优惠券生效日期不能为空");
			}

			Calendar calendar = new GregorianCalendar();
			calendar.setTime(coupon.getValidDate());
			calendar.add(Calendar.DATE, 1);
			Date vaildate = calendar.getTime();
			if (!vaildate.after(coupon.getEffectiveDate())) {
				error = recordError(strBuilder, "优惠券生效日期不能晚于有效期");
			}

			if (!"50".equals(coupon.getFacePrice())) {
				error = recordError(strBuilder, "仅支持50元面值代金劵");
			}

			Member member = memberDao.getByMemberCode(coupon.getMemberCode());
			if (member == null) {
				error = recordError(strBuilder, "会员:" + coupon.getMemberCode() + "不存在");
			}

			coupon.setExplains("限办理CKU会员业务、繁殖业务使用");
			coupon.setCouponName("memberdog");
			if (!error) {
				saveNum(coupon);
			}

		}
		if (error) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, strBuilder.toString());
		}
	}

	private boolean recordError(StrBuilder strBuilder, String msg) {
		strBuilder.append(msg).append("##");
		return true;
	}

}