package com.cku.oa.statistics.web;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.shop.entity.ShopGoods;
import com.cku.oa.shop.service.ShopGoodsService;
import com.cku.oa.statistics.dao.ShopGoodsStatisticsDao;
import com.thinkgem.jeesite.common.persistence.Page;

/**
 * 商城统计
 *user chaixueteng
 *2016年12月19日
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/shop")
public class ShopGoodsStatisticsController {
	
	@Autowired
	public ShopGoodsStatisticsDao shopGoodsStatisticsDao;
	@Autowired
	public ShopGoodsService shopGoodsService;
	
	/**
	 * 商城销售统计
	 * @throws ParseException 
	 */
	
	@RequestMapping(value = "shopStatistics")
	public String shopStatistics(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			String name=request.getParameter("name");
			String isOnSubmit = request.getParameter("isOnSubmit");
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			
			if(isOnSubmit == null || isOnSubmit.equals(""))
			{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";	
			}
			
			List<ShopGoods> list = shopGoodsService.findList(new ShopGoods());
			model.addAttribute("list",list);
			if(StringUtils.isNotBlank(name)){
				ShopGoods shopGoods = shopGoodsService.get(name);
				model.addAttribute("selectedName",shopGoods.getName());
			}
			model.addAttribute("selectedId",name);	
			//统计商品每个品种的销售信息
			List<Map> results = shopGoodsStatisticsDao.countByDate(startDate,endDate,name);
			System.out.println(results.size());
			//往页面传值
			model.addAttribute("results",results);			
			model.addAttribute("startDate",startDate);
			model.addAttribute("endDate",endDate);
			model.addAttribute("name",name);
			Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
			 //你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
			page.setCount(results.size());
			page.initialize();//重新计算页码信息
			model.addAttribute("page",page);
			//退回商品
		List<Map> countReBack = shopGoodsStatisticsDao.countReBack(startDate,endDate,name);
		model.addAttribute("reback",countReBack);
			return "oa/statistics/shop/shopStatistics";	
	}
}
