package com.cku.oa.shop.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.shop.entity.ShopGoodsClass;
import com.cku.oa.shop.service.ShopGoodsClassService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.shop.entity.ShopGoods;
import com.cku.oa.shop.service.ShopGoodsService;

import java.util.List;

/**
 * 商品管理Controller
 * @author lyy
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "${adminPath}/shop/shopGoods")
public class ShopGoodsController extends BaseController {

	@Autowired
	private ShopGoodsService shopGoodsService;
	@Autowired
	private ShopGoodsClassService shopGoodsClassService;
	
	@ModelAttribute
	public ShopGoods get(@RequestParam(required=false) String id) {
		ShopGoods entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = shopGoodsService.get(id);
		}
		if (entity == null){
			entity = new ShopGoods();
		}
		return entity;
	}
	
	@RequiresPermissions("shop:shopGoods:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShopGoods shopGoods, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShopGoods> page = shopGoodsService.findPage(new Page<ShopGoods>(request, response), shopGoods); 
		model.addAttribute("page", page);
		List<ShopGoodsClass> list = shopGoodsClassService.findAllList(new ShopGoodsClass());
		model.addAttribute("chassList",list);
		return "oa/shop/shopGoodsList";
	}

	@RequiresPermissions("shop:shopGoods:view")
	@RequestMapping(value = "form")
	public String form(ShopGoods shopGoods, Model model) {
		model.addAttribute("shopGoods", shopGoods);
		List<ShopGoodsClass> list = shopGoodsClassService.findAllList(new ShopGoodsClass());
		model.addAttribute("chassList",list);
		return "oa/shop/shopGoodsForm";
	}
	@RequiresPermissions("shop:shopGoods:view")
	@RequestMapping(value = "view")
	public String view(ShopGoods shopGoods, Model model) {
		model.addAttribute("shopGoods", shopGoods);
		return "oa/shop/shopGoodsView";
	}
	@RequiresPermissions("shop:shopGoods:view")
	@RequestMapping(value = "save")
	public String save(ShopGoods shopGoods, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(!StringUtils.isEmpty(shopGoods.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("shop:shopGoods:edit");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("shop:shopGoods:add");
		}
		if(hasPermission){
			if (!beanValidator(model, shopGoods)){
				return form(shopGoods, model);
			}
			shopGoodsService.save(shopGoods);
			addMessage(redirectAttributes, "保存商品成功");
		}else{
			throw new UnauthenticatedException();
		}
		return "redirect:"+Global.getAdminPath()+"/shop/shopGoods/?repage";
	}


	@RequiresPermissions("shop:shopGoods:edit")
	@RequestMapping(value = "delImg")
	public String delImg(String id,String imgId, Model model) {
		ShopGoods shopGoods = shopGoodsService.delImg(id,imgId);
		model.addAttribute("shopGoods", shopGoods);
		List<ShopGoodsClass> list = shopGoodsClassService.findAllList(new ShopGoodsClass());
		model.addAttribute("chassList",list);
		return "oa/shop/shopGoodsForm";
	}
	@RequiresPermissions("shop:shopGoods:delete")
	@RequestMapping(value = "delete")
	public String delete(ShopGoods shopGoods, RedirectAttributes redirectAttributes) {
		shopGoodsService.delete(shopGoods);
		addMessage(redirectAttributes, "删除商品成功");
		return "redirect:"+Global.getAdminPath()+"/shop/shopGoods/?repage";
	}

	@RequiresPermissions("shop:shopGoods:export")
	@RequestMapping("export")
	public String export(ShopGoods shopGoods,HttpServletResponse response, RedirectAttributes redirectAttributes){
		try {
			shopGoodsService.export(shopGoods,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出商城商品失败！失败信息："+e.getMessage());
		}
		return null;
	}
	@RequiresPermissions("shop:shopGoods:import")
	@RequestMapping(value = "import", method= RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			shopGoodsService.importGoods(file);
			addMessage(redirectAttributes,"导入商城商品成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入商城商品失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/shop/shopGoods/?repage";
	}
}