/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.web;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.shop.entity.ShopGoodsClass;
import com.cku.oa.shop.service.ShopGoodsClassService;

/**
 * 商品类别Controller
 * @author lyy
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "${adminPath}/shop/shopGoodsClass")
public class ShopGoodsClassController extends BaseController {

	@Autowired
	private ShopGoodsClassService shopGoodsClassService;
	
	@ModelAttribute
	public ShopGoodsClass get(@RequestParam(required=false) String id) {
		ShopGoodsClass entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = shopGoodsClassService.get(id);
		}
		if (entity == null){
			entity = new ShopGoodsClass();
		}
		return entity;
	}
	
	@RequiresPermissions("shop:shopGoodsClass:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShopGoodsClass shopGoodsClass, HttpServletRequest request, HttpServletResponse response, Model model) {
		List<ShopGoodsClass> list = shopGoodsClassService.findList(shopGoodsClass); 
		model.addAttribute("list", list);
		return "oa/shop/shopGoodsClassList";
	}

	@RequiresPermissions("shop:shopGoodsClass:view")
	@RequestMapping(value = "form")
	public String form(ShopGoodsClass shopGoodsClass, Model model) {
		if (shopGoodsClass.getParent()!=null && StringUtils.isNotBlank(shopGoodsClass.getParent().getId())){
			shopGoodsClass.setParent(shopGoodsClassService.get(shopGoodsClass.getParent().getId()));
			// 获取排序号，最末节点排序号+30
			if (StringUtils.isBlank(shopGoodsClass.getId())){
				ShopGoodsClass shopGoodsClassChild = new ShopGoodsClass();
				shopGoodsClassChild.setParent(new ShopGoodsClass(shopGoodsClass.getParent().getId()));
				List<ShopGoodsClass> list = shopGoodsClassService.findList(shopGoodsClass); 
				if (list.size() > 0){
					shopGoodsClass.setSort(list.get(list.size()-1).getSort());
					if (shopGoodsClass.getSort() != null){
						shopGoodsClass.setSort(shopGoodsClass.getSort() + 30);
					}
				}
			}
		}
		if (shopGoodsClass.getSort() == null){
			shopGoodsClass.setSort(30);
		}
		model.addAttribute("shopGoodsClass", shopGoodsClass);
		return "oa/shop/shopGoodsClassForm";
	}

	@RequiresPermissions("shop:shopGoodsClass:view")
	@RequestMapping(value = "save")
	public String save(ShopGoodsClass shopGoodsClass, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(!StringUtils.isEmpty(shopGoodsClass.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("shop:shopGoodsClass:edit");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("shop:shopGoodsClass:add");
		}
		if(hasPermission){
			if (!beanValidator(model, shopGoodsClass)){
				return form(shopGoodsClass, model);
			}
			shopGoodsClassService.save(shopGoodsClass);
			addMessage(redirectAttributes, "保存商品类别成功");
		}else{
			throw new UnauthenticatedException();
		}
		return "redirect:"+Global.getAdminPath()+"/shop/shopGoodsClass/?repage";
	}
	
	@RequiresPermissions("shop:shopGoodsClass:delete")
	@RequestMapping(value = "delete")
	public String delete(ShopGoodsClass shopGoodsClass, RedirectAttributes redirectAttributes) {
		shopGoodsClassService.delete(shopGoodsClass);
		addMessage(redirectAttributes, "删除商品类别成功");
		return "redirect:"+Global.getAdminPath()+"/shop/shopGoodsClass/?repage";
	}

	@RequiresPermissions("user")
	@ResponseBody
	@RequestMapping(value = "treeData")
	public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, HttpServletResponse response) {
		List<Map<String, Object>> mapList = Lists.newArrayList();
		List<ShopGoodsClass> list = shopGoodsClassService.findList(new ShopGoodsClass());
		for (int i=0; i<list.size(); i++){
			ShopGoodsClass e = list.get(i);
			if (StringUtils.isBlank(extId) || (extId!=null && !extId.equals(e.getId()) && e.getParentIds().indexOf(","+extId+",")==-1)){
				Map<String, Object> map = Maps.newHashMap();
				map.put("id", e.getId());
				map.put("pId", e.getParentId());
				map.put("name", e.getName());
				mapList.add(map);
			}
		}
		return mapList;
	}
	
}