package com.cku.oa.sampling.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.sampling.entity.SamplingFlowLog;
import com.cku.oa.sampling.service.SamplingFlowLogService;

/**
 * 采样包流程日志Controller
 *
 * @author yuanshuai
 * @version 2023-05-22
 */
@Controller
@RequestMapping(value = "${adminPath}/samplingFlowLog/samplingFlowLog")
public class SamplingFlowLogController extends BaseController {

	@Autowired
	private SamplingFlowLogService samplingFlowLogService;

	@ModelAttribute
	public SamplingFlowLog get(@RequestParam(required = false) String id) {
		SamplingFlowLog entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = samplingFlowLogService.get(id);
		}
		if (entity == null) {
			entity = new SamplingFlowLog();
		}
		return entity;
	}

	@RequiresPermissions("sampling:samplingFlowLog:view")
	@RequestMapping(value = {"list", ""})
	public String list(SamplingFlowLog samplingFlowLog, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SamplingFlowLog> page = samplingFlowLogService.findPage(new Page<>(request, response), samplingFlowLog);
		model.addAttribute("page", page);
		return "oa/samplingFlowLog/samplingFlowLogList";
	}

	@RequiresPermissions("sampling:samplingFlowLog:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(SamplingFlowLog samplingFlowLog, Model model) {
		model.addAttribute("isView", 1);
		model.addAttribute("samplingFlowLog", samplingFlowLog);
		return "oa/samplingFlowLog/samplingFlowLogForm";
	}

	@RequiresPermissions("sampling:samplingFlowLog:edit")
	@RequestMapping(value = "editForm")
	public String editForm(SamplingFlowLog samplingFlowLog, Model model) {
		model.addAttribute("isView", 0);
		model.addAttribute("samplingFlowLog", samplingFlowLog);
		return "oa/samplingFlowLog/samplingFlowLogForm";
	}

	@RequiresPermissions("sampling:samplingFlowLog:edit")
	@RequestMapping(value = "save")
	public String save(SamplingFlowLog samplingFlowLog, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, samplingFlowLog)) {
			return editForm(samplingFlowLog, model);
		}
		samplingFlowLogService.save(samplingFlowLog);
		addMessage(redirectAttributes, "保存采样包日志成功");
		return "redirect:" + Global.getAdminPath() + "/samplingFlowLog/samplingFlowLog/?repage";
	}

	@RequiresPermissions("sampling:samplingFlowLog:del")
	@RequestMapping(value = "delete")
	public String delete(SamplingFlowLog samplingFlowLog, RedirectAttributes redirectAttributes) {
		samplingFlowLogService.delete(samplingFlowLog);
		addMessage(redirectAttributes, "删除采样包日志成功");
		return "redirect:" + Global.getAdminPath() + "/samplingFlowLog/samplingFlowLog/?repage";
	}

}