package com.cku.oa.nativedog.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.nativedog.entity.NativeDogInfo;
import com.cku.oa.nativedog.service.NativeDogInfoService;

/**
 * 原生犬介绍Controller
 * @author lyy
 * @version 2018-12-11
 */
@Controller
@RequestMapping(value = "${adminPath}/nativedog/nativeDogInfo")
public class NativeDogInfoController extends BaseController {

	@Autowired
	private NativeDogInfoService nativeDogInfoService;
	
	@ModelAttribute
	public NativeDogInfo get(@RequestParam(required=false) String id) {
		NativeDogInfo entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = nativeDogInfoService.get(id);
		}
		if (entity == null){
			entity = new NativeDogInfo();
		}
		return entity;
	}
	
	@RequiresPermissions("nativedog:nativeDogInfo:view")
	@RequestMapping(value = {"list", ""})
	public String list(NativeDogInfo nativeDogInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<NativeDogInfo> page = nativeDogInfoService.findPage(new Page<NativeDogInfo>(request, response), nativeDogInfo); 
		model.addAttribute("page", page);
		return "oa/nativedog/nativeDogInfoList";
	}

	@RequiresPermissions("nativedog:nativeDogInfo:view")
	@RequestMapping(value = "form")
	public String form(NativeDogInfo nativeDogInfo, Model model) {
		model.addAttribute("nativeDogInfo", nativeDogInfo);
		return "oa/nativedog/nativeDogInfoForm";
	}

	@RequiresPermissions("nativedog:nativeDogInfo:edit")
	@RequestMapping(value = "save")
	public String save(NativeDogInfo nativeDogInfo, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, nativeDogInfo)){
			return form(nativeDogInfo, model);
		}
		nativeDogInfoService.save(nativeDogInfo);
		addMessage(redirectAttributes, "保存原生犬介绍成功");
		return "redirect:"+Global.getAdminPath()+"/nativedog/nativeDogInfo/?repage";
	}
	
	@RequiresPermissions("nativedog:nativeDogInfo:edit")
	@RequestMapping(value = "delete")
	public String delete(NativeDogInfo nativeDogInfo, RedirectAttributes redirectAttributes) {
		nativeDogInfoService.delete(nativeDogInfo);
		addMessage(redirectAttributes, "删除原生犬介绍成功");
		return "redirect:"+Global.getAdminPath()+"/nativedog/nativeDogInfo/?repage";
	}

}