/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.kennel.entity.KennelImage;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 犬舍图片DAO接口
 * 
 * @version 2021-01-13
 */
@MyBatisDao
public interface KennelImageDao extends CrudDao<KennelImage> {
	
	List<KennelImage> selectByKennelId(@Param("kennelId") String kennelId);
	
	void deleteByKennelId(@Param("kennelId") String kennelId);
	
	void insertBatch(@Param("dataList") List<KennelImage> images);
	
}