/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.vo.GroomerRegisterVO;
import com.cku.oa.handler.vo.HandlerRegisterVO;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.handler.service.HandlerRegisterService;
import com.cku.oa.handler.service.HandlerShowService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 报名Controller
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/handlerRegister")
public class HandlerRegisterController extends BaseController {

	@Autowired
	private HandlerRegisterService handlerRegisterService;
	@Autowired
	private GroomerShowRefereeService showRefereeService;
	@Autowired
	private HandlerShowService handlerShowService;
	@Autowired
	private PaymentOrderService paymentOrderService;

	@ModelAttribute
	public HandlerRegister get(@RequestParam(required = false) String id) {
		HandlerRegister entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = handlerRegisterService.get(id);
		}
		if (entity == null) {
			entity = new HandlerRegister();
		}
		return entity;
	}

	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = { "list", "" })
	public String list(HandlerRegister handlerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<HandlerRegister> page = handlerRegisterService.findPage(new Page<HandlerRegister>(request, response),
				handlerRegister);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<HandlerRegister> list = page.getList().stream().map(a -> {
			HandlerRegisterVO b = new HandlerRegisterVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		return "oa/handler/handlerRegisterList";
	}

	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "form")
	public String form(HandlerRegister handlerRegister, Model model) {
		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerRegisterForm";
	}
	
	private String converLevel(String [] arr) {
		String level = "";
		for(String str: arr) {
			level += str + ",";
		}
		return level.endsWith(",") ? level.substring(0,level.length() - 1) : level ;
	}
	
	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "formExaminer")
	public String formExaminer(HandlerRegister handlerRegister, Model model) {
		HandlerShow handlerShow = handlerShowService.getShow(handlerRegister.getShowCode());
		List<Dict> showLevels = DictUtils.getDictListValues("10".equals(handlerShow.getShowType())?"handler_test_level_examiner":"groomer_examiner_course_level",
				handlerShow.getTestLevel());
		// handlerShow.setShowLevels(showLevels);
		model.addAttribute("showLevels", showLevels);
		
		if(!StringUtils.isEmpty(handlerRegister.getShowGroup())) {
			handlerRegister.setShowGroups(handlerRegister.getShowGroup().split(","));
		}
		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerExaminerRegisterForm";
	}

	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "view")
	public String view(HandlerRegister handlerRegister, Model model) {
		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerRegisterView";
	}

	
	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "viewExaminer")
	public String viewExaminer(HandlerRegister handlerRegister, Model model) {
		if(!StringUtils.isEmpty(handlerRegister.getShowGroup())) {
			handlerRegister.setShowGroups(handlerRegister.getShowGroup().split(","));
		}
		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerExaminerRegisterView";
	}
	
	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "gradeView")
	public String gradeView(HandlerRegister handlerRegister, Model model) {
		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerRegisterGradeView";
	}

	@RequiresPermissions("handler:handlerRegister:edit")
	@RequestMapping(value = "save")
	public String save(HandlerRegister handlerRegister, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, handlerRegister)) {
			return form(handlerRegister, model);
		}
		String showType = handlerRegister.getHandlerShow().getShowType();
		if (!"12".equals(showType) && !"13".equals(showType)) {
			if (handlerRegister.getShowGroups() != null && handlerRegister.getShowGroups().length > 0) {
				handlerRegister.setShowGroup(converLevel(handlerRegister.getShowGroups()));
			}

		}
		handlerRegisterService.save(handlerRegister);
		addMessage(redirectAttributes, "保存报名成功");
		return "redirect:" + Global.getAdminPath() + "/handler/handlerRegister/?repage";
	}

	@RequiresPermissions("handler:handlerRegister:delete")
	@RequestMapping(value = "delete")
	public String delete(HandlerRegister handlerRegister, RedirectAttributes redirectAttributes) {
		handlerRegisterService.delete(handlerRegister);
		addMessage(redirectAttributes, "删除报名成功");
		return "redirect:" + Global.getAdminPath() + "/handler/handlerRegister/?repage";
	}

	/**
	 * 电话报名
	 * 
	 * @Author chaixueteng
	 * @2016年8月18日下午3:00:51
	 */
	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "mobileFrom")
	public String mobileFrom(HandlerRegister handlerRegister, RedirectAttributes redirectAttributes) {
		HandlerShow show = handlerShowService.getShow(handlerRegister.getShowCode());
		handlerRegisterService.validateBusiness(handlerRegister, show, "oa");
		handlerRegisterService.mobileSave(handlerRegister);
		return "redirect:" + Global.getAdminPath() + "/handler/handlerRegister/?repage";
	}

	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "mobileExaminerFrom")
	public String mobileExaminerFrom(HandlerRegister handlerRegister, RedirectAttributes redirectAttributes) {
		handlerRegisterService.mobileExaminerFrom(handlerRegister);
		return "redirect:" + Global.getAdminPath() + "/handler/handlerRegister/?repage";
	}

	
	/**
	 * 成绩管理
	 * 
	 * @Author chaixueteng
	 * @2016年7月14日下午5:27:18
	 */
	@RequiresPermissions("handler:grade:view")
	@RequestMapping(value = "grade")
	public String grade(HandlerRegister handlerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<HandlerRegister> page = handlerRegisterService.findGradePage(new Page<HandlerRegister>(request, response),
				handlerRegister);
		model.addAttribute("page", page);
		return "oa/handler/handlerRegisterGradeList";
	}

	/**
	 * 根据会员自动选择级别
	 * 
	 * @Author chaixueteng
	 * @2016年8月18日下午1:30:04
	 */
	@RequestMapping(value = "getMemberMessage")
	@ResponseBody
	public Object getMemberMessage(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		String memberCode = request.getParameter("memberCode");
		String level = request.getParameter("level");
		String handlerShowId = request.getParameter("handlerShowId");
		try {
			map = handlerRegisterService.getMemberMessage(memberCode, level, handlerShowId);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	
	@RequestMapping(value = "getMemberGroup")
	@ResponseBody
	public Object getMemberGroup(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		String memberCode = request.getParameter("memberCode");
		String level = request.getParameter("id");
		try {
			map = handlerRegisterService.validApple(memberCode, level);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
	


	/**
	 * 上传证件照
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequiresPermissions("handler:handlerRegister:audit")
	@RequestMapping(value = { "uploadImage" })
	public String uploadImage(HandlerRegister handlerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		model.addAttribute("groomerRegister", handlerRegister);
		return "oa/handler/handlerUploadImage";
	}

	/**
	 * 录入成绩页面
	 * 
	 * @Author chaixueteng
	 * @2016年7月21日下午2:40:43
	 */
	@RequestMapping(value = "inputForm")
	public String inputForm(String id, Model model) {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findHanlerReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		model.addAttribute("handlerRegister", handlerRegisterService.get(id));
		return "oa/handler/handlerRegisterGradeForm";
	}

	/**
	 * 成绩导入
	 * 
	 * @Author chaixueteng
	 * @2016年7月26日上午10:30:06
	 */
	@RequiresPermissions("handler:grade:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			// 成绩信息导入
			handlerRegisterService.importShows(file);
			addMessage(redirectAttributes, "导入成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/handler/handlerRegister/grade";
	}

	/**
	 * 保存证件照并审核通过
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequestMapping(value = "saveImage")
	@ResponseBody
	public Object saveImage(HandlerRegister handlerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			handlerRegisterService.saveImage(handlerRegister);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 上传证件照
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequiresPermissions("handler:handlerRegister:audit")
	@RequestMapping(value = { "toUpImage" })
	public String toUpImage(HandlerRegister handlerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerToUpImage";
	}

	/**
	 * 保存证件照并审核通过
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequestMapping(value = { "toReImage" })
	@ResponseBody
	public Object toReImage(HandlerRegister handlerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			handlerRegisterService.toReImage(handlerRegister);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 成绩录入
	 * 
	 * @Author chaixueteng
	 * @2016年7月26日上午10:30:06
	 */
	@RequiresPermissions("handlerRegister:grade:add")
	@RequestMapping(value = "inputGrade")
	@ResponseBody
	public Object inputGrade(HandlerRegister handlerRegister) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			logger.info("培训成绩录入 param : {}", JSONObjectUtils.toJsonString(handlerRegister));
			handlerRegisterService.saveGrade(handlerRegister);
		} catch (Exception e) {
			map.put("rc", "0");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 培训报名信息导出
	 * 
	 * @Author chaixueteng
	 * @2016年8月3日下午4:48:21
	 */
	@RequiresPermissions("handler:handlerRegister:export")
	@RequestMapping(value = "export")
	public String export(HandlerRegister handlerRegister, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		try {
			handlerRegisterService.export(handlerRegister, response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出报名信息失败！失败信息：" + e.getMessage());
		}
		return null;
	}

	/**
	 * 确认到场
	 * 
	 * @Author chaixueteng
	 * @2016年8月24日上午10:25:33
	 */
	@RequiresPermissions("handler:handlerRegister:match")
	@RequestMapping(value = "match")
	public String match(String id, String type, String remarks, RedirectAttributes redirectAttributes) {
		handlerRegisterService.match(id, type, remarks);
		if ("success".equals(type)) {
			addMessage(redirectAttributes, "确认到场");
		} else {
			addMessage(redirectAttributes, "确认中途离场");
		}
		return "redirect:" + Global.getAdminPath() + "/handler/handlerRegister/?repage";
	}

	/**
	 * 重复报名校验
	 * 
	 * @Author chaixueteng
	 * @2016年9月6日下午5:34:44
	 */
	@RequestMapping(value = "registerCheck")
	@ResponseBody
	public String registerCheck(HttpServletRequest request, HttpServletResponse response) {
		String showCode = request.getParameter("showCode");
		String memberCode = request.getParameter("memberCode");
		return handlerRegisterService.registerCheck(memberCode, showCode);

	}
	
	@RequestMapping(value = "registerExaminerCheck")
	@ResponseBody
	public String registerExaminerCheck(HttpServletRequest request, HttpServletResponse response) {
		String showCode = request.getParameter("showCode");
		String memberCode = request.getParameter("memberCode");
		return handlerRegisterService.registerExaminerCheck(memberCode, showCode);

	}

	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "formPartnerDog")
	public String formPartnerExam(HandlerRegister handlerRegister, Model model) {
		HandlerShow handlerShow = handlerShowService.getShow(handlerRegister.getShowCode());
		List<Dict> showLevels = DictUtils.getDictListValues("handler_test_level",
				handlerShow.getTestLevel());
		// handlerShow.setShowLevels(showLevels);
		model.addAttribute("showLevels", showLevels);


		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerPartnerDogRegisterForm";
	}

	@RequiresPermissions("handler:handlerRegister:view")
	@RequestMapping(value = "viewPartnerDog")
	public String viewPartnerDog(HandlerRegister handlerRegister, Model model) {
		model.addAttribute("handlerRegister", handlerRegister);
		return "oa/handler/handlerPartnerDogRegisterView";
	}

}